/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.controls.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public abstract class GuiModeSelector
extends GuiConfigure {
    public LittleGrid grid;
    public PlacementMode mode;

    public GuiModeSelector(ContainerSlotView view, LittleGrid grid, PlacementMode mode) {
        super("mode-selector", 150, 150, view);
        this.grid = grid;
        this.mode = mode;
        this.registerEventChanged(x -> {
            if (x.control.is("mode")) {
                TextBuilder builder = new TextBuilder();
                if (this.getMode().canPlaceStructures()) {
                    builder.text("" + ChatFormatting.BOLD).translate("placement.mode.placestructure").text("" + ChatFormatting.WHITE).newLine();
                }
                builder.translate(this.getMode().translatableKey() + ".tooltip");
                ((GuiLabel)this.get("text")).setTitle(builder.build());
            }
        });
    }

    public void create() {
        GuiParent place = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        this.add((GuiControl)place);
        GuiComboBoxMapped box = new GuiComboBoxMapped("mode", PlacementMode.map());
        box.select((Object)this.mode);
        place.add((GuiControl)box);
        place.add((GuiControl)new GuiLabel("text"));
        GuiGridConfig gridBox = new GuiGridConfig("grid", this.getPlayer(), this.grid, null);
        gridBox.select(this.grid);
        this.add((GuiControl)gridBox);
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)box));
    }

    public PlacementMode getMode() {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("mode");
        return (PlacementMode)box.getSelected((Object)PlacementMode.getDefault());
    }

    public abstract CompoundTag saveConfiguration(CompoundTag var1, LittleGrid var2, PlacementMode var3);

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        this.mode = this.getMode();
        this.grid = ((GuiGridConfig)this.get("grid", GuiGridConfig.class)).get();
        return this.saveConfiguration(nbt, this.grid, this.mode);
    }
}

