/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.ItemLittleGlove;
import team.creative.littletiles.common.item.glove.GloveMode;

public class GuiGlove
extends GuiConfigure {
    private GloveMode mode;
    private GloveMode before;
    private GloveMode after;
    public LittleGrid grid;

    public GuiGlove(GloveMode mode, ContainerSlotView view, int width, int height, LittleGrid grid) {
        super("glove", width, height, view);
        this.grid = grid;
        this.loadMode(mode);
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        ItemLittleGlove.setMode(nbt, this.mode);
        this.mode.saveGui(this, nbt);
        return nbt;
    }

    public void loadMode(GloveMode mode) {
        ArrayList modes = new ArrayList(GloveMode.REGISTRY.values());
        this.mode = mode;
        int index = modes.indexOf(mode);
        this.before = index == 0 ? (GloveMode)modes.get(modes.size() - 1) : (GloveMode)modes.get(index - 1);
        GloveMode gloveMode = this.after = index == modes.size() - 1 ? (GloveMode)modes.get(0) : (GloveMode)modes.get(index + 1);
        if (this.getParent() != null) {
            this.clear();
            this.clearEvents();
            this.create();
            this.reflow();
        }
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        this.flow = GuiFlow.STACK_Y;
        GuiParent upperBar = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(upperBar.setVAlign(VAlign.CENTER).setExpandableX());
        upperBar.add((GuiControl)new GuiButton("<<", x -> this.loadMode(this.before)).setTranslate("gui.previous"));
        upperBar.add(new GuiLabel("name").setTitle(this.mode.translatable()).setAlign(Align.CENTER).setExpandableX());
        upperBar.add((GuiControl)new GuiButton(">>", x -> this.loadMode(this.after)).setTranslate("gui.next"));
        this.mode.loadGui(this);
    }
}

