/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.gui.controls.GuiColorProgressBar;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBag;

public class GuiBag
extends GuiConfigure {
    public SimpleContainer bagInventory;
    public GuiInventoryGrid bagInventoryGui;
    public LittleIngredients bag;
    public SimpleContainer input = new SimpleContainer(1);
    private List<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
    private List<IGuiInventory> inventoriesInv = new ArrayList<IGuiInventory>();
    public final GuiSyncLocal<EndTag> RELOAD = this.getSyncHolder().register("reload", v -> {
        this.tool.changed();
        this.reinit();
    });
    public final GuiSyncLocal<StringTag> DROP_COLOR = this.getSyncHolder().register("drop_color", nbt -> {
        int amount;
        ItemColorIngredient.ColorIngredientType type = ItemColorIngredient.ColorIngredientType.getType(nbt.m_7916_());
        ColorIngredient color = this.bag.get(ColorIngredient.class);
        if (color != null && !color.isEmpty() && (amount = Math.min(type.getIngredient(color), ColorIngredient.BOTTLE_SIZE)) > 0) {
            type.setIngredient(color, type.getIngredient(color) - amount);
            Player player = this.getPlayer();
            LittleInventory inventory = new LittleInventory(player);
            ItemStack colorStack = ItemColorIngredient.generateItemStack(type, amount);
            if (!inventory.addStack(colorStack)) {
                LevelUtils.dropItem((Player)player, (ItemStack)colorStack);
            }
            this.saveBagInventory();
            this.RELOAD.send((Tag)EndTag.f_128534_);
            this.tick();
        }
    });

    public GuiBag(ContainerSlotView view) {
        super("bag", view);
        this.registerEventClick(x -> {
            if (x.control instanceof GuiColorProgressBar) {
                this.DROP_COLOR.send((Tag)StringTag.m_129297_((String)x.control.name));
            }
        });
    }

    protected GuiInventoryGrid addInventory(GuiInventoryGrid inventory) {
        this.inventories.add((IGuiInventory)inventory);
        this.inventoriesInv.add(0, (IGuiInventory)inventory);
        return inventory;
    }

    public void create() {
        this.RELOAD.send((Tag)EndTag.f_128534_);
        this.flow = GuiFlow.STACK_Y;
        this.tool.get().m_41784_();
        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
        ColorIngredient unit = this.bag.get(ColorIngredient.class);
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)upper);
        GuiParent left = new GuiParent();
        upper.add((GuiControl)left);
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        upper.add(right.setAlign(Align.STRETCH).setExpandableX());
        GuiInventoryGrid inputInventory = new GuiInventoryGrid("input", (Container)this.input).addListener(x -> {
            Player player = this.getPlayer();
            ItemStack input = this.input.m_8020_(0);
            Item patt5103$temp = input.m_41720_();
            if (patt5103$temp instanceof ILittleIngredientInventory) {
                ILittleIngredientInventory inv = (ILittleIngredientInventory)patt5103$temp;
                ingredients = inv.getInventory(input);
                boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                boolean containsColor = ingredients.contains(ColorIngredient.class);
                LittleIngredients remaining = this.bag.add(ingredients);
                ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
                if (remaining == null) {
                    remaining = new LittleIngredients();
                }
                if (remaining.copy().sub(ingredients.copy()) != null) {
                    if (containsBlocks) {
                        this.clearItemCache();
                        player.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
                    }
                    if (containsColor) {
                        player.m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                        this.RELOAD.send((Tag)EndTag.f_128534_);
                    }
                }
                inv.setInventory(input, remaining, null);
                this.saveBagInventory();
            } else {
                ingredients = LittleIngredient.extractWithoutCount(input, true);
                if (ingredients != null) {
                    ingredients.scale(input.m_41613_());
                    boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                    boolean containsColor = ingredients.contains(ColorIngredient.class);
                    LittleIngredients overflow = this.bag.add(ingredients);
                    if (overflow == null || !overflow.contains(BlockIngredient.class) && !overflow.contains(ColorIngredient.class)) {
                        input.m_41764_(0);
                        ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
                        LittleInventory inventory = new LittleInventory(player);
                        try {
                            if (overflow != null) {
                                inventory.give(overflow);
                            }
                        }
                        catch (NotEnoughIngredientsException.NotEnoughSpaceException notEnoughSpaceException) {
                            // empty catch block
                        }
                        if (containsBlocks) {
                            this.clearItemCache();
                            player.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
                        }
                        if (containsColor) {
                            player.m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                            this.RELOAD.send((Tag)EndTag.f_128534_);
                        }
                    } else {
                        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
                    }
                }
                this.saveBagInventory();
            }
        });
        right.add((GuiControl)inputInventory);
        int colorStorage = LittleTiles.CONFIG.general.bag.colorStorage;
        right.add((GuiControl)new GuiColorProgressBar("black", unit.black, colorStorage, Color.BLACK));
        right.add((GuiControl)new GuiColorProgressBar("cyan", unit.cyan, colorStorage, Color.CYAN));
        right.add((GuiControl)new GuiColorProgressBar("magenta", unit.magenta, colorStorage, Color.MAGENTA));
        right.add((GuiControl)new GuiColorProgressBar("yellow", unit.yellow, colorStorage, Color.YELLOW));
        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
        this.bagInventory = new SimpleContainer(LittleTiles.CONFIG.general.bag.inventorySize);
        this.bagInventoryGui = new GuiInventoryGrid(this.name, (Container)this.bagInventory, LittleTiles.CONFIG.general.bag.inventoryWidth, LittleTiles.CONFIG.general.bag.inventoryHeight, (c, i) -> new BagSlot((Container)c, (int)i));
        left.add((GuiControl)this.bagInventoryGui);
        this.add((GuiControl)this.addInventory((GuiInventoryGrid)new GuiPlayerInventoryGrid(this.getPlayer())).disableSlot(this.tool.index));
        this.addInventory(inputInventory);
        this.addInventory(this.bagInventoryGui);
    }

    public void clearItemCache() {
        for (int i = 0; i < this.bagInventoryGui.inventorySize(); ++i) {
            ((BagSlot)this.bagInventoryGui.getSlot((int)i).slot).resetCache();
        }
    }

    public boolean isExpandableX() {
        return false;
    }

    public boolean isExpandableY() {
        return false;
    }

    public void saveBagInventory() {
        ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
    }

    @Override
    public void closed() {
        super.closed();
        ItemStack stack = this.input.m_8020_(0);
        if (!stack.m_41619_()) {
            this.getPlayer().m_36176_(stack, true);
        }
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        return null;
    }

    @Override
    protected boolean supportsConfiguration() {
        return false;
    }

    public Iterable<IGuiInventory> inventoriesToInsert() {
        return this.inventories;
    }

    public Iterable<IGuiInventory> inventoriesToExract() {
        return this.inventoriesInv;
    }

    public class BagSlot
    extends Slot {
        private ItemStack cache;
        private boolean full;

        public BagSlot(Container container, int index) {
            super(container, index, 0, 0);
        }

        public void resetCache() {
            this.cache = null;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public BlockIngredientEntry getEntry() {
            List<BlockIngredientEntry> entries = GuiBag.this.bag.get(BlockIngredient.class).getContent();
            if (entries.size() > this.getSlotIndex()) {
                return entries.get(this.getSlotIndex());
            }
            return null;
        }

        public ItemStack m_7993_() {
            if (this.cache == null) {
                BlockIngredientEntry entry = this.getEntry();
                if (entry == null || entry.isEmpty()) {
                    this.cache = ItemStack.f_41583_;
                    this.full = false;
                } else {
                    this.cache = ItemBlockIngredient.of(entry);
                    this.cache.m_41764_(Math.max(1, (int)entry.value));
                    this.full = entry.value > 1.0;
                }
            }
            return this.cache;
        }

        public ItemStack m_6201_(int count) {
            ItemStack taken = this.cache;
            BlockIngredientEntry entry = this.getEntry();
            if (entry != null) {
                if (this.full) {
                    taken = entry.getBlockStack();
                    taken.m_41764_((int)entry.value);
                    entry.value -= (double)taken.m_41613_();
                } else {
                    entry.value = 0.0;
                }
                if (entry.isEmpty()) {
                    GuiBag.this.bag.get(BlockIngredient.class).getContent().remove(this.getSlotIndex());
                }
            }
            this.cache = null;
            GuiBag.this.saveBagInventory();
            return taken;
        }
    }
}

