/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.InventoryUtils;
import team.creative.littletiles.common.structure.type.LittleStorage;

public class GuiStorage
extends GuiLayer {
    public LittleStorage storage;
    public final StorageSize size;
    public final GuiSyncLocal<EndTag> SORT = this.getSyncHolder().register("sort", x -> {
        InventoryUtils.sortInventory((Container)this.storage.inventory, (boolean)false);
        ((GuiInventoryGrid)this.get("storage", GuiInventoryGrid.class)).setChanged();
    });

    public GuiStorage(LittleStorage storage, Player player) {
        super("little_storage");
        this.size = StorageSize.getSizeFromInventory((Container)storage.inventory);
        if (this.size.expanded) {
            this.setDim(this.size.guiWidth, this.size.guiHeight);
        }
        this.storage = storage;
        if (!player.m_9236_().f_46443_) {
            this.storage.openContainer(this);
        }
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.CENTER;
        GuiStorage parent = this;
        if (this.size.scrollbox) {
            parent = new GuiScrollY();
            if (this.size.expanded) {
                parent.setExpandableX();
            }
            this.add((GuiControl)parent);
        }
        GuiInventoryGrid inv = new GuiInventoryGrid("storage", (Container)this.storage.inventory, this.size.cols, (int)Math.ceil((double)this.storage.inventory.m_6643_() / (double)this.size.cols), (c, i) -> {
            if (i + 1 == this.storage.numberOfSlots && this.storage.lastSlotStackSize > 0) {
                return new Slot((Container)c, (int)i, 0, 0){

                    public int m_6641_() {
                        return GuiStorage.this.storage.lastSlotStackSize;
                    }
                };
            }
            return new Slot(c, i.intValue(), 0, 0);
        });
        parent.add((GuiControl)inv);
        inv.setChanged();
        if (this.size.sort) {
            this.add((GuiControl)new GuiButton("sort", x -> this.SORT.send((Tag)EndTag.f_128534_)).setTranslate("gui.sort"));
        }
        GuiPlayerInventoryGrid playerGrid = new GuiPlayerInventoryGrid(this.getPlayer());
        if (!this.size.expanded) {
            playerGrid.setUnexpandableX();
        }
        this.add((GuiControl)playerGrid);
    }

    public void inventoryChanged() {
        if (!this.isClient()) {
            ((GuiInventoryGrid)this.get("storage", GuiInventoryGrid.class)).setChanged();
        }
    }

    public void closed() {
        super.closed();
        if (this.storage != null && !this.isClient()) {
            this.storage.closeContainer(this);
        }
    }

    public static enum StorageSize {
        SMALL(9, 0, 0, false, false),
        LARGE(13, 250, 250, true, false),
        INFINITE(13, 250, 250, true, true);

        public final boolean scrollbox;
        public final int cols;
        public final boolean sort;
        public final int guiWidth;
        public final int guiHeight;
        public final boolean expanded;

        private StorageSize(int cols, int guiWidth, int guiHeight, boolean sort, boolean scrollbox) {
            this.cols = cols;
            this.guiWidth = guiWidth;
            this.guiHeight = guiHeight;
            this.scrollbox = scrollbox;
            this.sort = sort;
            this.expanded = guiWidth > 0;
        }

        public static StorageSize getSizeFromInventory(Container inventory) {
            if (inventory.m_6643_() <= 27) {
                return SMALL;
            }
            if (inventory.m_6643_() <= 117) {
                return LARGE;
            }
            return INFINITE;
        }
    }
}

