/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiTable;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCounter;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.config.LittleBuildingConfig;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;

public class GuiBuilder
extends GuiLayer {
    public LittleStructureBuilder builder;
    public final GuiSyncLocal<CompoundTag> CRAFT = this.getSyncHolder().register("craft", nbt -> {
        if (this.getPlayer().m_7500_() && this.builder.inventory.m_8020_(0).m_41619_() || this.builder.inventory.m_8020_(0).m_41720_() instanceof ItemLittleBlueprint) {
            int width = nbt.m_128451_("width");
            int height = nbt.m_128451_("height");
            int thickness = nbt.m_128451_("thickness");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
            LittleGrid grid = LittleGrid.get(nbt.m_128451_("grid"));
            this.builder.lastBlockState = block.m_49966_();
            this.builder.lastSizeX = width;
            this.builder.lastSizeY = height;
            this.builder.lastThickness = thickness;
            this.builder.lastGrid = grid.count;
            this.builder.lastStructureType = nbt.m_128461_("type");
            this.builder.updateStructure();
            LittleStructureBuilder.LittleStructureBuilderType type = (LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType);
            if (type != null) {
                Item patt3690$temp;
                ItemStack stack = this.builder.inventory.m_8020_(0);
                if (!LittleAction.needIngredients(this.getPlayer()) && stack.m_41619_()) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.BLUEPRINT.get());
                    this.builder.inventory.m_6836_(0, stack);
                }
                if ((patt3690$temp = stack.m_41720_()) instanceof ItemLittleBlueprint) {
                    ItemLittleBlueprint blue = (ItemLittleBlueprint)patt3690$temp;
                    blue.saveTiles(stack, type.construct(grid, width, height, thickness, block.m_49966_()));
                }
            }
        }
    });

    public GuiBuilder(LittleStructureBuilder builder) {
        super("structure_builder", 200, 200);
        this.builder = builder;
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        GuiTable table = new GuiTable();
        this.add(table.setExpandableX());
        GuiRow row = new GuiRow();
        table.addRow(row);
        GuiColumn col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.width", (GuiControl)new GuiCounter("width", this.builder.lastSizeX, 1, Integer.MAX_VALUE)));
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.height", (GuiControl)new GuiCounter("height", this.builder.lastSizeX, 1, Integer.MAX_VALUE)));
        row = new GuiRow();
        table.addRow(row);
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.thickness", (GuiControl)new GuiCounter("thickness", this.builder.lastThickness, 1, Integer.MAX_VALUE)));
        GuiStateButtonMapped gridSelect = new GuiStateButtonMapped("grid", LittleGrid.mapBuilder());
        gridSelect.select((Object)((LittleBuildingConfig)LittleTiles.CONFIG.build.get(this.getPlayer())).defaultGrid());
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.grid", (GuiControl)gridSelect));
        GuiComboBoxMapped box = new GuiComboBoxMapped("type", new TextMapBuilder().addEntrySet(LittleStructureBuilder.REGISTRY.entrySet(), x -> Component.m_237115_((String)("structure." + (String)x.getKey()))));
        box.select((Object)((LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType)));
        this.add(box.setExpandableX());
        GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(new ItemStack((ItemLike)this.builder.lastBlockState.m_60734_()));
        this.add(selector.setExpandableX());
        this.add((GuiControl)new GuiLeftRightBox().addLeft(new GuiLabel("failed").setTranslate("gui.structure_builder.failed").setVisible(false)).addRight((GuiControl)new GuiButton("craft", x -> {
            if (this.getPlayer().m_7500_() && this.builder.inventory.m_8020_(0).m_41619_() || this.builder.inventory.m_8020_(0).m_41720_() instanceof ItemLittleBlueprint) {
                this.get((String)"failed").visible = false;
                CompoundTag nbt = new CompoundTag();
                GuiCounter width = (GuiCounter)this.get("width");
                nbt.m_128405_("width", width.getValue());
                GuiCounter height = (GuiCounter)this.get("height");
                nbt.m_128405_("height", height.getValue());
                GuiCounter thickness = (GuiCounter)this.get("thickness");
                nbt.m_128405_("thickness", thickness.getValue());
                GuiComboBoxMapped type = (GuiComboBoxMapped)this.get("type");
                nbt.m_128359_("type", ((LittleStructureBuilder.LittleStructureBuilderType)type.getSelected()).type.id);
                GuiStateButtonMapped gridButton = (GuiStateButtonMapped)this.get("grid");
                LittleGrid grid = (LittleGrid)gridButton.getSelected();
                nbt.m_128405_("grid", grid.count);
                ItemStack stack = selector.getSelected();
                Block block = Block.m_49814_((Item)stack.m_41720_());
                nbt.m_128359_("block", block.m_204297_().m_205785_().m_135782_().toString());
                this.CRAFT.send((Tag)nbt);
            } else {
                this.get((String)"failed").visible = true;
            }
        }).setTranslate("gui.structure_builder.craft")));
        this.add((GuiControl)new GuiInventoryGrid("builder", (Container)this.builder.inventory));
        this.add((GuiControl)new GuiPlayerInventoryGrid(this.getPlayer()));
    }
}

