/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiProgressbar;
import team.creative.creativecore.common.gui.controls.simple.GuiShowItem;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.recipe.BlankOMaticRecipeRegistry;
import team.creative.littletiles.common.structure.type.premade.LittleBlankOMatic;

public class GuiBlankOMatic
extends GuiLayer {
    @OnlyIn(value=Dist.CLIENT)
    private static DisplayColor SELECTED_DISPLAY;
    public LittleBlankOMatic whitener;
    public SimpleContainer whiteInput = new SimpleContainer(1);
    public final GuiSyncLocal<IntTag> VOLUME = this.getSyncHolder().register("volume", x -> {
        ((GuiProgressbar)this.get((String)"volume", GuiProgressbar.class)).pos = x.m_7047_();
    });
    public final GuiSyncLocal<CompoundTag> CRAFT = this.getSyncHolder().register("craft", x -> {
        List<BlankOMaticRecipeRegistry.BleachRecipe> recipes;
        int amount = x.m_128451_("amount");
        ItemStack stack = this.whitener.inventory.m_8020_(0);
        int stackSize = 1;
        if (amount > 1) {
            stackSize = stack.m_41613_();
        }
        if (!(recipes = BlankOMaticRecipeRegistry.getRecipe(stack)).isEmpty()) {
            boolean result;
            int index = 0;
            int variant = x.m_128451_("variant");
            BlankOMaticRecipeRegistry.BleachRecipe selected = null;
            Block block = null;
            for (BlankOMaticRecipeRegistry.BleachRecipe recipe : recipes) {
                if (variant >= index + recipe.results.length) {
                    index += recipe.results.length;
                    continue;
                }
                selected = recipe;
                block = recipe.results[variant - index];
                break;
            }
            if (selected == null) {
                return;
            }
            boolean bl = result = !selected.isResult(stack);
            if (result && selected.needed > 0) {
                stackSize = Math.min(stackSize, this.whitener.whiteColor / selected.needed);
            }
            ItemStack newStack = new ItemStack(block, stackSize);
            stack.m_41774_(stackSize);
            this.whitener.inventory.m_6836_(0, stack);
            Player player = this.getPlayer();
            if (!player.m_36356_(newStack)) {
                player.m_36176_(newStack, false);
            }
            if (result && selected.needed > 0) {
                this.whitener.whiteColor -= stackSize * selected.needed;
            }
            this.VOLUME.send((Tag)IntTag.m_128679_((int)this.whitener.whiteColor));
        }
    });

    public GuiBlankOMatic(LittleBlankOMatic whitener) {
        super("whitener", 170, 200);
        this.whitener = whitener;
        this.whiteInput.m_19164_(x -> whitener.markDirty());
        this.registerEventChanged(x -> {
            if (x.control.is("variant")) {
                this.updateLabel();
            }
        });
    }

    public void init() {
        super.init();
        if (!this.isClient()) {
            this.VOLUME.send((Tag)IntTag.m_128679_((int)this.whitener.whiteColor));
        }
    }

    public void closed() {
        super.closed();
        PlayerUtils.addOrDrop((Player)this.getPlayer(), (Container)this.whiteInput);
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        GuiParent machine = new GuiParent();
        this.add((GuiControl)machine);
        GuiParent left = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        machine.add((GuiControl)left);
        GuiParent leftUpper = new GuiParent();
        left.add(leftUpper.setExpandable());
        leftUpper.add((GuiControl)new GuiInventoryGrid("inv", (Container)this.whitener.inventory, 1, 1, (c, i) -> new Slot((Container)c, (int)i, 0, 0){

            public boolean m_5857_(ItemStack stack) {
                return !BlankOMaticRecipeRegistry.getRecipe(stack).isEmpty();
            }
        }).addListener(x -> this.updateVariants()));
        leftUpper.add((GuiControl)new GuiVariantSelector("variant"));
        GuiParent leftLower = new GuiParent();
        left.add((GuiControl)leftLower);
        leftLower.add((GuiControl)new GuiInventoryGrid("input", (Container)this.whiteInput, 1, 1, (c, i) -> new Slot((Container)c, (int)i, 0, 0){

            public boolean m_5857_(ItemStack stack) {
                return BlankOMaticRecipeRegistry.getVolume(stack) > 0;
            }
        }).addListener(x -> {
            ItemStack stack = this.whiteInput.m_8020_(0);
            int volume = BlankOMaticRecipeRegistry.getVolume(stack);
            if (volume > 0) {
                boolean added = false;
                while (!stack.m_41619_() && volume + this.whitener.whiteColor <= BlankOMaticRecipeRegistry.bleachTotalVolume) {
                    stack.m_41774_(1);
                    this.whitener.whiteColor += volume;
                    added = true;
                }
                if (added) {
                    this.getPlayer().m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                }
                this.VOLUME.send((Tag)IntTag.m_128679_((int)this.whitener.whiteColor));
            }
        }));
        leftLower.add(new GuiProgressbar("volume", (double)this.whitener.whiteColor, (double)BlankOMaticRecipeRegistry.bleachTotalVolume).setExpandableX());
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        machine.add((GuiControl)right);
        right.add((GuiControl)new GuiButton("craft", x -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("amount", Screen.m_96638_() ? 2 : (Screen.m_96637_() ? 1 : 0));
            nbt.m_128405_("variant", ((GuiVariantSelector)this.get((String)"variant", GuiVariantSelector.class)).selected);
            this.CRAFT.send((Tag)nbt);
        }).setTranslate("gui.blancomatic.craft"));
        right.add((GuiControl)new GuiLabel("cost"));
        right.add(new GuiShowItem("item").setDim(50, 50));
        this.add((GuiControl)new GuiPlayerInventoryGrid(this.getPlayer()));
        this.updateVariants();
    }

    public void updateLabel() {
        GuiVariantSelector selector = (GuiVariantSelector)this.get("variant", GuiVariantSelector.class);
        Block block = selector.getSeleted();
        ItemStack stack = block != null ? new ItemStack((ItemLike)block, 1) : ItemStack.f_41583_;
        ((GuiShowItem)this.get((String)"item", GuiShowItem.class)).stack = stack;
        BlankOMaticRecipeRegistry.BleachRecipe recipe = selector.getSelectedRecipe();
        ((GuiLabel)this.get("cost", GuiLabel.class)).setTitle((Component)(recipe == null ? Component.m_237119_() : Component.m_237115_((String)"gui.blancomatic.cost").m_130946_(": " + recipe.needed)));
    }

    public void updateVariants() {
        GuiVariantSelector selector = (GuiVariantSelector)this.get("variant");
        selector.setRecipes(BlankOMaticRecipeRegistry.getRecipe(this.whitener.inventory.m_8020_(0)));
        this.updateLabel();
    }

    public static class GuiVariantSelector
    extends GuiParent {
        public List<Pair<BlankOMaticRecipeRegistry.BleachRecipe, Block>> states;
        private int selected = 0;

        public GuiVariantSelector(String name) {
            super(name, (GuiFlow)GuiFlow.FIT_X);
        }

        public ControlFormatting getControlFormatting() {
            return ControlFormatting.TRANSPARENT;
        }

        public BlankOMaticRecipeRegistry.BleachRecipe getSelectedRecipe() {
            if (this.selected >= 0 && this.selected < this.states.size()) {
                return (BlankOMaticRecipeRegistry.BleachRecipe)this.states.get((int)this.selected).key;
            }
            return null;
        }

        public Block getSeleted() {
            if (this.selected >= 0 && this.selected < this.states.size()) {
                return (Block)this.states.get((int)this.selected).value;
            }
            return null;
        }

        public void select(int index) {
            this.selected = index;
            for (int i = 0; i < this.controls.size(); ++i) {
                GuiSlotControlSelect slot = (GuiSlotControlSelect)((GuiChildControl)this.controls.get((int)i)).control;
                slot.selected = index == i;
            }
            this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
        }

        public void setRecipes(List<BlankOMaticRecipeRegistry.BleachRecipe> recipes) {
            this.clear();
            ArrayList<Pair<BlankOMaticRecipeRegistry.BleachRecipe, Block>> states = new ArrayList<Pair<BlankOMaticRecipeRegistry.BleachRecipe, Block>>();
            for (BlankOMaticRecipeRegistry.BleachRecipe recipe : recipes) {
                for (int j = 0; j < recipe.results.length; ++j) {
                    states.add((Pair<BlankOMaticRecipeRegistry.BleachRecipe, Block>)new Pair((Object)recipe, (Object)recipe.results[j]));
                }
            }
            this.states = states;
            for (int i = 0; i < states.size(); ++i) {
                this.add(new GuiSlotControlSelect(this, i, new ItemStack((ItemLike)((Pair)states.get((int)i)).value)).setTooltip(new TextBuilder().translate("gui.blancomatic.cost").text(": " + ((BlankOMaticRecipeRegistry.BleachRecipe)((Pair)states.get((int)i)).key).needed).build()));
            }
            if (this.selected >= states.size()) {
                this.select(0);
            } else {
                this.select(this.selected);
            }
        }
    }

    public static class GuiSlotControlSelect
    extends GuiSlotViewer {
        public final GuiVariantSelector selector;
        public final int index;
        public boolean selected = false;

        public GuiSlotControlSelect(GuiVariantSelector selector, int index, ItemStack stack) {
            super(stack);
            this.selector = selector;
            this.index = index;
        }

        @OnlyIn(value=Dist.CLIENT)
        public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
            if (this.selected) {
                if (SELECTED_DISPLAY == null) {
                    SELECTED_DISPLAY = new DisplayColor(-256);
                }
                return SELECTED_DISPLAY;
            }
            return super.getBorder(style, display);
        }

        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            this.selector.select(this.index);
            GuiSlotControlSelect.playSound((Holder.Reference)SoundEvents.f_12490_);
            return true;
        }
    }
}

