/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalVirtualNumberInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public class GuiSignalNodeVirtualNumberInput
extends GuiSignalNode {
    public List<GuiSignalConnection> tos = new ArrayList<GuiSignalConnection>();
    public int number;

    public GuiSignalNodeVirtualNumberInput() {
        super("0");
        this.number = 0;
    }

    public GuiSignalNodeVirtualNumberInput(SignalInputCondition.SignalInputVirtualNumber variable) throws ParseException {
        super("" + variable.number);
        this.number = variable.number;
        this.updateLabel();
    }

    public void updateLabel() {
        this.setTitle((Component)Component.m_237113_((String)("" + this.number)));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.controller()));
    }

    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        ((GuiDialogSignalVirtualNumberInput)LittleTilesGuiRegistry.VIRTUAL_NUMBER_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this.number, this);
        return true;
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node) {
        return false;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        this.tos.remove(connection);
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        this.tos.add(connection);
    }

    @Override
    public Iterator<GuiSignalConnection> iterator() {
        return this.tos.iterator();
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.tos;
    }

    @Override
    public void remove() {
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.tos)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public int indexOf(GuiSignalConnection connection) {
        return this.tos.indexOf(connection);
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        return new SignalInputCondition.SignalInputVirtualNumber(this.number);
    }
}

