/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeComponent;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.input.SignalInputVariable;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public class GuiSignalNodeInput
extends GuiSignalNodeComponent {
    public List<GuiSignalConnection> tos = new ArrayList<GuiSignalConnection>();
    public SignalTarget.SignalCustomIndex[] indexes;
    public int operator = 0;
    public SignalLogicOperator logic;
    public int[] pattern;
    public SignalInputCondition equation;

    public GuiSignalNodeInput(GuiSignalComponent component) {
        super(component);
    }

    public GuiSignalNodeInput(SignalInputVariable variable, GuiSignalComponent com) throws ParseException {
        super(com);
        SignalTarget target = variable.target.getNestedTarget();
        if (target instanceof SignalTarget.SignalTargetChildCustomIndex) {
            this.indexes = ((SignalTarget.SignalTargetChildCustomIndex)target).indexes;
        } else if (target instanceof SignalTarget.SignalTargetChildIndex) {
            this.indexes = new SignalTarget.SignalCustomIndex[]{new SignalTarget.SignalCustomIndexSingle(((SignalTarget.SignalTargetChildIndex)target).index)};
        } else if (target instanceof SignalTarget.SignalTargetChildIndexRange) {
            this.indexes = new SignalTarget.SignalCustomIndex[]{new SignalTarget.SignalCustomIndexRange(((SignalTarget.SignalTargetChildIndexRange)target).index, ((SignalTarget.SignalTargetChildIndexRange)target).index + ((SignalTarget.SignalTargetChildIndexRange)target).length - 1)};
        }
        if (variable instanceof SignalInputVariable.SignalInputVariableOperator) {
            this.operator = 1;
            this.logic = ((SignalInputVariable.SignalInputVariableOperator)variable).operator;
        } else if (variable instanceof SignalInputVariable.SignalInputVariablePattern) {
            this.operator = 2;
            this.pattern = ((SignalInputVariable.SignalInputVariablePattern)variable).indexes;
        } else if (variable instanceof SignalInputVariable.SignalInputVariableEquation) {
            this.operator = 3;
            this.equation = ((SignalInputVariable.SignalInputVariableEquation)variable).condition;
        } else {
            this.operator = 0;
        }
        this.updateLabel();
    }

    public void updateLabel() {
        Object caption = this.component.name();
        int length = 0;
        if (this.indexes != null) {
            String rangeText = this.getRange();
            if (rangeText.length() > 6) {
                rangeText = "...";
                length += 3;
            } else {
                length += rangeText.length();
            }
            caption = (String)caption + "[" + rangeText + "]";
        }
        Object operatorText = "";
        switch (this.operator) {
            case 1: {
                operatorText = "" + (Serializable)(this.logic == SignalLogicOperator.AND ? "&" : Character.valueOf(this.logic.operator));
                break;
            }
            case 2: {
                for (int i = 0; i < this.pattern.length; ++i) {
                    operatorText = (String)operatorText + (Serializable)(this.pattern[i] >= 2 ? "*" : Integer.valueOf(this.pattern[i]));
                }
                break;
            }
            case 3: {
                if (this.equation == null) break;
                operatorText = this.equation.write();
            }
        }
        if (((String)operatorText).length() + length > 10) {
            operatorText = "...";
        }
        if (!((String)operatorText).isEmpty()) {
            caption = (String)caption + "{" + (String)operatorText + "}";
        }
        this.setTitle((Component)Component.m_237113_((String)caption));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.controller()));
    }

    public String getRange() {
        if (this.indexes == null) {
            return "";
        }
        Object result = "";
        for (int i = 0; i < this.indexes.length; ++i) {
            if (i > 0) {
                result = (String)result + ",";
            }
            result = (String)result + this.indexes[i].write();
        }
        return result;
    }

    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        ((GuiDialogSignalInput)LittleTilesGuiRegistry.INPUT_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this);
        return true;
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node) {
        return false;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        this.tos.remove(connection);
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        this.tos.add(connection);
    }

    @Override
    public Iterator<GuiSignalConnection> iterator() {
        return this.tos.iterator();
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.tos;
    }

    @Override
    public void remove() {
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.tos)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public int indexOf(GuiSignalConnection connection) {
        return this.tos.indexOf(connection);
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        try {
            SignalTarget target = SignalTarget.parseTarget(new SignalPatternParser(this.component.name() + (String)(this.indexes != null ? "[" + this.getRange() + "]" : "")), false, false);
            switch (this.operator) {
                case 1: {
                    return new SignalInputVariable.SignalInputVariableOperator(target, this.logic);
                }
                case 2: {
                    return new SignalInputVariable.SignalInputVariablePattern(target, this.pattern);
                }
                case 3: {
                    if (this.equation == null) break;
                    return new SignalInputVariable.SignalInputVariableEquation(target, this.equation);
                }
            }
            return new SignalInputVariable(target);
        }
        catch (ParseException e) {
            throw new GeneratePatternException(this, "Invalid target");
        }
    }
}

