/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.util.List;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalController;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public abstract class GuiSignalNode
extends GuiButton
implements Iterable<GuiSignalConnection> {
    private int x;
    private int y;
    private boolean added = false;

    public GuiSignalNode(String caption) {
        super(caption, null);
        this.pressed = x -> {
            GuiSignalController controller = this.controller();
            if (x == 1 && this.removable()) {
                controller.removeNode(this);
                return;
            }
            if (controller.selected() != null) {
                controller.tryToggleConnectionToSelected(this);
            } else if (x == 0) {
                controller.drag(this);
            } else {
                controller.select(this);
            }
        };
        this.setTitle((Component)Component.m_237113_((String)caption));
    }

    public boolean hasUnderline() {
        return false;
    }

    public String getUnderline() {
        return null;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public void updatePosition(int col, int row) {
        this.x = col;
        this.y = row;
        this.added = true;
    }

    public boolean added() {
        return this.added;
    }

    public GuiSignalController controller() {
        return (GuiSignalController)this.getParent();
    }

    public void reset() {
        this.setTooltip(null);
        this.setDefaultColor(-1);
    }

    public void setError(String error) {
        this.setTooltip(error);
        this.setDefaultColor(-65536);
    }

    public boolean testForDoubleClick(Rect rect, double x, double y, int button) {
        return button != 1;
    }

    public boolean removable() {
        return true;
    }

    public abstract SignalInputCondition generateCondition(List<GuiSignalNode> var1) throws GeneratePatternException;

    public abstract void disconnect(GuiSignalConnection var1);

    public abstract GuiSignalConnection getConnectionTo(GuiSignalNode var1);

    public abstract boolean canConnectTo(GuiSignalNode var1);

    public abstract boolean canConnectFrom(GuiSignalNode var1);

    public abstract void connect(GuiSignalConnection var1);

    public abstract void remove();

    public abstract int indexOf(GuiSignalConnection var1);

    public abstract Iterable<GuiSignalConnection> toConnections();
}

