/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.ConsecutiveListIterator;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.FilterListIterator;
import team.creative.creativecore.common.util.type.itr.NestedIterator;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeNotOperator;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeOperator;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeOutput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeVirtualInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeVirtualNumberInput;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.input.SignalInputVariable;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;

public class GuiSignalController
extends GuiParent {
    protected int cellWidth = 60;
    protected int cellHeight = 40;
    public SmoothValue scrolledX = new SmoothValue(200L);
    public SmoothValue scrolledY = new SmoothValue(200L);
    public SmoothValue zoom = new SmoothValue(200L, 1.0);
    public double startScrollX;
    public double startScrollY;
    public int dragX;
    public int dragY;
    public boolean scrolling;
    private List<List<GuiChildControl>> grid = new ArrayList<List<GuiChildControl>>();
    public final List<GuiSignalComponent> inputs;
    private GuiSignalNodeOutput output;
    private GuiSignalNode dragged;
    private boolean startedDragging = false;
    private GuiSignalNode selected;
    private Rect controllerRect;

    public GuiSignalController(String name, GuiSignalComponent output, List<GuiSignalComponent> inputs) {
        super(name);
        this.inputs = inputs;
        this.setOutput(4, output);
    }

    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    public Iterator<GuiChildControl> iterator() {
        return new ConsecutiveIterator(new Iterator[]{this.hoverControls.iterator(), this.controls.iterator(), FilterIterator.skipNull((Iterator)new NestedIterator(this.grid))});
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public GuiChildControl find(GuiControl control) {
        GuiChildControl child = super.find(control);
        if (child != null) {
            return null;
        }
        return this.findNode(control);
    }

    public GuiChildControl findNode(GuiControl control) {
        for (List<GuiChildControl> rows : this.grid) {
            for (GuiChildControl child : rows) {
                if (child == null || child.control != control) continue;
                return child;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect contentRect, Rect realContentRect, double scale, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        this.scrolledX.tick();
        this.scrolledY.tick();
        this.zoom.tick();
        this.setScale(this.zoom.current());
        float controlScale = (float)this.scaleFactor();
        scale *= this.scaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(controlScale, controlScale, 1.0f);
        this.controllerRect = realContentRect;
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, (ListIterator)FilterListIterator.skipNull((ListIterator)new ConsecutiveListIterator(this.grid).goEnd()), scale, xOffset, yOffset, false);
        this.controllerRect = null;
        pose.m_85849_();
        super.renderContent(graphics, control, contentRect, realContentRect, scale, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderControl(GuiGraphics graphics, GuiChildControl child, GuiControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY, boolean hover) {
        if (control instanceof GuiSignalNode) {
            GuiSignalNode com = (GuiSignalNode)control;
            this.controllerRect.scissor();
            RenderSystem.disableDepthTest();
            if (com.hasUnderline()) {
                Font font = GuiRenderHelper.getFont();
                String underline = com.getUnderline();
                graphics.m_280488_(font, underline, child.getWidth() / 2 - font.m_92895_(underline) / 2, child.getHeight() + 4, -1);
            }
            this.renderConnections(graphics.m_280168_().m_85850_().m_252922_(), child, com, scale, realRect.inside((double)mouseX, (double)mouseY), mouseX, mouseY);
            RenderSystem.enableDepthTest();
            realRect.scissor();
        }
        super.renderControl(graphics, child, control, controlRect, realRect, scale, mouseX, mouseY, hover);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderConnections(Matrix4f matrix, GuiChildControl child, GuiSignalNode node, double scale, boolean hover, double mouseX, double mouseY) {
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)((float)(2.0 * scale)));
        RenderSystem.setShader(GameRenderer::m_172757_);
        double originX = child.rect.minX - (double)this.getContentOffset();
        double originY = child.rect.minY - (double)this.getContentOffset();
        for (GuiSignalConnection connection : node) {
            GuiChildControl other = this.findNode((GuiControl)(connection.from() == node ? connection.to() : connection.from()));
            if (!hover) {
                hover = other.control.toScreenRect(new Rect(0.0, 0.0, other.rect.getWidth(), other.rect.getHeight())).inside(mouseX, mouseY);
            }
            if (connection.from() == node) {
                this.renderConnection(matrix, child, other, hover, originX, originY);
                continue;
            }
            this.renderConnection(matrix, other, child, hover, originX, originY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderConnection(Matrix4f matrix, GuiChildControl from, GuiChildControl to, boolean hover, double originX, double originY) {
        int color = hover ? -1 : -16777216;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        builder.m_252986_(matrix, (float)(from.rect.maxX - originX), (float)((from.rect.minY + from.rect.maxY) * 0.5 - originY), 0.0f).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, (float)(to.rect.minX - originX), (float)((to.rect.minY + to.rect.maxY) * 0.5 - originY), 0.0f).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    private void flowCell(GuiChildControl child, int x, int y) {
        if (this.getParent() == null) {
            return;
        }
        int widthNode = Math.min(this.cellWidth, child.getPreferredWidth(this.cellWidth));
        child.setWidth(widthNode, this.cellWidth);
        child.setX(this.cellWidth * x + this.cellWidth / 2 - child.getWidth() / 2);
        child.flowX();
        int heightNode = Math.min(this.cellHeight, child.getPreferredHeight(this.cellHeight));
        child.setHeight(heightNode, this.cellHeight);
        child.setY(this.cellHeight * y + this.cellHeight / 2 - child.getHeight() / 2);
        child.flowY();
    }

    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        for (int x = 0; x < this.grid.size(); ++x) {
            List<GuiChildControl> rows = this.grid.get(x);
            for (int y = 0; y < rows.size(); ++y) {
                GuiChildControl child = rows.get(y);
                if (child == null) continue;
                int widthNode = Math.min(this.cellWidth, child.getPreferredWidth(this.cellWidth));
                child.setWidth(widthNode, this.cellWidth);
                child.setX(this.cellWidth * x + this.cellWidth / 2 - child.getWidth() / 2);
                child.flowX();
            }
        }
    }

    public void flowY(int width, int height, int preferred) {
        super.flowX(width, preferred);
        for (int x = 0; x < this.grid.size(); ++x) {
            List<GuiChildControl> rows = this.grid.get(x);
            for (int y = 0; y < rows.size(); ++y) {
                GuiChildControl child = rows.get(y);
                if (child == null) continue;
                int heightNode = Math.min(this.cellHeight, child.getPreferredHeight(this.cellHeight));
                child.setHeight(heightNode, this.cellHeight);
                child.setY(this.cellHeight * y + this.cellHeight / 2 - child.getHeight() / 2);
                child.flowY();
            }
        }
    }

    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        this.startedDragging = false;
        if (button == 2) {
            this.zoom.set(1.0);
            this.scrolledX.set(0.0);
            this.scrolledY.set(0.0);
            return true;
        }
        if (!super.mouseClicked(rect, x, y, button)) {
            this.select(null);
            this.scrolling = true;
            this.dragX = (int)x;
            this.dragY = (int)y;
            this.startScrollX = this.scrolledX.current();
            this.startScrollY = this.scrolledY.current();
        }
        return true;
    }

    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        if (!super.mouseScrolled(rect, x, y, delta)) {
            this.zoom.set(Mth.m_14008_((double)(this.zoom.aimed() + delta * 0.2), (double)0.1, (double)2.0));
        }
        return true;
    }

    public void mouseDragged(Rect rect, double x, double y, int button, double dragX, double dragY, double time) {
        super.mouseDragged(rect, x, y, button, dragX, dragY, time);
        if (time > 0.2 && this.dragged != null) {
            this.set(this.dragged, (int)Math.max(0.0, (x * this.scaleFactorInv() + this.scrolledX.current()) / (double)this.cellWidth), (int)Math.max(0.0, (y * this.scaleFactorInv() + this.scrolledY.current()) / (double)this.cellHeight));
            this.startedDragging = true;
        }
    }

    public void mouseMoved(Rect rect, double x, double y) {
        if (this.scrolling) {
            this.scrolledX.set(Mth.m_14008_((double)((double)this.dragX - x + this.startScrollX), (double)-40.0, (double)(this.sizeX() * this.cellWidth)));
            this.scrolledY.set(Mth.m_14008_((double)((double)this.dragY - y + this.startScrollY), (double)-40.0, (double)(this.sizeY() * this.cellHeight)));
        }
        super.mouseMoved(rect, x, y);
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        this.scrolling = false;
        if (this.dragged != null && !this.startedDragging) {
            this.select(this.dragged);
        }
        this.startedDragging = false;
        this.dragged = null;
    }

    public void setOutput(int cell, GuiSignalComponent output) {
        if (this.output != null) {
            this.removeNode(this.output);
        }
        this.output = new GuiSignalNodeOutput(output);
        this.setToFreeCell(cell, this.output);
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void setCondition(SignalInputCondition condition, GuiDialogSignal signal) {
        this.reset();
        try {
            ArrayList<List<GuiSignalNode>> parsed = new ArrayList<List<GuiSignalNode>>();
            GuiSignalNode node = this.fill(condition, signal, parsed, 0);
            for (int i = parsed.size() - 1; i >= 0; --i) {
                List rows = (List)parsed.get(i);
                for (int j = rows.size() - 1; j >= 0; --j) {
                    this.set((GuiSignalNode)rows.get(j), parsed.size() - i - 1, rows.size() - j - 1);
                }
            }
            this.setOutput(parsed.size(), this.output.component);
            GuiSignalConnection connection = new GuiSignalConnection(node, this.output);
            node.connect(connection);
            this.output.connect(connection);
            return;
        }
        catch (ParseException e) {
            this.reset();
            this.setOutput(4, this.output.component);
            return;
        }
    }

    private GuiSignalNode fill(SignalInputCondition condition, GuiDialogSignal signal, List<List<GuiSignalNode>> parsed, int level) throws ParseException {
        GuiSignalNode node;
        if (condition instanceof SignalInputCondition.SignalInputConditionNot || condition instanceof SignalInputCondition.SignalInputConditionNotBitwise) {
            boolean bitwise = condition instanceof SignalInputCondition.SignalInputConditionNotBitwise;
            node = new GuiSignalNodeNotOperator(bitwise);
            GuiSignalNode child = this.fill(bitwise ? ((SignalInputCondition.SignalInputConditionNotBitwise)condition).condition : ((SignalInputCondition.SignalInputConditionNot)condition).condition, signal, parsed, level + 1);
            GuiSignalConnection connection = new GuiSignalConnection(child, node);
            node.connect(connection);
            child.connect(connection);
        } else if (condition instanceof SignalLogicOperator.SignalInputConditionOperatorStackable) {
            node = new GuiSignalNodeOperator(((SignalLogicOperator.SignalInputConditionOperatorStackable)condition).operator());
            for (SignalInputCondition subCondition : ((SignalLogicOperator.SignalInputConditionOperatorStackable)condition).conditions) {
                GuiSignalNode child = this.fill(subCondition, signal, parsed, level + 1);
                GuiSignalConnection connection = new GuiSignalConnection(child, node);
                node.connect(connection);
                child.connect(connection);
            }
        } else if (condition instanceof SignalInputVariable) {
            SignalInputVariable in = (SignalInputVariable)condition;
            node = new GuiSignalNodeInput(in, signal.getInput(in.target));
        } else if (condition instanceof SignalInputCondition.SignalInputVirtualVariable) {
            SignalInputCondition.SignalInputVirtualVariable variable = (SignalInputCondition.SignalInputVirtualVariable)condition;
            node = new GuiSignalNodeVirtualInput(variable);
        } else if (condition instanceof SignalInputCondition.SignalInputVirtualNumber) {
            SignalInputCondition.SignalInputVirtualNumber number = (SignalInputCondition.SignalInputVirtualNumber)condition;
            node = new GuiSignalNodeVirtualNumberInput(number);
        } else {
            throw new ParseException("Invalid condition type", 0);
        }
        while (parsed.size() <= level) {
            parsed.add(new ArrayList());
        }
        parsed.get(level).add(node);
        return node;
    }

    public GuiSignalNodeVirtualInput addVirtualInput() {
        return this.setToFreeCell(0, new GuiSignalNodeVirtualInput());
    }

    public GuiSignalNodeVirtualNumberInput addVirtualNumberInput() {
        return this.setToFreeCell(0, new GuiSignalNodeVirtualNumberInput());
    }

    public GuiSignalNodeInput addInput(GuiSignalComponent input) {
        return this.setToFreeCell(0, new GuiSignalNodeInput(input));
    }

    public GuiSignalNodeNotOperator addNotOperator(boolean bitwise) {
        return this.setToFreeCell(1, new GuiSignalNodeNotOperator(bitwise));
    }

    public GuiSignalNodeOperator addOperator(SignalLogicOperator operator) {
        return this.setToFreeCell(1, new GuiSignalNodeOperator(operator));
    }

    public GuiSignalNode selected() {
        return this.selected;
    }

    public void drag(GuiSignalNode node) {
        this.dragged = node;
    }

    public void select(GuiSignalNode node) {
        if (this.selected != null) {
            this.selected.setDefaultColor(-1);
        }
        this.selected = node;
        if (this.selected != null) {
            this.selected.setDefaultColor(-256);
        }
    }

    public void tryToggleConnectionToSelected(GuiSignalNode node) {
        if (this.selected != node) {
            GuiSignalConnection connection = this.selected.getConnectionTo(node);
            if (connection != null) {
                connection.disconnect(this);
                this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
            } else if (this.selected.canConnectTo(node) && node.canConnectFrom(this.selected)) {
                connection = new GuiSignalConnection(this.selected, node);
                this.selected.connect(connection);
                node.connect(connection);
                this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
            }
        }
        this.select(null);
    }

    public SignalInputCondition generatePattern() throws GeneratePatternException {
        return this.output.generateCondition(new ArrayList<GuiSignalNode>());
    }

    public <T extends GuiSignalNode> T setToFreeCell(int startCol, T node) {
        for (int i = 0; i < 50 - startCol; ++i) {
            if (this.grid.size() <= i) {
                this.grid.add(new ArrayList());
            }
            if (i < startCol) continue;
            List<GuiChildControl> rows = this.grid.get(i);
            for (int j = 0; j < 50; ++j) {
                if (rows.size() <= j) {
                    rows.add(null);
                }
                if (rows.get(j) != null) continue;
                this.set(node, i, j);
                return node;
            }
        }
        throw new RuntimeException("There are no empty cells left");
    }

    public int sizeX() {
        return this.grid.size();
    }

    public int sizeY() {
        int rows = 0;
        for (int i = 0; i < this.grid.size(); ++i) {
            rows = Math.max(rows, this.grid.get(i).size());
        }
        return rows;
    }

    public void removeNode(GuiSignalNode node) {
        if (this.selected != null) {
            this.selected.setDefaultColor(-1);
        }
        this.selected = null;
        this.dragged = null;
        this.remove(node.x(), node.y());
        node.remove();
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public GuiChildControl remove(int col, int row) {
        List<GuiChildControl> rows;
        if (col < this.grid.size() && row < (rows = this.grid.get(col)).size()) {
            return rows.set(row, null);
        }
        return null;
    }

    public void set(GuiSignalNode node, int col, int row) {
        boolean added = node.added();
        node.setParent((IGuiParent)this);
        if (added && node.x() == col && node.y() == row) {
            return;
        }
        while (this.grid.size() <= col) {
            this.grid.add(new ArrayList());
        }
        List<GuiChildControl> rows = this.grid.get(col);
        while (rows.size() <= row) {
            rows.add(null);
        }
        if (rows.get(row) == null) {
            GuiChildControl child = null;
            if (added) {
                child = this.remove(node.x(), node.y());
            }
            if (child == null) {
                child = new GuiChildControl((GuiControl)node);
            }
            rows.set(row, child);
            node.updatePosition(col, row);
            this.flowCell(child, col, row);
        }
    }

    public void reset() {
        this.controls.clear();
        this.grid.clear();
        this.dragged = null;
        this.selected = null;
    }
}

