/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.premade;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.convertion.OldLittleTilesDataParser;
import team.creative.littletiles.common.grid.LittleGridException;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.structure.LittleStructureType;

public class GuiImport
extends GuiLayer {
    public GuiTextfield textfield;
    public Container importSlot = new SimpleContainer(1);
    public GuiSyncLocal<CompoundTag> IMPORT_DATA = this.getSyncHolder().register("import_data", nbt -> {
        ItemStack stack = this.importSlot.m_8020_(0);
        if (stack.m_41720_() instanceof ItemLittleBlueprint || this.getPlayer().m_7500_() && stack.m_41619_()) {
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)LittleTilesRegistry.BLUEPRINT.get());
                this.importSlot.m_6836_(0, stack);
            }
            try {
                ArrayList<Component> errors;
                if (OldLittleTilesDataParser.isOld(nbt)) {
                    nbt = OldLittleTilesDataParser.convert(nbt);
                }
                if (GuiImport.checkImport(errors = new ArrayList<Component>(), this.getPlayer(), LittleGroup.load(nbt))) {
                    CompoundTag stackTag = stack.m_41784_();
                    stackTag.m_128365_("c", (Tag)nbt);
                    ((GuiInventoryGrid)this.get("import", GuiInventoryGrid.class)).setChanged();
                } else {
                    LittleTiles.LOGGER.error("Failed to import structure ...");
                    for (Component component : errors) {
                        LittleTiles.LOGGER.error(component.getString());
                    }
                }
            }
            catch (OldLittleTilesDataParser.LittleConvertException | LittleGridException e) {
                e.printStackTrace();
            }
        }
    });

    public static boolean checkImport(List<Component> errors, Player player, LittleGroup group) {
        try {
            LittleStructureType type = group.getStructureType();
            if (type != null) {
                type.checkImport(errors, group, player);
            }
            for (LittleGroup child : group.children.all()) {
                GuiImport.checkImport(errors, player, child);
            }
        }
        catch (RuntimeException e) {
            errors.add((Component)Component.m_237110_((String)"gui.error.unknown", (Object[])new Object[]{e.getMessage()}));
        }
        return errors.isEmpty();
    }

    public GuiImport() {
        super("import");
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    public void closed() {
        super.closed();
        PlayerUtils.addOrDrop((Player)this.getPlayer(), (Container)this.importSlot);
    }

    public void create() {
        this.textfield = new GuiTextfield("import_textfield");
        this.add((GuiControl)this.textfield);
        this.textfield.setMaxStringLength(Integer.MAX_VALUE);
        GuiParent secondRow = new GuiParent();
        this.add((GuiControl)secondRow);
        secondRow.add((GuiControl)new GuiButton("paste_button", x -> {
            String text = Minecraft.m_91087_().f_91068_.m_90876_();
            if (text == null) {
                text = "";
            }
            this.textfield.setText(text);
        }).setTranslate("gui.paste"));
        secondRow.add((GuiControl)new GuiButton("import_button", x -> {
            try {
                ArrayList<Component> errors;
                CompoundTag nbt = TagParser.m_129359_((String)this.textfield.getText());
                CompoundTag tempNbt = nbt.m_6426_();
                if (OldLittleTilesDataParser.isOld(tempNbt)) {
                    tempNbt = OldLittleTilesDataParser.convert(tempNbt);
                }
                if (GuiImport.checkImport(errors = new ArrayList<Component>(), this.getPlayer(), LittleGroup.load(tempNbt))) {
                    this.IMPORT_DATA.send((Tag)nbt);
                } else {
                    MutableComponent component = null;
                    for (Component c : errors) {
                        if (component == null) {
                            component = Component.m_237119_();
                        } else {
                            component.m_130946_("\\n");
                        }
                        component.m_7220_(c);
                    }
                    GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"import_fail", (Component)component, (y, z) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            catch (OldLittleTilesDataParser.LittleConvertException e) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"could_not_convert", (Component)e.translatable(), (y, z) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            }
            catch (LittleGridException e) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"invalid_grid", (Component)e.translatable(), (y, z) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            }
        }).setTranslate("gui.import"));
        this.add((GuiControl)new GuiInventoryGrid("import", this.importSlot));
        this.add(new GuiPlayerInventoryGrid(this.getPlayer()).setUnexpandableX());
    }
}

