/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls.filter;

import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonContext;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.filter.TileFilters;
import team.creative.littletiles.common.gui.controls.filter.GuiElementFilter;

public class GuiElementFilterGroup
extends GuiElementFilter {
    protected final GuiListBoxBase<GuiElementFilter> list;
    protected GuiStateButtonMapped<GuiElementFilterOperator> operator;

    public GuiElementFilterGroup(Player player, GuiElementFilterOperator operator, BiFilter<IParentCollection, LittleTile> ... filters) {
        this.list = new GuiListBoxBase("list", true, new ArrayList<GuiElementFilter>(Stream.of(filters).map(x -> GuiElementFilter.of(player, (BiFilter<IParentCollection, LittleTile>)x)).toList()));
        this.add((GuiControl)this.list);
        this.list.setExpandable();
        this.list.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRules().minHeight(40));
        TextMapBuilder map = new TextMapBuilder();
        map.addComponent(x -> this.list.addItem((GuiControl)GuiElementFilter.of(this.getPlayer(), TileFilters.block(Blocks.f_50069_))), (Component)Component.m_237115_((String)"gui.filter.block"));
        map.addComponent(x -> this.list.addItem((GuiControl)GuiElementFilter.of(this.getPlayer(), TileFilters.tag((TagKey<Block>)BlockTags.f_13106_))), (Component)Component.m_237115_((String)"gui.filter.block_tag"));
        map.addComponent(x -> this.list.addItem((GuiControl)GuiElementFilter.of(this.getPlayer(), TileFilters.color(-1))), (Component)Component.m_237115_((String)"gui.filter.color"));
        map.addComponent(x -> this.list.addItem((GuiControl)GuiElementFilter.of(this.getPlayer(), TileFilters.or(new BiFilter[0]))), (Component)Component.m_237115_((String)"gui.filter.group"));
        GuiParent lower = new GuiParent();
        this.add((GuiControl)lower);
        this.operator = new GuiStateButtonMapped("operator", new TextMapBuilder().addComponent((Object[])GuiElementFilterOperator.values(), x -> Component.m_237115_((String)("gui.filter." + x.name().toLowerCase()))));
        lower.add((GuiControl)this.operator);
        this.operator.select((Object)operator);
        lower.add(new GuiButtonContext("add", map).setTranslate("gui.plus").setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRules().maxWidth(6).maxHeight(8)));
    }

    protected BiFilter<IParentCollection, LittleTile>[] getSubFilters() {
        ArrayList<BiFilter<IParentCollection, LittleTile>> filters = new ArrayList<BiFilter<IParentCollection, LittleTile>>();
        for (GuiElementFilter element : this.list.items()) {
            BiFilter<IParentCollection, LittleTile> filter = element.get();
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters.toArray(new BiFilter[filters.size()]);
    }

    @Override
    public BiFilter<IParentCollection, LittleTile> get() {
        return ((GuiElementFilterOperator)((Object)this.operator.getSelected((Object)GuiElementFilterOperator.OR))).create(this.getSubFilters());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GuiElementFilterOperator {
        OR{

            @Override
            public BiFilter<IParentCollection, LittleTile> create(BiFilter<IParentCollection, LittleTile>[] subFilters) {
                if (subFilters.length == 1) {
                    return subFilters[0];
                }
                return TileFilters.or(subFilters);
            }
        }
        ,
        AND{

            @Override
            public BiFilter<IParentCollection, LittleTile> create(BiFilter<IParentCollection, LittleTile>[] subFilters) {
                if (subFilters.length == 1) {
                    return subFilters[0];
                }
                return TileFilters.and(subFilters);
            }
        }
        ,
        NOT_OR{

            @Override
            public BiFilter<IParentCollection, LittleTile> create(BiFilter<IParentCollection, LittleTile>[] subFilters) {
                if (subFilters.length == 1) {
                    return TileFilters.not(subFilters[0]);
                }
                return TileFilters.not(TileFilters.or(subFilters));
            }
        }
        ,
        NOT_AND{

            @Override
            public BiFilter<IParentCollection, LittleTile> create(BiFilter<IParentCollection, LittleTile>[] subFilters) {
                if (subFilters.length == 1) {
                    return TileFilters.not(subFilters[0]);
                }
                return TileFilters.not(TileFilters.and(subFilters));
            }
        };


        public abstract BiFilter<IParentCollection, LittleTile> create(BiFilter<IParentCollection, LittleTile>[] var1);
    }
}

