/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.gui.AnimationPreview;
import team.creative.littletiles.mixin.client.render.LightTextureAccessor;

public interface GuiAnimationViewerStorage {
    public static final Camera FAKE_CAMERA = new Camera();

    public static int[][] makeLightBright() {
        int[][] pixels = new int[16][16];
        LightTextureAccessor texture = (LightTextureAccessor)Minecraft.m_91087_().f_91063_.m_109154_();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                pixels[x][y] = texture.getLightPixels().m_84985_(x, y);
                texture.getLightPixels().m_84988_(x, y, -1);
            }
        }
        texture.getLightTexture().m_117985_();
        return pixels;
    }

    public static void resetLight(int[][] pixels) {
        LightTextureAccessor texture = (LightTextureAccessor)Minecraft.m_91087_().f_91063_.m_109154_();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                texture.getLightPixels().m_84988_(x, y, pixels[x][y]);
            }
        }
        texture.getLightTexture().m_117985_();
    }

    public boolean isReady();

    public double longestSide();

    public AABB overall();

    public Vec3d center();

    public boolean highlightSelected();

    public void highlightSelected(boolean var1);

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<AnimationPreview> previewsToRender();

    @OnlyIn(value=Dist.CLIENT)
    default public void renderAll(PoseStack pose, Matrix4f projection, Minecraft mc) {
        int[][] pixels = GuiAnimationViewerStorage.makeLightBright();
        for (AnimationPreview preview : this.previewsToRender()) {
            this.renderPreview(pose, projection, preview, mc);
        }
        GuiAnimationViewerStorage.resetLight(pixels);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderPreview(PoseStack pose, Matrix4f projection, AnimationPreview preview, Minecraft mc) {
        preview.setupRendering(pose);
        preview.animation.getRenderManager().setupRender(FAKE_CAMERA, null, false, false);
        preview.animation.getRenderManager().compileChunks(FAKE_CAMERA);
        this.renderChunkLayer(preview, RenderType.m_110451_(), pose, projection);
        mc.m_91304_().m_119428_(TextureAtlas.f_118259_).setBlurMipmap(false, (Integer)mc.f_91066_.m_232119_().m_231551_() > 0);
        this.renderChunkLayer(preview, RenderType.m_110457_(), pose, projection);
        mc.m_91304_().m_119428_(TextureAtlas.f_118259_).restoreLastBlurMipmap();
        this.renderChunkLayer(preview, RenderType.m_110463_(), pose, projection);
        this.renderChunkLayer(preview, RenderType.m_110466_(), pose, projection);
    }

    default public void renderChunkLayer(AnimationPreview preview, RenderType layer, PoseStack pose, Matrix4f matrix) {
        layer.m_110185_();
        ShaderInstance shaderinstance = RenderSystem.getShader();
        for (int i = 0; i < 12; ++i) {
            shaderinstance.m_173350_("Sampler" + i, (Object)RenderSystem.getShaderTexture((int)i));
        }
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(pose.m_85850_().m_252922_());
        }
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(matrix);
        }
        if (shaderinstance.f_173312_ != null) {
            shaderinstance.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shaderinstance.f_173315_ != null) {
            shaderinstance.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shaderinstance.f_173316_ != null) {
            shaderinstance.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shaderinstance.f_173317_ != null) {
            shaderinstance.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shaderinstance.f_202432_ != null) {
            shaderinstance.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shaderinstance.f_173310_ != null) {
            shaderinstance.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shaderinstance.f_173319_ != null) {
            shaderinstance.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        shaderinstance.m_173363_();
        preview.animation.getRenderManager().renderChunkLayer(layer, pose, 0.0, 0.0, 0.0, matrix, shaderinstance.f_173320_);
        shaderinstance.m_173362_();
        VertexBuffer.m_85931_();
        layer.m_110188_();
    }
}

