/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientSupplier;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.LittleIngredients;

public class LittleGuiUtils {
    public static GuiStackSelector.StackCollector getCollector(Player player) {
        if (player.m_7500_()) {
            return new GuiStackSelector.CreativeCollector((GuiStackSelector.StackSelector)new LittleBlockSelector());
        }
        return new LittleBlockCollector((GuiStackSelector.StackSelector)new LittleBlockSelector());
    }

    public static class LittleBlockSelector
    extends GuiStackSelector.GuiBlockSelector {
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return LittleAction.isBlockValid(Block.m_49814_((Item)stack.m_41720_()).m_49966_());
            }
            return false;
        }
    }

    public static class LittleBlockCollector
    extends GuiStackSelector.InventoryCollector {
        public LittleBlockCollector(GuiStackSelector.StackSelector selector) {
            super(selector);
        }

        protected void collect(IItemHandler inventory, BlockIngredient ingredients) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41720_() instanceof ILittleIngredientInventory) {
                    LittleIngredients ingredientsInventory = ((ILittleIngredientInventory)stack.m_41720_()).getInventory(stack);
                    if (ingredientsInventory == null || !ingredientsInventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(ingredientsInventory.get(BlockIngredient.class));
                    continue;
                }
                LazyOptional optional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (!optional.isPresent()) continue;
                this.collect((IItemHandler)optional.orElseThrow(RuntimeException::new), ingredients);
            }
        }

        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList stacks = super.collect(player);
            BlockIngredient ingredients = new BlockIngredient();
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41720_() instanceof ILittleIngredientSupplier) {
                    ((ILittleIngredientSupplier)stack.m_41720_()).collect((HashMapList<String, ItemStack>)stacks, stack, player);
                    continue;
                }
                if (stack.m_41720_() instanceof ILittleIngredientInventory) {
                    LittleIngredients inventory = ((ILittleIngredientInventory)stack.m_41720_()).getInventory(stack);
                    if (inventory == null || !inventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(inventory.get(BlockIngredient.class));
                    continue;
                }
                LazyOptional optional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (!optional.isPresent()) continue;
                this.collect((IItemHandler)optional.orElseThrow(RuntimeException::new), ingredients);
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (BlockIngredientEntry ingredient : ingredients) {
                ItemStack stack = ingredient.getBlockStack();
                stack.m_41764_(Math.max(1, (int)ingredient.value));
                CompoundTag display = new CompoundTag();
                ListTag list = new ListTag();
                int blocks = (int)ingredient.value;
                double pixel = (ingredient.value - (double)blocks) * 4096.0;
                list.add((Object)StringTag.m_129297_((String)((String)(blocks > 0 ? blocks + " blocks " : "") + (String)(pixel > 0.0 ? Math.round(pixel * 100.0) / 100L + " pixel" : ""))));
                display.m_128365_("Lore", (Tag)list);
                stack.m_41700_("display", (Tag)display);
                newStacks.add(stack);
            }
            stacks.add((Object)"selector.ingredients", newStacks);
            return stacks;
        }
    }
}

