/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.grid;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.math.LittleUtils;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleGrid {
    public static final int BASE = 2;
    public static final int OVERALL_DEFAULT = 16;
    public static final int OVERALL_DEFAULT_COUNT2D = 256;
    public static final int OVERALL_DEFAULT_COUNT3D = 4096;
    public static final double OVERALL_DEFAULT_PIXEL_LENGTH = 0.0625;
    public static final String GRID_KEY = "grid";
    public static final LittleGrid MIN = new LittleGrid(1, 0);
    private static LittleGrid MAX = new LittleGrid(1, 0);
    private static int MAX_INDEX = 0;
    private static LittleGrid GRID_DEFAULT;
    private static final List<LittleGrid> GRIDS;
    private static final List<String> NAMES;
    private static final Int2ObjectMap<LittleGrid> GRID_MAP;
    private static List<String> UNMODFIAABLE_NAMES;
    private static int HIGHEST;
    private static TextMapBuilder<LittleGrid> STANDARD_TEXTMAP;
    public final int count;
    public final long count2d;
    public final long count3d;
    public final double pixelLength;
    public final float pixelLengthF;
    public final double halfPixelLength;
    public final double pixelVolume;
    protected final int index;
    public final boolean isDefault;
    public final LittleVec rotationCenter;
    public final int[] minSizes;

    private static void ensure(int highest) {
        int exponent = 2;
        for (int size = LittleGrid.GRIDS.get((int)(LittleGrid.GRIDS.size() - 1)).count * exponent; size <= highest; size *= exponent) {
            LittleGrid grid = new LittleGrid(size, GRIDS.size());
            GRIDS.add(grid);
            GRID_MAP.put(size, (Object)grid);
            NAMES.add("" + size);
            if (size != 16) continue;
            GRID_DEFAULT = grid;
        }
    }

    public static void configure(int highest) {
        if (highest < 1) {
            highest = 1;
        }
        LittleGrid.ensure(highest);
        HIGHEST = highest;
        MAX_INDEX = 0;
        while (MAX_INDEX + 1 < GRIDS.size() && LittleGrid.GRIDS.get((int)(LittleGrid.MAX_INDEX + 1)).count <= HIGHEST) {
            ++MAX_INDEX;
        }
        MAX = GRIDS.get(MAX_INDEX);
        UNMODFIAABLE_NAMES = Collections.unmodifiableList(NAMES);
        STANDARD_TEXTMAP = new TextMapBuilder().addComponent(GRIDS, x -> Component.m_237113_((String)("" + x.count)));
    }

    public static Iterable<LittleGrid> grids() {
        return GRIDS;
    }

    public static int gridCount() {
        return MAX_INDEX + 1;
    }

    public static LittleGrid gridByIndex(int index) {
        return GRIDS.get(index);
    }

    public static List<String> names() {
        return UNMODFIAABLE_NAMES;
    }

    public static TextMapBuilder<LittleGrid> mapBuilder() {
        return STANDARD_TEXTMAP;
    }

    public static LittleGrid overallDefault() {
        if (GRID_DEFAULT == null) {
            return MAX;
        }
        return GRID_DEFAULT;
    }

    public static LittleGrid get(int grid) {
        return (LittleGrid)GRID_MAP.get(grid);
    }

    public static LittleGrid getMax() {
        return MAX;
    }

    public static LittleGrid max(LittleGrid context, LittleGrid context2) {
        if (context.count >= context2.count) {
            return context;
        }
        return context2;
    }

    public static LittleGrid getOrThrow(CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_(GRID_KEY)) {
            LittleGrid grid = LittleGrid.get(nbt.m_128451_(GRID_KEY));
            if (grid != null) {
                return grid;
            }
            throw new RuntimeException("Grid " + nbt.m_128451_(GRID_KEY) + " is not available.");
        }
        return LittleGrid.overallDefault();
    }

    public static LittleGrid get(CompoundTag nbt) {
        LittleGrid grid;
        if (nbt != null && nbt.m_128441_(GRID_KEY) && (grid = LittleGrid.get(nbt.m_128451_(GRID_KEY))) != null) {
            return grid;
        }
        return LittleGrid.overallDefault();
    }

    protected LittleGrid(int gridSize, int index) {
        this.index = index;
        this.count = gridSize;
        this.pixelLength = 1.0 / (double)gridSize;
        this.pixelLengthF = (float)this.pixelLength;
        this.halfPixelLength = this.pixelLength * 0.5;
        this.count2d = (long)gridSize * (long)gridSize;
        this.count3d = (long)gridSize * this.count2d;
        this.pixelVolume = Math.max(Double.MIN_VALUE, 1.0 / (double)this.count3d);
        this.isDefault = 16 == gridSize;
        this.minSizes = new int[this.count];
        this.minSizes[0] = 2;
        for (int i = 1; i < this.minSizes.length; ++i) {
            this.minSizes[i] = this.count / IntMath.gcd((int)i, (int)this.count);
            if (this.minSizes[i] >= 2 && this.minSizes[i] % 2 == 0) continue;
            this.minSizes[i] = this.count;
        }
        this.rotationCenter = new LittleVec(this.count, this.count, this.count);
    }

    public void set(CompoundTag nbt) {
        if (!this.isDefault) {
            nbt.m_128405_(GRID_KEY, this.count);
        } else {
            nbt.m_128473_(GRID_KEY);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getMinGrid(int value) {
        return this.minSizes[Math.abs(value % this.count)];
    }

    public double toVanillaGrid(double grid) {
        return grid * this.pixelLength;
    }

    public double toVanillaGrid(long grid) {
        return (double)grid * this.pixelLength;
    }

    public double toVanillaGrid(int grid) {
        return (double)grid * this.pixelLength;
    }

    public float toVanillaGridF(float grid) {
        return grid * this.pixelLengthF;
    }

    public float toVanillaGridF(long grid) {
        return (float)grid * this.pixelLengthF;
    }

    public float toVanillaGridF(int grid) {
        return (float)grid * this.pixelLengthF;
    }

    public int toBlockOffset(long grid) {
        if (grid > 0L) {
            return (int)((double)grid * this.pixelLength);
        }
        return (int)Math.floor((double)grid * this.pixelLength);
    }

    public int toBlockOffset(int grid) {
        if (grid > 0) {
            return (int)((double)grid * this.pixelLength);
        }
        return (int)Math.floor((double)grid * this.pixelLength);
    }

    public boolean isAtEdge(double pos) {
        double result = Math.abs(pos % this.pixelLength);
        return LittleUtils.equals(result, 0.0) || LittleUtils.equals(result, this.pixelLength);
    }

    public int toGrid(int pos) {
        return pos * this.count;
    }

    public long toGridAccurate(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.count)) < 0.0) {
            return (long)Math.floor(pos);
        }
        return (long)pos;
    }

    public int toGrid(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.count)) < 0.0) {
            return (int)Math.floor(pos);
        }
        return (int)pos;
    }

    public int toGridUp(double pos) {
        return (int)Math.ceil(LittleUtils.round(pos * (double)this.count));
    }

    public int findNextValue(int value, int grid, boolean positive) {
        int index = value;
        if (value < 0 || value > this.count) {
            index = value % this.count;
        }
        if (index < 0) {
            index += this.count;
        }
        while (index < this.count && this.minSizes[index] > grid) {
            if (positive) {
                ++index;
                ++value;
                continue;
            }
            --index;
            --value;
        }
        return value;
    }

    public String toString() {
        return "" + this.count;
    }

    public LittleBox box() {
        return new LittleBox(0, 0, 0, this.count, this.count, this.count);
    }

    public LittleGrid next() {
        if (this.index + 1 >= GRIDS.size()) {
            return null;
        }
        return GRIDS.get(this.index + 1);
    }

    static {
        GRIDS = new ArrayList<LittleGrid>(Arrays.asList(MIN));
        NAMES = new ArrayList<String>(Arrays.asList("1"));
        GRID_MAP = new Int2ObjectArrayMap(new int[]{1}, (Object[])new LittleGrid[]{MIN});
        UNMODFIAABLE_NAMES = Collections.unmodifiableList(NAMES);
        HIGHEST = 1;
    }
}

