/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.filter;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;

public class TileFilters {
    public static BiFilter<IParentCollection, LittleTile> block(Block block) {
        return new TileBlockFilter(block);
    }

    public static BiFilter<IParentCollection, LittleTile> tag(TagKey<Block> tag) {
        return new TileTagFilter(tag);
    }

    public static BiFilter<IParentCollection, LittleTile> color(int color) {
        return new TileColorFilter(color);
    }

    public static BiFilter<IParentCollection, LittleTile> noStructure() {
        return new TileNoStructureFilter();
    }

    public static BiFilter<IParentCollection, LittleTile> and(BiFilter<IParentCollection, LittleTile> ... filters) {
        return BiFilter.and(filters);
    }

    public static BiFilter<IParentCollection, LittleTile> or(BiFilter<IParentCollection, LittleTile> ... filters) {
        return BiFilter.or(filters);
    }

    public static BiFilter<IParentCollection, LittleTile> not(BiFilter<IParentCollection, LittleTile> filter) {
        return BiFilter.not(filter);
    }

    public static BiFilter<IParentCollection, LittleTile> of(LittleElement element) {
        return TileFilters.and(TileFilters.block(element.getState().m_60734_()), TileFilters.color(element.color));
    }

    static {
        BiFilter.SERIALIZER.register("b", TileBlockFilter.class).register("c", TileColorFilter.class).register("no", TileNoStructureFilter.class).register("t", TileTagFilter.class);
    }

    public static class TileBlockFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final Block block;

        public TileBlockFilter(Block block) {
            this.block = block;
        }

        public TileBlockFilter(CompoundTag nbt) {
            this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("block", this.block.m_204297_().m_205785_().m_135782_().toString());
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock().is(this.block);
        }
    }

    public static class TileTagFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final TagKey<Block> tag;

        public TileTagFilter(TagKey<Block> tag) {
            this.tag = tag;
        }

        public TileTagFilter(CompoundTag nbt) {
            this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("tag")));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("tag", this.tag.f_203868_().toString());
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock().is(this.tag);
        }
    }

    public static class TileColorFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final int color;

        public TileColorFilter(int color) {
            this.color = color;
        }

        public TileColorFilter(CompoundTag nbt) {
            this.color = nbt.m_128451_("color");
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("color", this.color);
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.color == this.color;
        }
    }

    public static class TileNoStructureFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public TileNoStructureFilter() {
        }

        public TileNoStructureFilter(CompoundTag tag) {
        }

        public CompoundTag write() {
            return new CompoundTag();
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return !parent.isStructure();
        }
    }
}

