/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.level.little.LittleClientLevel;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.entity.LittleLevelRenderManager;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.level.LittleLevelEntityPhysic;
import team.creative.littletiles.common.level.little.LittleChunkSerializer;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.packet.entity.EntityOriginChanged;
import team.creative.littletiles.common.packet.entity.level.LittleLevelInitPacket;
import team.creative.littletiles.server.level.little.LittleServerLevel;
import team.creative.littletiles.server.level.little.SubServerLevel;

public class LittleLevelEntity
extends LittleEntity<LittleLevelEntityPhysic> {
    public BlockPos center;

    public LittleLevelEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LittleLevelEntity(Level level, BlockPos pos) {
        super((EntityType)LittleTilesRegistry.ENTITY_LEVEL.get(), level, new Vec3d((Vec3i)pos));
        this.center = pos;
    }

    @Override
    protected LittleSubLevel createLevel() {
        return SubServerLevel.createSubLevel(this.m_9236_());
    }

    @Override
    protected LittleLevelEntityPhysic createPhysic() {
        return new LittleLevelEntityPhysic(this);
    }

    @Override
    protected Vec3d loadCenter(CompoundTag nbt) {
        return new Vec3d((double)nbt.m_128451_("cX"), (double)nbt.m_128451_("cY"), (double)nbt.m_128451_("cZ"));
    }

    @Override
    public void loadEntity(CompoundTag nbt) {
        this.center = new BlockPos(nbt.m_128451_("cX"), nbt.m_128451_("cY"), nbt.m_128451_("cZ"));
        LittleServerLevel sub = (LittleServerLevel)((Object)this.subLevel);
        ListTag chunks = nbt.m_128437_("chunks", 10);
        for (int i = 0; i < chunks.size(); ++i) {
            CompoundTag chunk = chunks.m_128728_(i);
            sub.load(new ChunkPos(chunk.m_128451_("xPos"), chunk.m_128451_("zPos")), chunk);
        }
    }

    @Override
    public void saveEntity(CompoundTag nbt) {
        nbt.m_128405_("cX", this.center.m_123341_());
        nbt.m_128405_("cY", this.center.m_123342_());
        nbt.m_128405_("cZ", this.center.m_123343_());
        LittleServerLevel sub = (LittleServerLevel)((Object)this.subLevel);
        ListTag chunks = new ListTag();
        for (ChunkAccess chunkAccess : sub.chunks()) {
            chunks.add((Object)LittleChunkSerializer.write(sub, chunkAccess));
        }
        nbt.m_128365_("chunks", (Tag)chunks);
    }

    @Override
    public CreativePacket initClientPacket() {
        return new LittleLevelInitPacket(this);
    }

    public CompoundTag saveExtraClientData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("cX", this.center.m_123341_());
        nbt.m_128405_("cY", this.center.m_123342_());
        nbt.m_128405_("cZ", this.center.m_123343_());
        nbt.m_128365_("physic", (Tag)((LittleLevelEntityPhysic)this.physic).save());
        return nbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initSubLevelClient(CompoundTag extraData) {
        if (this.changedLevel) {
            this.changedLevel = false;
            return;
        }
        this.setSubLevel(this.createLevel(), new Vec3d((double)extraData.m_128451_("cX"), (double)extraData.m_128451_("cY"), (double)extraData.m_128451_("cZ")));
        ((LittleClientLevel)((Object)this.subLevel)).renderManager = new LittleLevelRenderManager(this);
        ((LittleLevelEntityPhysic)this.physic).load(extraData.m_128469_("physic"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return ((LittleClientLevel)((Object)this.subLevel)).renderManager;
    }

    @Override
    public void performTick() {
        super.performTick();
        if (!this.m_9236_().f_46443_ && ((LittleLevelEntityPhysic)this.physic).getBlockUpdateLevelSystem().isEntirelyEmpty()) {
            this.destroyAnimation();
        }
    }

    @Override
    public void syncMovement() {
        if (!(this.m_9236_().f_46443_ || this.origin.offXLast() == this.origin.offX() && this.origin.offYLast() == this.origin.offY() && this.origin.offZLast() == this.origin.offZ() && this.origin.rotXLast() == this.origin.rotX() && this.origin.rotYLast() == this.origin.rotY() && this.origin.rotZLast() == this.origin.rotZ())) {
            LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new EntityOriginChanged(this), (Entity)this);
        }
    }

    @Override
    public void internalTick() {
    }

    @Override
    public void initialTick() {
    }

    @Override
    public void startTracking(ServerPlayer player) {
    }

    @Override
    public void stopTracking(ServerPlayer player) {
    }

    public void setParentLevel(Level subLevel) {
        this.m_284535_(subLevel);
        this.getSubLevel().setParent(subLevel);
        if (this.origin != null) {
            this.getSubLevel().getOrigin().set(this.origin);
        }
        this.origin = this.subLevel.getOrigin();
        this.hasOriginChanged = true;
    }

    @Override
    public void prepareChangeLevel(Level oldLevel, Level newLevel) {
        this.setParentLevel(newLevel);
    }
}

