/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;

public class LittleAnimationLevelEntities
implements LevelEntityGetter<Entity> {
    private final Int2ObjectMap<Entity> byId = new Int2ObjectLinkedOpenHashMap();
    private final LevelCallback<Entity> callbacks;
    private final Map<UUID, Entity> byUuid = Maps.newHashMap();

    public LittleAnimationLevelEntities(LevelCallback<Entity> callback) {
        this.callbacks = callback;
    }

    public boolean addNewEntity(Entity entity) {
        return this.addEntity(entity, false);
    }

    public boolean addNewEntityWithoutEvent(Entity entity) {
        return this.addEntityWithoutEvent(entity, false);
    }

    private boolean addEntity(Entity entity, boolean loadedFromDisk) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, entity.m_9236_(), loadedFromDisk))) {
            return false;
        }
        return this.addEntityWithoutEvent(entity, loadedFromDisk);
    }

    private boolean addEntityWithoutEvent(Entity entity, boolean loadedFromDisk) {
        try {
            this.byUuid.putIfAbsent(entity.m_20148_(), entity);
            this.byId.put(entity.m_19879_(), (Object)entity);
            entity.m_141960_((EntityInLevelCallback)new Callback(entity));
            if (!loadedFromDisk) {
                this.callbacks.m_141989_((Object)entity);
            }
            this.startTracking(entity);
            this.startTicking(entity);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Entity get(int id) {
        return (Entity)this.byId.get(id);
    }

    public Entity get(UUID uuid) {
        return this.byUuid.get(uuid);
    }

    public Iterable<Entity> m_142273_() {
        return this.byId.values();
    }

    void startTicking(Entity entity) {
        this.callbacks.m_141987_((Object)entity);
    }

    void stopTicking(Entity entity) {
        this.callbacks.m_141983_((Object)entity);
    }

    void startTracking(Entity entity) {
        this.callbacks.m_141985_((Object)entity);
    }

    void stopTracking(Entity entity) {
        this.callbacks.m_141981_((Object)entity);
    }

    public <U extends Entity> void m_142690_(EntityTypeTest<Entity, U> test, AbortableIterationConsumer<U> consumer) {
        for (Entity entity : this.byId.values()) {
            Entity u = (Entity)test.m_141992_((Object)entity);
            if (u == null || !consumer.m_260972_((Object)u).m_261146_()) continue;
            return;
        }
    }

    public void m_142232_(AABB bb, Consumer<Entity> consumer) {
        for (Entity entity : this.byId.values()) {
            if (!entity.m_20191_().m_82381_(bb)) continue;
            consumer.accept(entity);
        }
    }

    public <U extends Entity> void m_142137_(EntityTypeTest<Entity, U> test, AABB bb, AbortableIterationConsumer<U> consumer) {
        for (Entity entity : this.byId.values()) {
            Entity u = (Entity)test.m_141992_((Object)entity);
            if (u == null || !entity.m_20191_().m_82381_(bb) || !consumer.m_260972_((Object)u).m_261146_()) continue;
            return;
        }
    }

    public void removeAll() {
        ArrayList<Entity> all = new ArrayList<Entity>(this.byUuid.values());
        for (Entity entity : all) {
            entity.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    class Callback
    implements EntityInLevelCallback {
        private final Entity entity;

        Callback(Entity entity) {
            this.entity = entity;
        }

        public void m_142044_() {
        }

        public void m_142472_(Entity.RemovalReason remove) {
            LittleAnimationLevelEntities.this.stopTicking(this.entity);
            LittleAnimationLevelEntities.this.stopTracking(this.entity);
            if (remove.m_146965_()) {
                LittleAnimationLevelEntities.this.callbacks.m_141986_((Object)this.entity);
            }
            this.entity.m_141960_(f_156799_);
            LittleAnimationLevelEntities.this.byUuid.remove(this.entity.m_20148_());
            LittleAnimationLevelEntities.this.byId.remove(this.entity.m_19879_());
        }
    }
}

