/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.render.entity.LittleAnimationRenderManager;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntityPhysic;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.math.location.LocalStructureLocation;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationInitPacket;
import team.creative.littletiles.common.packet.entity.animation.LittleBlockChange;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.connection.direct.StructureConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;

public class LittleAnimationEntity
extends LittleEntity<LittleAnimationEntityPhysic> {
    private StructureAbsolute center;
    private StructureConnection structure;

    public static void loadBE(LevelAccessor level, CompoundTag nbt, boolean update) {
        BlockState state = BlockTile.getState(nbt.m_128471_("ticking"), nbt.m_128471_("rendered"));
        BlockPos pos = BlockEntity.m_187472_((CompoundTag)nbt);
        level.m_7731_(pos, state, 0);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof BETiles) {
            BETiles be = (BETiles)entity;
            if (be.isClient()) {
                be.handleUpdate(nbt, !update);
                if (!update) {
                    be.render.tilesChanged();
                }
            } else {
                be.m_142466_(nbt);
                if (update) {
                    be.updateTiles(false, true);
                }
            }
        }
    }

    public static CompoundTag saveBE(BETiles tiles) {
        CompoundTag nbt = tiles.serializeNBT();
        nbt.m_128379_("ticking", tiles.isTicking());
        nbt.m_128379_("rendered", tiles.isRendered());
        return nbt;
    }

    public LittleAnimationEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LittleAnimationEntity(Level level, LittleAnimationLevel subLevel, StructureAbsolute center, Placement placement) throws LittleActionException {
        super((EntityType)LittleTilesRegistry.ENTITY_ANIMATION.get(), level, subLevel, center.rotationCenter);
        this.setCenter(center);
        this.beforeInitalPlacement();
        PlacementResult result = placement.place();
        if (result == null) {
            throw new LittleActionException("Could not be placed");
        }
        this.structure = new StructureConnection((Level)subLevel, new LocalStructureLocation(result.parentStructure));
        ((LittleAnimationEntityPhysic)this.physic).tick();
        ((LittleAnimationEntityPhysic)this.physic).updateBoundingBox();
    }

    protected void beforeInitalPlacement() {
        if (this.m_9236_().f_46443_) {
            this.getSubLevel().renderManager = LittleAnimationRenderManager.of(this);
        }
    }

    @Override
    protected LittleSubLevel createLevel() {
        return new LittleAnimationLevel(this.m_9236_());
    }

    @Override
    public LittleAnimationLevel getSubLevel() {
        return (LittleAnimationLevel)super.getSubLevel();
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
        if (this.getOrigin() != null) {
            this.getOrigin().setCenter(center.rotationCenter);
        }
        for (OrientationAwareEntity entity : this.children()) {
            entity.parentVecOriginChange(this.origin);
        }
    }

    public void setParentLevel(Level subLevel) {
        this.m_284535_(subLevel);
        this.getSubLevel().setParent(subLevel);
        this.getSubLevel().setOrigin(this.center.rotationCenter);
        if (this.origin != null) {
            this.getSubLevel().getOrigin().set(this.origin);
        }
        this.origin = this.subLevel.getOrigin();
        this.hasOriginChanged = true;
    }

    public StructureAbsolute getCenter() {
        return this.center;
    }

    public boolean is(LittleStructure structure) {
        return this.structure.is(structure);
    }

    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        return this.structure.getStructure();
    }

    public void applyChanges(Iterable<LittleBlockChange> changes) {
        for (LittleBlockChange change : changes) {
            if (change.isEmpty()) {
                this.subLevel.m_7471_(change.pos(), true);
                continue;
            }
            LittleAnimationEntity.loadBE((LevelAccessor)this.subLevel, change.block(), true);
        }
    }

    protected void loadBlocks(CompoundTag nbt) {
        LittleAnimationLevel level = this.getSubLevel();
        ListTag blocks = nbt.m_128437_("b", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            LittleAnimationEntity.loadBE((LevelAccessor)level, blocks.m_128728_(i), false);
        }
    }

    protected void saveBlocks(CompoundTag nbt) {
        ListTag blocks = new ListTag();
        for (BETiles block : this.getSubLevel()) {
            blocks.add((Object)LittleAnimationEntity.saveBE(block));
        }
        nbt.m_128365_("b", (Tag)blocks);
    }

    @Override
    protected Vec3d loadCenter(CompoundTag nbt) {
        this.center = new StructureAbsolute("c", nbt);
        return this.center.rotationCenter;
    }

    @Override
    public void loadEntity(CompoundTag nbt) {
        this.setCenter(this.center);
        this.loadBlocks(nbt);
        this.structure = new StructureConnection((Level)this.subLevel, nbt.m_128469_("s"));
    }

    @Override
    public void saveEntity(CompoundTag nbt) {
        nbt.m_128365_("s", (Tag)this.structure.write());
        this.center.save("c", nbt);
        this.saveBlocks(nbt);
    }

    @Override
    public CreativePacket initClientPacket() {
        return new LittleAnimationInitPacket(this);
    }

    public CompoundTag saveExtraClientData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("physic", (Tag)((LittleAnimationEntityPhysic)this.physic).save());
        this.saveBlocks(nbt);
        nbt.m_128365_("st", (Tag)this.structure.write());
        return nbt;
    }

    @Override
    public void prepareChangeLevel(Level oldLevel, Level newLevel) {
        this.setParentLevel(newLevel);
        try {
            StructureChildConnection parent = this.getStructure().getParent();
            if (parent != null) {
                parent.clearCache();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initSubLevelClient(StructureAbsolute absolute, CompoundTag extraData) {
        if (this.changedLevel) {
            this.changedLevel = false;
            return;
        }
        this.setSubLevel(new LittleAnimationLevel(this.m_9236_()), absolute.rotationCenter);
        this.setCenter(absolute);
        ((LittleAnimationLevel)this.subLevel).renderManager = LittleAnimationRenderManager.of(this);
        this.loadBlocks(extraData);
        ((LittleAnimationEntityPhysic)this.physic).load(extraData.m_128469_("physic"));
        this.structure = new StructureConnection((Level)this.subLevel, extraData.m_128469_("st"));
        ((LittleAnimationEntityPhysic)this.physic).updateBoundingBox();
    }

    @Override
    public void performTick() {
        super.performTick();
        if (!this.m_9236_().f_46443_ && this.getSubLevel().isEmpty()) {
            this.destroyAnimation();
        }
    }

    @Override
    public void internalTick() {
    }

    @Override
    public void initialTick() {
        this.getSubLevel().initialTick();
    }

    @Override
    protected LittleAnimationEntityPhysic createPhysic() {
        return new LittleAnimationEntityPhysic(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return ((LittleAnimationLevel)this.subLevel).renderManager;
    }

    @Override
    public void syncMovement() {
    }

    @Override
    public void startTracking(ServerPlayer player) {
        this.getSubLevel().entityCallback.addTrackingPlayer(player);
    }

    @Override
    public void stopTracking(ServerPlayer player) {
        this.getSubLevel().entityCallback.removeTrackingPlayer(player);
    }

    public void clearTrackingChanges() {
        this.getSubLevel().clearTrackingChanges();
    }
}

