/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.mixin.common.entity.PrimedTntAccessor;

public class PrimedSizedTnt
extends PrimedTnt {
    private static final EntityDataAccessor<String> TNTSIZE = SynchedEntityData.m_135353_(PrimedSizedTnt.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public LittleGrid grid;
    public LittleVec size;

    public PrimedSizedTnt(EntityType<? extends PrimedSizedTnt> type, Level level) {
        super(type, level);
    }

    public PrimedSizedTnt(Level level, double x, double y, double z, @Nullable LivingEntity igniter, LittleGrid grid, LittleVec size) {
        super((EntityType)LittleTilesRegistry.SIZED_TNT_TYPE.get(), level);
        this.m_6034_(x, y, z);
        double d0 = level.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        ((PrimedTntAccessor)((Object)this)).setOwner(igniter);
        this.setSize(grid, size);
        this.m_6210_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TNTSIZE, (Object)"1.1.1.1");
    }

    protected void m_7380_(CompoundTag tag) {
        this.size.save("size", tag);
        this.grid.set(tag);
        super.m_7380_(tag);
    }

    protected void m_7378_(CompoundTag tag) {
        this.size = new LittleVec("size", tag);
        this.grid = LittleGrid.get(tag);
        super.m_7378_(tag);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (TNTSIZE.equals(key)) {
            String data = (String)this.f_19804_.m_135370_(TNTSIZE);
            String[] coords = data.split("\\.");
            this.size = new LittleVec(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            this.grid = LittleGrid.get(Integer.parseInt(coords[3]));
        }
        super.m_7350_(key);
    }

    public void setSize(LittleGrid grid, LittleVec size) {
        this.f_19804_.m_135381_(TNTSIZE, (Object)(size.x + "." + size.y + "." + size.z + "." + grid.count));
        this.size = size;
        this.grid = grid;
    }

    protected void m_32103_() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), (float)(4.0 * this.size.getPercentVolume(this.grid)), Level.ExplosionInteraction.TNT);
    }
}

