/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.ILevelPositionProvider;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.LittleChair;

public class EntitySit
extends Entity
implements ILevelPositionProvider,
INoPushEntity {
    public static final EntityDataAccessor<CompoundTag> CONNECTION = SynchedEntityData.m_135353_(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<Float> CHAIRX = SynchedEntityData.m_135353_(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> CHAIRY = SynchedEntityData.m_135353_(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> CHAIRZ = SynchedEntityData.m_135353_(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private StructureChildConnection temp;

    public EntitySit(LittleChair chair, Level level, double x, double y, double z) {
        super((EntityType)LittleTilesRegistry.SIT_TYPE.get(), level);
        this.f_19804_.m_135381_(CHAIRX, (Object)Float.valueOf((float)x));
        this.f_19804_.m_135381_(CHAIRY, (Object)Float.valueOf((float)y));
        this.f_19804_.m_135381_(CHAIRZ, (Object)Float.valueOf((float)z));
        this.temp = chair.children.generateConnection(this);
        this.f_19804_.m_135381_(CONNECTION, (Object)this.temp.save(new CompoundTag()));
        this.m_6034_(x, y, z);
    }

    public EntitySit(EntityType<? extends EntitySit> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        StructureChildConnection connection = StructureChildConnection.load(this, (CompoundTag)this.f_19804_.m_135370_(CONNECTION), false);
        if (!this.m_9236_().f_46443_ && !this.m_20160_()) {
            try {
                LittleStructure structure = connection.getStructure();
                if (structure instanceof LittleChair) {
                    ((LittleChair)structure).setPlayer(null);
                }
                this.m_6074_();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structure) {}
        } else {
            try {
                LittleStructure structure = connection.getStructure();
                Level level = structure.getStructureLevel();
                if (level instanceof IOrientatedLevel) {
                    IOrientatedLevel l = (IOrientatedLevel)level;
                    Vec3d vec = new Vec3d((double)((Float)this.f_19804_.m_135370_(CHAIRX)).floatValue(), (double)((Float)this.f_19804_.m_135370_(CHAIRY)).floatValue(), (double)((Float)this.f_19804_.m_135370_(CHAIRZ)).floatValue());
                    l.getOrigin().transformPointToWorld(vec);
                    this.m_6034_(vec.x, vec.y, vec.z);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
    }

    public double m_6048_() {
        return 0.0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CONNECTION, (Object)new CompoundTag());
        this.f_19804_.m_135372_(CHAIRX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CHAIRY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CHAIRZ, (Object)Float.valueOf(0.0f));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("connection", (Tag)this.f_19804_.m_135370_(CONNECTION));
        nbt.m_128350_("chairX", ((Float)this.f_19804_.m_135370_(CHAIRX)).floatValue());
        nbt.m_128350_("chairY", ((Float)this.f_19804_.m_135370_(CHAIRY)).floatValue());
        nbt.m_128350_("chairZ", ((Float)this.f_19804_.m_135370_(CHAIRZ)).floatValue());
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19804_.m_135381_(CONNECTION, (Object)nbt.m_128469_("connection"));
        this.f_19804_.m_135381_(CHAIRX, (Object)Float.valueOf(nbt.m_128457_("chairX")));
        this.f_19804_.m_135381_(CHAIRY, (Object)Float.valueOf(nbt.m_128457_("chairY")));
        this.f_19804_.m_135381_(CHAIRZ, (Object)Float.valueOf(nbt.m_128457_("chairZ")));
    }

    @Override
    public Level getStructureLevel() {
        return this.m_9236_();
    }

    @Override
    public BlockPos getStructurePos() {
        return BlockPos.f_121853_;
    }

    @Override
    public void structureDestroyed() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

