/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.config;

import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.premade.ToggleableConfig;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.grid.LittleGrid;

public class LittleBuildingConfig {
    @CreativeConfig
    public HarvestLevel harvestLevelBlock = HarvestLevel.WOOD;
    @CreativeConfig
    public boolean editUnbreakable = false;
    @CreativeConfig
    @CreativeConfig.IntRange(min=0, max=255)
    public int minimumTransparency = 255;
    @CreativeConfig
    public ToggleableConfig<Integer> affectedBlockLimit = new ToggleableConfig((Object)2, true);
    @CreativeConfig
    public ToggleableConfig<Integer> editBlockLimit = new ToggleableConfig((Object)10, true);
    @CreativeConfig
    public ToggleableConfig<Integer> placeBlockLimit = new ToggleableConfig((Object)10, true);
    @CreativeConfig
    public ToggleableConfig<Integer> blueprintSizeLimit = new ToggleableConfig((Object)16, false);
    @CreativeConfig
    public ToggleableConfig<Integer> gridLimit = new ToggleableConfig((Object)32, false);
    @CreativeConfig
    public int defaultGrid = 16;

    public LittleBuildingConfig() {
    }

    public LittleBuildingConfig(boolean survival) {
        this.affectedBlockLimit.setEnabled(survival);
        this.editBlockLimit.setEnabled(survival);
        this.placeBlockLimit.setEnabled(survival);
        this.editUnbreakable = !survival;
        this.minimumTransparency = survival ? 255 : 0;
        this.harvestLevelBlock = survival ? HarvestLevel.STONE : HarvestLevel.DIAMOND;
    }

    public TextMapBuilder<LittleGrid> gridBuilder() {
        if (!this.gridLimit.isEnabled() || (Integer)this.gridLimit.value >= LittleGrid.getMax().count) {
            return LittleGrid.mapBuilder();
        }
        TextMapBuilder map = new TextMapBuilder();
        for (LittleGrid grid : LittleGrid.grids()) {
            if (grid.count > (Integer)this.gridLimit.value) break;
            map.addComponent((Object)grid, (Component)Component.m_237113_((String)("" + grid.count)));
        }
        return map;
    }

    public LittleGrid getOrDefault(int grid) {
        LittleGrid littleGrid = LittleGrid.get(grid);
        if (littleGrid != null) {
            return littleGrid;
        }
        return this.defaultGrid();
    }

    public LittleGrid defaultGrid() {
        LittleGrid grid = LittleGrid.get(this.defaultGrid);
        if (grid != null) {
            return grid;
        }
        return LittleGrid.overallDefault();
    }

    static {
        ConfigTypeConveration.registerTypeCreator(LittleBuildingConfig.class, () -> new LittleBuildingConfig());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HarvestLevel {
        DIAMOND{

            @Override
            public boolean is(Block block) {
                return true;
            }
        }
        ,
        IRON{

            @Override
            public boolean is(Block block) {
                return block.m_204297_().m_203656_(BlockTags.f_144285_) || !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        }
        ,
        STONE{

            @Override
            public boolean is(Block block) {
                return block.m_204297_().m_203656_(BlockTags.f_144286_) || !block.m_204297_().m_203656_(BlockTags.f_144285_) && !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        }
        ,
        WOOD{

            @Override
            public boolean is(Block block) {
                return !block.m_204297_().m_203656_(BlockTags.f_144286_) && !block.m_204297_().m_203656_(BlockTags.f_144285_) && !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        };


        public abstract boolean is(Block var1);
    }
}

