/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.parent;

import java.security.InvalidParameterException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.BlockParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.connection.IStructureConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.CorruptedLinkException;
import team.creative.littletiles.common.structure.exception.MissingBlockException;
import team.creative.littletiles.common.structure.exception.MissingStructureException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;

public class StructureParentCollection
extends ParentCollection
implements IStructureParentCollection,
IStructureConnection {
    private BlockParentCollection parent;
    private Object cache;
    private int structureIndex;
    private int attribute;
    private BlockPos relativePos;

    public StructureParentCollection(BlockParentCollection parent, int index, int attribute) {
        this.parent = parent;
        this.structureIndex = index;
        this.attribute = attribute;
    }

    public StructureParentCollection(BlockParentCollection parent, CompoundTag nbt) {
        this.parent = parent;
        this.load(nbt);
    }

    public void setParent(BlockParentCollection parent) {
        this.parent = parent;
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        if (nbt.m_128441_("structure")) {
            this.cache = this.setStructureNBT(nbt.m_128469_("structure"));
        } else {
            int[] array = nbt.m_128465_("coord");
            if (array.length == 3) {
                this.relativePos = new BlockPos(array[0], array[1], array[2]);
            } else {
                throw new InvalidParameterException("No valid coord given " + nbt);
            }
        }
        this.attribute = nbt.m_128451_("type");
        this.structureIndex = nbt.m_128451_("index");
    }

    @Override
    protected void saveExtra(CompoundTag nbt, LittleServerFace face) {
        if (this.isMain()) {
            CompoundTag structureNBT = new CompoundTag();
            ((LittleStructure)this.cache).save(structureNBT);
            nbt.m_128365_("structure", (Tag)structureNBT);
        } else {
            nbt.m_128385_("coord", new int[]{this.relativePos.m_123341_(), this.relativePos.m_123342_(), this.relativePos.m_123343_()});
        }
        nbt.m_128405_("type", this.attribute);
        nbt.m_128405_("index", this.structureIndex);
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    @Override
    public boolean isStructureChild(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        return this.getStructure().isChildOf(structure);
    }

    @Override
    public BETiles getBE() {
        return this.parent.be;
    }

    @Override
    public int getAttribute() {
        if (this.isMain()) {
            return this.attribute;
        }
        return this.attribute & 0xFF00FF;
    }

    @Override
    public void setAttribute(int attribute) {
        this.attribute = attribute;
        this.getBE().updateTiles(false, false);
    }

    @Override
    public BlockPos getStructurePosition() {
        return this.relativePos.m_121955_((Vec3i)this.getPos());
    }

    /*
     * Enabled aggressive block sorting
     */
    public LittleStructure setStructureNBT(CompoundTag nbt) {
        Object object;
        Object object2 = this.cache;
        if (object2 instanceof LittleStructure) {
            LittleStructure structure = (LittleStructure)object2;
            if (structure.type.id.equals(nbt.m_128461_("id"))) {
                structure.loadUpdatePacket(nbt);
                return (LittleStructure)this.cache;
            }
        }
        if ((object = this.cache) instanceof LittleStructure) {
            LittleStructure structure = (LittleStructure)object;
            structure.unload();
        }
        this.cache = StructureParentCollection.create(nbt, this);
        return (LittleStructure)this.cache;
    }

    @Override
    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.isMain()) {
            return (LittleStructure)this.cache;
        }
        BETiles te = this.getBlockEntity();
        if (!te.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = te.getStructure(this.structureIndex);
        if (structure != null) {
            if (structure == this || !structure.isMain()) {
                throw new CorruptedLinkException();
            }
            return structure.getStructure();
        }
        throw new MissingStructureException(te.m_58899_());
    }

    protected BETiles getBlockEntity() throws CorruptedConnectionException, NotYetConnectedException {
        BlockPos absoluteCoord;
        if (this.isMain()) {
            throw new RuntimeException("Main block cannot look for tileentity");
        }
        if (this.cache instanceof BETiles && !((BETiles)this.cache).m_58901_()) {
            return (BETiles)this.cache;
        }
        if (this.relativePos == null) {
            throw new CorruptedLinkException();
        }
        Level level = this.getBE().m_58904_();
        if (level.m_46805_(absoluteCoord = this.getStructurePosition())) {
            BlockEntity te = level.m_46745_(absoluteCoord).m_5685_(absoluteCoord, LevelChunk.EntityCreationType.IMMEDIATE);
            if (te instanceof BETiles) {
                this.cache = te;
                return (BETiles)this.cache;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    @Override
    public boolean isMain() {
        return this.relativePos == null;
    }

    @Override
    public boolean isClient() {
        return this.parent.isClient();
    }

    @Override
    public int getIndex() {
        return this.structureIndex;
    }

    @Override
    public boolean isRemoved() {
        return this.parent == null;
    }

    public void removed() {
        if (this.isMain()) {
            ((LittleStructure)this.cache).unload();
        }
        this.parent = null;
    }

    public void remove() {
        this.parent.removeStructure(this.structureIndex);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.isMain()) {
            ((LittleStructure)this.cache).unload();
        }
    }

    @Override
    public int totalSize() {
        return this.size();
    }

    @Deprecated
    public void mirrorForWarpDrive(Axis axis) {
        this.relativePos = axis.mirror(this.relativePos);
    }

    @Deprecated
    public void rotateForWarpDrive(Rotation rotation, int steps) {
        for (int rotationStep = 0; rotationStep < steps; ++rotationStep) {
            this.relativePos = rotation.transform(this.relativePos);
        }
    }

    public static void setRelativePos(StructureParentCollection list, BlockPos pos) {
        list.relativePos = pos;
    }

    public static void updateStatus(StructureParentCollection list) {
        if (list.cache != null) {
            list.relativePos = null;
        }
    }

    public static LittleStructure create(CompoundTag nbt, StructureParentCollection mainBlock) {
        if (nbt == null) {
            return null;
        }
        String id = nbt.m_128461_("id");
        LittleStructureType type = (LittleStructureType)LittleStructureRegistry.REGISTRY.get(id);
        LittleStructure structure = type.createStructure(mainBlock);
        structure.load(nbt);
        return structure;
    }
}

