/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.parent;

import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollectionSafe;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public abstract class ParentCollection
extends LittleCollectionSafe
implements IParentCollection {
    private int collisionChecks = 0;

    protected boolean checkCollision() {
        return this.collisionChecks > 0;
    }

    @Override
    protected void added(LittleElement tile) {
        if (tile.checkEntityCollision()) {
            ++this.collisionChecks;
        }
    }

    @Override
    protected void refresh() {
        this.collisionChecks = 0;
        for (LittleTile tile : this) {
            this.added(tile);
        }
    }

    @Override
    protected void removed(LittleElement tile) {
        if (tile.checkEntityCollision()) {
            --this.collisionChecks;
        }
    }

    public void load(CompoundTag nbt) {
        this.clear();
        LittleCollection.loadExtended(this, nbt.m_128469_("tiles"));
        this.loadExtra(nbt);
    }

    protected abstract void loadExtra(CompoundTag var1);

    public CompoundTag save(LittleServerFace face) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("tiles", (Tag)LittleCollection.saveExtended(this, face));
        this.saveExtra(nbt, face);
        return nbt;
    }

    protected abstract void saveExtra(CompoundTag var1, LittleServerFace var2);

    public Iterable<LittleTile> filter(final BiFilter<IParentCollection, LittleTile> selector) {
        return new IterableIterator<LittleTile>(){
            Iterator<LittleTile> itr;
            LittleTile next;
            {
                this.itr = ParentCollection.this.content.iterator();
                this.next = null;
            }

            public boolean hasNext() {
                while (this.next == null && this.itr.hasNext()) {
                    LittleTile test = this.itr.next();
                    if (!selector.is((Object)ParentCollection.this, (Object)test)) continue;
                    this.next = test;
                }
                return this.next != null;
            }

            public LittleTile next() {
                LittleTile result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    @Override
    public abstract BETiles getBE();

    @Override
    public abstract boolean isStructure();

    @Override
    public boolean isStructureChildSafe(LittleStructure structure) {
        try {
            return this.isStructureChild(structure);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return false;
        }
    }

    @Override
    public abstract boolean isStructureChild(LittleStructure var1) throws CorruptedConnectionException, NotYetConnectedException;

    @Override
    public abstract boolean isMain();

    @Override
    public abstract LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException;

    @Override
    public abstract int getAttribute();

    @Override
    public abstract boolean isClient();

    public void unload() {
    }
}

