/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.parent;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.CorruptedLinkException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class BlockParentCollection
extends ParentCollection {
    public BETiles be;
    private final ConcurrentHashMap<Integer, StructureParentCollection> structures = new ConcurrentHashMap();
    private int attributes = 0;
    private final boolean client;

    public BlockParentCollection(BETiles be, boolean client) {
        this.be = be;
        this.client = client;
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("children", 10);
        HashMap<Integer, StructureParentCollection> previous = new HashMap<Integer, StructureParentCollection>(this.structures);
        this.structures.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag childNBT = list.m_128728_(i);
            StructureParentCollection child = previous.remove(childNBT.m_128451_("index"));
            if (child == null) {
                child = new StructureParentCollection(this, childNBT);
            } else {
                child.load(childNBT);
            }
            this.structures.put(child.getIndex(), child);
        }
        for (StructureParentCollection child : previous.values()) {
            child.unload();
        }
        this.reloadAttributes();
    }

    @Override
    protected void saveExtra(CompoundTag nbt, LittleServerFace face) {
        ListTag list = new ListTag();
        for (StructureParentCollection child : this.structures.values()) {
            list.add((Object)child.save(face));
        }
        nbt.m_128365_("children", (Tag)list);
    }

    public int countStructures() {
        return this.structures.size();
    }

    public boolean removeStructure(int index) {
        StructureParentCollection list = this.structures.remove(index);
        if (list != null) {
            list.removed();
        }
        boolean removed = list != null;
        this.reloadAttributes();
        return removed;
    }

    public void addStructure(int index, StructureParentCollection list) {
        if (this.structures.containsKey(index)) {
            throw new IllegalArgumentException("index '" + index + "' already exists");
        }
        this.structures.put(index, list);
    }

    public StructureParentCollection addStructure(int index, int attribute) {
        if (this.structures.containsKey(index)) {
            throw new IllegalArgumentException("index '" + index + "' already exists");
        }
        StructureParentCollection list = new StructureParentCollection(this, index, attribute);
        this.structures.put(index, list);
        this.reloadAttributes();
        return list;
    }

    public Iterable<LittleStructure> loadedStructures() {
        return new IterableIterator<LittleStructure>(){
            Iterator<StructureParentCollection> itr;
            StructureParentCollection next;
            {
                this.itr = BlockParentCollection.this.structures.values().iterator();
                this.next = null;
            }

            public boolean hasNext() {
                while (this.next == null) {
                    if (!this.itr.hasNext()) {
                        return false;
                    }
                    this.next = this.itr.next();
                    try {
                        this.next.checkConnection();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException e) {
                        this.next = null;
                    }
                }
                return this.next != null;
            }

            public LittleStructure next() {
                try {
                    StructureParentCollection temp = this.next;
                    this.next = null;
                    return temp.getStructure();
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Iterable<IStructureParentCollection> structures() {
        return new IterableIterator<IStructureParentCollection>(){
            Iterator<StructureParentCollection> iterator;
            {
                this.iterator = BlockParentCollection.this.structures.values().iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public IStructureParentCollection next() {
                return this.iterator.next();
            }
        };
    }

    public Iterable<StructureParentCollection> structuresReal() {
        return this.structures.values();
    }

    public Iterable<LittleStructure> loadedStructures(final int attribute) {
        if (LittleStructureAttribute.listener(attribute) || LittleStructureAttribute.active(attribute)) {
            return new IterableIterator<LittleStructure>(){
                public Iterator<StructureParentCollection> iterator;
                public LittleStructure next;
                {
                    this.iterator = BlockParentCollection.this.structures.values().iterator();
                    this.findNext();
                }

                public void findNext() {
                    while (this.iterator.hasNext()) {
                        StructureParentCollection structure = this.iterator.next();
                        if ((structure.getAttribute() & attribute) == 0) continue;
                        try {
                            this.next = structure.getStructure();
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                            // empty catch block
                        }
                        return;
                    }
                    this.next = null;
                }

                public boolean hasNext() {
                    return this.next != null;
                }

                public LittleStructure next() {
                    LittleStructure toReturn = this.next;
                    this.findNext();
                    return toReturn;
                }
            };
        }
        return new IterableIterator<LittleStructure>(){

            public boolean hasNext() {
                return false;
            }

            public LittleStructure next() {
                return null;
            }
        };
    }

    public boolean hasTicking() {
        return LittleStructureAttribute.ticking(this.attributes);
    }

    public boolean hasRendered() {
        return LittleStructureAttribute.tickRendering(this.attributes);
    }

    public boolean hasCollisionListener() {
        if (this.checkCollision() || LittleStructureAttribute.collisionListener(this.attributes)) {
            return true;
        }
        for (StructureParentCollection child : this.structures.values()) {
            if (!child.checkCollision()) continue;
            return true;
        }
        return false;
    }

    public Iterable<IParentCollection> groups() {
        return new IterableIterator<IParentCollection>(){
            IParentCollection current;
            Iterator<IStructureParentCollection> children;
            {
                this.current = BlockParentCollection.this;
                this.children = BlockParentCollection.this.structures().iterator();
            }

            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                if (!this.children.hasNext()) {
                    return false;
                }
                this.current = this.children.next();
                return true;
            }

            public IParentCollection next() {
                IParentCollection result = this.current;
                this.current = null;
                return result;
            }
        };
    }

    public Iterable<Pair<IParentCollection, LittleTile>> allTiles() {
        final Iterator<IParentCollection> iterator = this.groups().iterator();
        return new IterableIterator<Pair<IParentCollection, LittleTile>>(){
            Iterator<LittleTile> inBlock = null;
            Pair<IParentCollection, LittleTile> pair = null;

            public boolean hasNext() {
                while (this.inBlock == null || !this.inBlock.hasNext()) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    IParentCollection list = (IParentCollection)iterator.next();
                    this.pair = new Pair((Object)list, null);
                    this.inBlock = list.iterator();
                }
                return true;
            }

            public Pair<IParentCollection, LittleTile> next() {
                this.pair.setValue((Object)this.inBlock.next());
                return this.pair;
            }
        };
    }

    @Override
    public int totalSize() {
        int size = this.size();
        for (StructureParentCollection list : this.structures.values()) {
            size += list.totalSize();
        }
        return size;
    }

    public int totalBoxesCount() {
        int size = this.boxesCount();
        for (StructureParentCollection list : this.structures.values()) {
            size += list.boxesCount();
        }
        return size;
    }

    private void reloadAttributes() {
        this.attributes = 0;
        for (StructureParentCollection structure : this.structures.values()) {
            this.attributes |= structure.getAttribute();
        }
    }

    @Override
    public BETiles getBE() {
        return this.be;
    }

    @Override
    public boolean isStructure() {
        return false;
    }

    @Override
    public boolean isMain() {
        return false;
    }

    @Override
    public boolean isStructureChild(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        return false;
    }

    @Override
    public LittleStructure getStructure() throws CorruptedLinkException {
        throw new CorruptedLinkException();
    }

    public StructureParentCollection getStructure(int index) {
        return this.structures.get(index);
    }

    @Override
    public int getAttribute() {
        return 0;
    }

    @Override
    public void setAttribute(int attribute) {
    }

    @Override
    public boolean isClient() {
        return this.client;
    }

    public void add(BlockParentCollection tiles) {
        this.addAll(tiles);
        tiles.structures.putAll(this.structures);
        for (StructureParentCollection list : this.structures.values()) {
            list.setParent(this);
        }
    }

    public void fillUsedIds(BitSet usedIds) {
        for (Integer id : this.structures.keySet()) {
            if (id < 0) continue;
            usedIds.set(id);
        }
    }

    public void removeEmptyLists() {
        Iterator<StructureParentCollection> iterator = this.structures.values().iterator();
        while (iterator.hasNext()) {
            StructureParentCollection child = iterator.next();
            if (!child.isEmpty()) continue;
            child.removed();
            iterator.remove();
        }
    }

    public boolean isCompletelyEmpty() {
        return super.isEmpty() && this.structures.isEmpty();
    }

    public boolean combineAllTiles(boolean optimized) {
        LittleGrid grid = this.getGrid();
        boolean result = super.combine(grid, optimized);
        for (StructureParentCollection list : this.structures.values()) {
            result |= list.combine(grid, optimized);
        }
        return result;
    }

    public boolean optimizeTiles() {
        LittleGrid grid = this.getGrid();
        boolean result = super.optimize(grid);
        for (StructureParentCollection list : this.structures.values()) {
            result |= list.optimize(grid);
        }
        return result;
    }

    public boolean combineNoneTiles(boolean optimized) {
        return super.combine(this.getGrid(), optimized);
    }

    @Override
    public void unload() {
        super.unload();
        for (StructureParentCollection child : this.structures.values()) {
            child.unload();
        }
    }
}

