/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.math.box.LittleBox;

public class LittleTileContext {
    public static final LittleTileContext FAILED = new LittleTileContext(null, null, null){

        @Override
        public boolean isComplete() {
            return false;
        }
    };
    public final IParentCollection parent;
    public final LittleTile tile;
    public final LittleBox box;

    public LittleTileContext(IParentCollection parent, LittleTile tile, LittleBox box) {
        this.parent = parent;
        this.tile = tile;
        this.box = box;
    }

    public boolean isComplete() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LittleTileContext selectFocused(BlockGetter level, BlockPos pos, Player player) {
        return LittleTileContext.selectFocused(level, pos, player, TickUtils.getFrameTime((LevelAccessor)player.m_9236_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LittleTileContext selectFocused(BlockGetter level, BlockPos pos, Player player, float partialTickTime) {
        LittleTileContext context;
        BETiles te = BlockTile.loadBE(level, pos);
        if (te != null && (context = te.getFocusedTile(player, partialTickTime)) != null) {
            return context;
        }
        return FAILED;
    }
}

