/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.registry;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.filter.premade.BlockFilters;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;
import team.creative.littletiles.common.block.little.registry.LittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.entity.PrimedSizedTnt;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleBlocks {
    public static void init() {
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.block((Block)Blocks.f_50375_), x -> new LittleMCBlock((Block)x){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void randomDisplayTick(IParentCollection parent, LittleTile tile, RandomSource rand) {
                Minecraft mc = Minecraft.m_91087_();
                ItemStack itemstack = mc.f_91074_.m_21205_();
                if (mc.f_91074_.m_7500_() && itemstack.m_150930_(Blocks.f_50375_.m_5456_())) {
                    mc.f_91073_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, tile.getState()), (double)parent.getPos().m_123341_() + 0.5, (double)parent.getPos().m_123342_() + 0.5, (double)parent.getPos().m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.instance(TntBlock.class), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean canInteract() {
                return true;
            }

            @Override
            public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result, InteractionHand hand) {
                ItemStack heldItem = player.m_21205_();
                if (heldItem.m_150930_(Items.f_42409_) || heldItem.m_150930_(Items.f_42613_)) {
                    if (!parent.isClient()) {
                        this.explodeBox(parent, box, (Entity)player, false);
                    }
                    parent.getBE().updateTiles(x -> tile.remove((LittleCollection)x.get(parent), box));
                    if (heldItem.m_41720_() == Items.f_42409_) {
                        heldItem.m_41622_(1, (LivingEntity)player, x -> x.m_21190_(InteractionHand.MAIN_HAND));
                    } else if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }

            @Override
            public void exploded(IParentCollection parent, LittleTile tile, Explosion explosion) {
                for (LittleBox box : tile) {
                    this.explodeBox(parent, box, explosion.getExploder(), true);
                }
            }

            public void explodeBox(IParentCollection parent, LittleBox box, Entity entity, boolean randomFuse) {
                BlockPos pos = parent.getPos();
                LittleVec size = box.getSize();
                LittleVec min = box.getMinVec();
                LittleGrid grid = parent.getGrid();
                PrimedSizedTnt entitytntprimed = new PrimedSizedTnt(parent.getLevel(), (double)pos.m_123341_() + min.getPosX(grid) + size.getPosX(grid) / 2.0, (double)pos.m_123342_() + min.getPosY(grid) + size.getPosY(grid) / 2.0, (double)pos.m_123343_() + min.getPosZ(grid) + size.getPosZ(grid) / 2.0, entity instanceof LivingEntity ? (LivingEntity)entity : null, grid, size);
                if (randomFuse) {
                    entitytntprimed.m_32085_((short)(parent.getLevel().f_46441_.m_188503_(entitytntprimed.m_32100_() / 4) + entitytntprimed.m_32100_() / 8));
                }
                parent.getLevel().m_7967_((Entity)entitytntprimed);
                parent.getLevel().m_6263_((Player)null, entitytntprimed.m_20185_(), entitytntprimed.m_20186_(), entitytntprimed.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                parent.getLevel().m_142346_(entity, GameEvent.f_157776_, parent.getPos());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.block((Block)Blocks.f_50091_), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean canInteract() {
                return true;
            }

            @Override
            public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result, InteractionHand hand) {
                if (parent.isClient()) {
                    return InteractionResult.SUCCESS;
                }
                player.m_5893_(Blocks.f_50091_.m_7246_(this.getState(), parent.getLevel(), parent.getPos()));
                player.m_36220_(Stats.f_12967_);
                return InteractionResult.CONSUME;
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.property((Property)BlockStateProperties.f_61365_), x -> new LittleMCBlock((Block)x){

            @Override
            public BlockState rotate(BlockState state, Rotation rotation, LittleVec doubledCenter) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)rotation.rotate(Axis.get((Direction.Axis)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)))).toVanilla());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.property((Property)BlockStateProperties.f_61372_), x -> new LittleMCBlock((Block)x){

            @Override
            public BlockState rotate(BlockState state, Rotation rotation, LittleVec doubledCenter) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.rotate(Facing.get((Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)))).toVanilla());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.instance(LeavesBlock.class), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean cullOverEdge() {
                return false;
            }
        });
    }
}

