/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.block.LittleBlock;
import team.creative.littletiles.common.block.little.registry.LittleBlockProvider;
import team.creative.littletiles.common.block.little.registry.LittleMCBlock;
import team.creative.littletiles.common.block.little.registry.LittleMissingBlock;
import team.creative.littletiles.common.convertion.OldLittleTilesDataParser;
import team.creative.littletiles.mixin.common.block.StateHolderAccessor;

public class LittleBlockRegistry {
    private static final HashMap<String, LittleBlock> NAME_MAP = new HashMap();
    private static final PairList<Filter<Block>, Function<Block, LittleBlock>> BLOCK_HANDLERS = new PairList();
    private static final Function<Block, LittleBlock> FALLBACK = x -> new LittleMCBlock((Block)x);
    private static final List<Function<String, LittleBlock>> SPECIAL_HANDLERS = new ArrayList<Function<String, LittleBlock>>();

    public static LittleBlock getMissing(String name) {
        LittleBlock little = NAME_MAP.get(name);
        if (little != null) {
            return little;
        }
        return LittleBlockRegistry.create(name, null);
    }

    public static LittleBlock get(String name) {
        LittleBlock little = NAME_MAP.get(name);
        if (little != null) {
            return little;
        }
        return LittleBlockRegistry.create(name, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name)));
    }

    public static LittleBlock get(Block block) {
        return ((LittleBlockProvider)block).getLittleBlock();
    }

    public static LittleBlock get(BlockState state) {
        return ((LittleBlockProvider)state.m_60734_()).getLittleBlock();
    }

    public static String saveState(BlockState state) {
        if (state.m_60734_() instanceof AirBlock) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        name.append(state.m_60734_().m_204297_().m_205785_().m_135782_());
        if (!state.m_61148_().isEmpty()) {
            name.append('[').append(state.m_61148_().entrySet().stream().map(StateHolderAccessor.getPROPERTY_ENTRY_TO_STRING_FUNCTION()).collect(Collectors.joining(","))).append(']');
        }
        return name.toString();
    }

    public static BlockState loadState(String name) {
        return LittleBlockRegistry.loadState(name, true);
    }

    public static BlockState loadState(String name, boolean checkOld) {
        ResourceLocation location;
        String[] parts = name.contains("[") ? name.split("\\[") : new String[]{name};
        if (parts.length == 0) {
            return ((Block)LittleTilesRegistry.MISSING.get()).m_49966_();
        }
        try {
            location = new ResourceLocation(parts[0]);
        }
        catch (ResourceLocationException e) {
            return ((Block)LittleTilesRegistry.MISSING.get()).m_49966_();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block == null || block instanceof AirBlock) {
            String converted;
            if (checkOld && (converted = OldLittleTilesDataParser.BLOCK_MAP.get(name)) != null) {
                return LittleBlockRegistry.loadState(converted, false);
            }
            return ((Block)LittleTilesRegistry.MISSING.get()).m_49966_();
        }
        if (parts.length == 1) {
            return block.m_49966_();
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException(name);
        }
        BlockState state = block.m_49966_();
        String[] properties = parts[1].substring(0, parts[1].length() - 1).split(",");
        for (int i = 0; i < properties.length; ++i) {
            String[] data = properties[i].split("=");
            if (data.length != 2) {
                throw new IllegalArgumentException(name);
            }
            Property property = block.m_49965_().m_61081_(data[0]);
            Optional value = property.m_6215_(data[1]);
            if (!value.isPresent()) {
                throw new IllegalArgumentException("Invalid property " + properties[i] + " in " + name);
            }
            state = LittleBlockRegistry.setValue(state, property, value.get());
        }
        return state;
    }

    private static <T extends Comparable<T>, V extends T> BlockState setValue(BlockState state, Property prop, Object value) {
        return (BlockState)state.m_61124_(prop, (Comparable)value);
    }

    public static boolean isSpecialBlock(Block block) {
        return ((LittleBlockProvider)block).isSpecialBlock();
    }

    private static LittleBlock create(String name, Block block) {
        if (block instanceof LittleBlock) {
            LittleBlock b = (LittleBlock)block;
            NAME_MAP.put(name, b);
            return b;
        }
        if (block == null) {
            for (Function<String, LittleBlock> special : SPECIAL_HANDLERS) {
                LittleBlock little = special.apply(name);
                if (little == null) continue;
                NAME_MAP.put(name, little);
                return little;
            }
            LittleMissingBlock little = new LittleMissingBlock(name);
            NAME_MAP.put(name, little);
            return little;
        }
        if (name == null) {
            name = block.m_204297_().m_205785_().m_135782_().toString();
        }
        LittleBlock little = ((LittleBlockProvider)block).getLittleBlock();
        NAME_MAP.put(name, little);
        return little;
    }

    @Deprecated
    public static void calculateCache(Block block) {
        if (block instanceof LittleBlock) {
            LittleBlock b = (LittleBlock)block;
            ((LittleBlockProvider)block).setCache(b, true);
            return;
        }
        for (Pair pair : BLOCK_HANDLERS) {
            if (!((Filter)pair.key).is((Object)block)) continue;
            ((LittleBlockProvider)block).setCache((LittleBlock)((Function)pair.value).apply(block), true);
            return;
        }
        ((LittleBlockProvider)block).setCache(FALLBACK.apply(block), false);
    }

    public static void register(Filter<Block> filter, Function<Block, LittleBlock> function) {
        BLOCK_HANDLERS.add(filter, function);
    }
}

