/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadePreview;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;

public class LittleActionPlace
extends LittleAction<Boolean> {
    public PlacementPreview preview;
    public PlaceAction action;
    public transient PlacementResult result;
    @OnlyIn(value=Dist.CLIENT)
    public transient LittleGroupAbsolute destroyed;
    public transient boolean toVanilla = true;

    public LittleActionPlace() {
    }

    public LittleActionPlace(PlaceAction action, PlacementPreview preview) {
        this.action = action;
        this.preview = preview;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(Player player) throws LittleActionException {
        if (this.result == null) {
            return null;
        }
        this.result.placedBoxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActions(new LittleActionDestroyBoxes(this.preview.levelUUID, this.result.placedBoxes.copy()), new LittleActionPlace(PlaceAction.ABSOLUTE, PlacementPreview.load(this.preview.levelUUID, PlacementMode.NORMAL, this.destroyed, this.preview.position.facing)));
        }
        return new LittleActionDestroyBoxes(this.preview.levelUUID, this.result.placedBoxes.copy());
    }

    @Override
    public boolean wasSuccessful(Boolean result) {
        return result;
    }

    @Override
    public Boolean failed() {
        return false;
    }

    @Override
    public Boolean action(Player player) throws LittleActionException {
        Level level = player.m_9236_();
        if (!LittleActionPlace.isAllowedToInteract((LevelAccessor)level, player, this.preview.position.getPos(), true, this.preview.position.facing)) {
            LittleActionPlace.sendBlockResetToClient((LevelAccessor)level, player, this.preview);
            return false;
        }
        if (this.action == PlaceAction.CURRENT_ITEM) {
            ItemStack stack = player.m_21205_();
            if (PlacementHelper.getLittleInterface(stack) != null) {
                PlacementResult tiles = this.placeTile(player, stack, this.preview);
                if (!level.f_46443_) {
                    player.f_36095_.m_38946_();
                }
                return tiles != null;
            }
            return false;
        }
        LittleInventory inventory = new LittleInventory(player);
        if (this.canDrainIngredientsBeforePlacing(player, inventory)) {
            Placement placement = new Placement(player, this.preview);
            this.result = placement.place();
            if (this.result != null) {
                this.drainIngredientsAfterPlacing(player, inventory, this.result, this.preview.previews);
                if (!level.f_46443_) {
                    LittleActionPlace.checkAndGive(player, inventory, LittleActionPlace.getIngredients(placement.unplaceableTiles));
                    LittleActionPlace.checkAndGive(player, inventory, placement.overflow());
                }
                if (!placement.removedTiles.isEmpty()) {
                    this.destroyed = placement.removedTiles.copy();
                }
                if (this.toVanilla) {
                    for (BETiles be : this.result.blocks) {
                        be.convertBlockToVanilla();
                    }
                }
            }
            return this.result != null;
        }
        return false;
    }

    public PlacementResult placeTile(Player player, ItemStack stack, PlacementPreview preview) throws LittleActionException {
        ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
        ItemStack toPlace = stack.m_41777_();
        LittleInventory inventory = new LittleInventory(player);
        if (LittleActionPlace.needIngredients(player) && !iTile.containsIngredients(stack)) {
            LittleActionPlace.canTake(player, inventory, preview.getBeforePlaceIngredients());
        }
        LittleActionPlace.isAllowedToUse(player, preview.previews);
        LittleActionPlace.isAllowedToUse(player, preview.position);
        Placement placement = new Placement(player, preview).setStack(toPlace);
        this.result = placement.place();
        if (this.result != null) {
            if (LittleActionPlace.needIngredients(player)) {
                LittleActionPlace.checkAndGive(player, inventory, placement.overflow());
                if (iTile.containsIngredients(stack)) {
                    stack.m_41774_(1);
                    LittleActionPlace.checkAndGive(player, inventory, LittleActionPlace.getIngredients(placement.unplaceableTiles));
                } else {
                    LittleIngredients ingredients = LittleIngredient.extractStructureOnly(preview.previews);
                    ingredients.add(LittleActionPlace.getIngredients(this.result.placedPreviews));
                    LittleActionPlace.take(player, inventory, ingredients);
                }
            }
            if (!placement.removedTiles.isEmpty() && player.m_9236_().f_46443_) {
                this.destroyed = placement.removedTiles.copy();
            }
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canDrainIngredientsBeforePlacing(Player player, LittleInventory inventory) throws LittleActionException {
        if (this.action != PlaceAction.PREMADE) {
            return LittleActionPlace.canTake(player, inventory, this.preview.getBeforePlaceIngredients());
        }
        LittlePremadePreview entry = LittlePremadeRegistry.getPreview(this.preview.previews.getStructureId());
        try {
            inventory.startSimulation();
            boolean bl = LittleActionPlace.take(player, inventory, entry.stack) && entry.arePreviewsEqual(this.preview.previews);
            return bl;
        }
        finally {
            inventory.stopSimulation();
        }
    }

    protected void drainIngredientsAfterPlacing(Player player, LittleInventory inventory, PlacementResult placedTiles, LittleGroup previews) throws LittleActionException {
        if (this.action == PlaceAction.PREMADE) {
            LittleActionPlace.take(player, inventory, LittlePremadeRegistry.getPreview((String)previews.getStructureId()).stack);
            return;
        }
        LittleIngredients ingredients = LittleIngredient.extractStructureOnly(previews);
        ingredients.add(LittleActionPlace.getIngredients(placedTiles.placedPreviews));
        LittleActionPlace.take(player, inventory, ingredients);
    }

    @Override
    public LittleActionPlace mirror(Axis axis, LittleBoxAbsolute box) {
        PlacementPreview preview = this.preview.copy();
        preview.mirror(axis, box);
        return new LittleActionPlace(this.action, preview);
    }

    public static enum PlaceAction {
        CURRENT_ITEM,
        ABSOLUTE,
        PREMADE;

    }
}

