/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionBoxes;
import team.creative.littletiles.common.action.LittleActionDestroy;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class LittleActionDestroyBoxes
extends LittleActionBoxes {
    public transient boolean doneSomething;
    public transient List<LittleActionDestroy.StructurePreview> destroyedStructures;
    public transient LittleGroupAbsolute destroyed;

    public LittleActionDestroyBoxes(Level level, LittleBoxes boxes) {
        super(level, boxes);
    }

    public LittleActionDestroyBoxes(UUID levelUUID, LittleBoxes boxes) {
        super(levelUUID, boxes);
    }

    public LittleActionDestroyBoxes() {
    }

    private boolean containsStructure(LittleStructure structure) {
        for (LittleActionDestroy.StructurePreview structurePreview : this.destroyedStructures) {
            if (structurePreview.structure != structure) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTile(IParentCollection parent, LittleTile tile) {
        return false;
    }

    public LittleIngredients action(Player player, BETiles be, List<LittleBox> boxes, boolean simulate, LittleGrid grid) {
        this.doneSomething = false;
        if (this.destroyed == null) {
            this.destroyed = new LittleGroupAbsolute(be.m_58899_());
        }
        LittleIngredients ingredients = new LittleIngredients();
        LittleCollection toPlace = new LittleCollection();
        LittleCollection toRemove = new LittleCollection();
        for (IParentCollection parent : be.groups()) {
            if (parent.isStructure()) {
                if (simulate) continue;
                boolean intersects = false;
                block3: for (LittleTile tile : parent) {
                    for (int j = 0; j < boxes.size(); ++j) {
                        if (!tile.intersectsWith(boxes.get(j))) continue;
                        intersects = true;
                        break block3;
                    }
                }
                if (!intersects) continue;
                try {
                    LittleStructure structure = parent.getStructure();
                    if (this.containsStructure(structure)) continue;
                    this.destroyedStructures.add(new LittleActionDestroy.StructurePreview(structure));
                }
                catch (CorruptedConnectionException | NotYetConnectedException structure) {}
                continue;
            }
            for (LittleTile element : parent) {
                if (this.shouldSkipTile(parent, element)) continue;
                for (LittleBox box : element) {
                    LittleBox intersecting = null;
                    boolean intersects = false;
                    for (int j = 0; j < boxes.size(); ++j) {
                        if (!LittleBox.intersectsWith(box, boxes.get(j))) continue;
                        intersects = true;
                        intersecting = boxes.get(j);
                        break;
                    }
                    if (!intersects) continue;
                    this.doneSomething = true;
                    if (!box.equals(intersecting)) {
                        double volume = 0.0;
                        ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                        LittleBoxReturnedVolume returnedVolume = new LittleBoxReturnedVolume();
                        List<LittleBox> newBoxes = box.cutOut(grid, boxes, cutout, returnedVolume);
                        if (newBoxes != null) {
                            if (!simulate) {
                                toPlace.add((LittleElement)element, newBoxes);
                                toRemove.add((LittleElement)element, box);
                            }
                            for (int l = 0; l < cutout.size(); ++l) {
                                volume += ((LittleBox)cutout.get(l)).getPercentVolume(grid);
                                if (simulate) continue;
                                this.destroyed.add(parent, (LittleElement)element, (LittleBox)cutout.get(l));
                            }
                        }
                        if (volume > 0.0) {
                            ingredients.add(LittleActionDestroyBoxes.getIngredients(element, volume));
                        }
                        if (!returnedVolume.has()) continue;
                        ingredients.add(LittleActionDestroyBoxes.getIngredients(element, returnedVolume.getPercentVolume(grid)));
                        continue;
                    }
                    ingredients.add(LittleActionDestroyBoxes.getIngredients(parent, element, box));
                    if (simulate) continue;
                    toRemove.add((LittleElement)element, intersecting);
                    this.destroyed.add(parent, (LittleElement)element, intersecting);
                }
            }
        }
        if (!simulate) {
            be.updateTiles(x -> {
                ParentCollection parent = x.noneStructureTiles();
                parent.removeAll(toRemove);
                parent.addAll(toPlace);
            });
        }
        return ingredients;
    }

    @Override
    public void action(Level world, Player player, BlockPos pos, BlockState state, List<LittleBox> boxes, LittleGrid grid) throws LittleActionException {
        LittleActionDestroyBoxes.fireBlockBreakEvent(world, pos, player);
        BETiles blockEntity = LittleActionDestroyBoxes.loadBE(player, world, pos, null, true, 0);
        if (blockEntity instanceof BETiles) {
            BETiles be = blockEntity;
            if (grid != be.getGrid()) {
                if (grid.count < be.getGrid().count) {
                    for (LittleBox box : boxes) {
                        box.convertTo(grid, be.getGrid());
                    }
                    grid = be.getGrid();
                } else {
                    be.convertTo(grid);
                }
            }
            if (LittleActionDestroyBoxes.checkAndGive(player, new LittleInventory(player), this.action(player, be, boxes, true, grid))) {
                this.action(player, be, boxes, false, grid);
            }
            be.combineAllTiles(false);
            if (!this.doneSomething) {
                be.convertBlockToVanilla();
            }
        }
    }

    @Override
    public Boolean action(Player player) throws LittleActionException {
        this.destroyedStructures = new ArrayList<LittleActionDestroy.StructurePreview>();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(Player player) {
        boolean additionalPreviews = this.destroyed != null && !this.destroyed.isEmpty();
        LittleAction[] actions = new LittleAction[(additionalPreviews ? 1 : 0) + this.destroyedStructures.size()];
        if (additionalPreviews) {
            this.destroyed.convertToSmallest();
            actions[0] = new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.load(this.levelUUID, PlacementMode.FILL, this.destroyed, Facing.EAST));
        }
        for (int i = 0; i < this.destroyedStructures.size(); ++i) {
            actions[(additionalPreviews ? 1 : 0) + i] = this.destroyedStructures.get(i).getPlaceAction();
        }
        return new LittleActions(actions);
    }

    public static LittleCollection removeBox(BETiles be, LittleGrid grid, LittleBox toCut, boolean update, LittleBoxReturnedVolume returnedVolume) {
        if (grid != be.getGrid()) {
            if (grid.count > be.getGrid().count) {
                be.convertTo(grid);
            } else {
                toCut.convertTo(grid, be.getGrid());
                grid = be.getGrid();
            }
        }
        LittleGrid usedGrid = grid;
        LittleCollection removed = new LittleCollection();
        Consumer<BETiles.BlockEntityInteractor> consumer = x -> {
            LittleCollection toAdd = new LittleCollection();
            for (LittleTile element : x.noneStructureTiles()) {
                for (LittleBox box : element) {
                    if (!LittleBox.intersectsWith(box, toCut)) continue;
                    x.noneStructureTiles().remove(element, box);
                    if (!box.equals(toCut)) {
                        ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
                        boxes.add(toCut);
                        List<LittleBox> newBoxes = box.cutOut(usedGrid, boxes, cutout, null);
                        if (newBoxes == null) continue;
                        toAdd.add((LittleElement)element, newBoxes);
                        removed.add((LittleElement)element, cutout);
                        continue;
                    }
                    removed.add((LittleElement)element, box);
                }
            }
            x.noneStructureTiles().removeAll(removed);
            x.noneStructureTiles().addAll(toAdd);
        };
        if (update) {
            be.updateTiles(consumer);
        } else {
            be.updateTilesSecretly(consumer);
        }
        return removed;
    }

    public static LittleCollection removeBoxes(BETiles be, LittleGrid grid, List<LittleBox> boxes) {
        if (grid != be.getGrid()) {
            if (grid.count > be.getGrid().count) {
                be.convertTo(grid);
            } else {
                for (LittleBox box : boxes) {
                    box.convertTo(grid, be.getGrid());
                }
                grid = be.getGrid();
            }
        }
        LittleGrid usedGrid = grid;
        LittleCollection removed = new LittleCollection();
        be.updateTiles(x -> {
            LittleCollection toAdd = new LittleCollection();
            for (LittleTile element : x.noneStructureTiles()) {
                for (LittleBox box : element) {
                    LittleBox intersecting = null;
                    boolean intersects = false;
                    for (int j = 0; j < boxes.size(); ++j) {
                        if (!LittleBox.intersectsWith(box, (LittleBox)boxes.get(j))) continue;
                        intersects = true;
                        intersecting = (LittleBox)boxes.get(j);
                        break;
                    }
                    if (!intersects) continue;
                    x.noneStructureTiles().remove(element, box);
                    if (!box.equals(intersecting)) {
                        ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                        List<LittleBox> newBoxes = box.cutOut(usedGrid, boxes, cutout, null);
                        if (newBoxes == null) continue;
                        toAdd.add((LittleElement)element, newBoxes);
                        removed.add((LittleElement)element, cutout);
                        continue;
                    }
                    removed.add((LittleElement)element, box);
                }
            }
            x.noneStructureTiles().removeAll(removed);
            x.noneStructureTiles().addAll(toAdd);
        });
        return removed;
    }

    @Override
    public void actionDone(Level level, Player player) {
        for (LittleActionDestroy.StructurePreview structure : this.destroyedStructures) {
            try {
                ItemStack stack;
                if (structure.structure.mainBlock.isRemoved()) continue;
                if (LittleActionDestroyBoxes.needIngredients(player) && !level.f_46443_ && !(stack = structure.structure.getStructureDrop()).m_41619_() && !player.m_36356_(stack)) {
                    LevelUtils.dropItem((Player)player, (ItemStack)stack);
                }
                structure.structure.tileDestroyed();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    @Override
    public LittleAction mirror(Axis axis, LittleBoxAbsolute box) {
        return this.assignMirror(new LittleActionDestroyBoxes(), axis, box);
    }

    public static class LittleActionDestroyBoxesFiltered
    extends LittleActionDestroyBoxes {
        public BiFilter<IParentCollection, LittleTile> filter;

        public LittleActionDestroyBoxesFiltered(Level level, LittleBoxes boxes, BiFilter<IParentCollection, LittleTile> filter) {
            super(level, boxes);
            this.filter = filter;
        }

        public LittleActionDestroyBoxesFiltered() {
        }

        @Override
        public boolean shouldSkipTile(IParentCollection parent, LittleTile tile) {
            return !this.filter.is((Object)parent, (Object)tile);
        }
    }
}

