/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL14;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittleEditor;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.packet.item.MirrorPacket;
import team.creative.littletiles.common.packet.item.RotatePacket;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mark.IMarkMode;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.exception.MissingAnimationException;

public class PreviewRenderer
implements LevelAwareHandler {
    public static final ResourceLocation WHITE_TEXTURE = new ResourceLocation("littletiles", "textures/preview.png");
    public static Minecraft mc = Minecraft.m_91087_();
    private boolean lastLowResolution;
    private CompoundTag lastCached;
    private PlacementPreview lastPreviews;
    private PlacementMode lastMode;
    private IMarkMode marked;

    public PreviewRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public PlacementPosition getPosition(Player player, Level level, ItemStack stack, BlockHitResult result) {
        ILittleTool iTile = (ILittleTool)stack.m_41720_();
        return this.marked != null ? this.marked.getPosition() : PlacementHelper.getPosition(level, result, iTile.getPositionGrid(player, stack), iTile, stack);
    }

    public PlacementPreview getPreviews(Entity entity, Level level, ItemStack stack, PlacementPosition position, boolean centered, boolean fixed, boolean allowLowResolution) {
        PlacementPreview preview;
        ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
        PlacementMode mode = iTile.getPlacementMode(stack);
        PlacementPreview placementPreview = preview = allowLowResolution == this.lastLowResolution && iTile.shouldCache() && this.lastCached != null && this.lastCached.equals((Object)stack.m_41783_()) && this.lastMode == mode ? this.lastPreviews.copy() : null;
        if (preview != null) {
            try {
                preview.moveRelative(entity, stack, position, centered, fixed);
            }
            catch (MissingAnimationException e) {
                preview = null;
            }
        }
        if (preview == null && iTile != null) {
            preview = iTile.getPlacement((Player)entity, level, stack, position, allowLowResolution);
        }
        if (preview != null) {
            if (stack.m_41783_() == null) {
                this.lastCached = null;
                this.lastPreviews = null;
                this.lastMode = null;
            } else {
                this.lastLowResolution = allowLowResolution;
                this.lastCached = stack.m_41783_().m_6426_();
                this.lastPreviews = preview.copy();
                this.lastMode = mode;
            }
        }
        return preview;
    }

    public void removeMarked() {
        this.marked = null;
    }

    public void removeCache() {
        this.lastCached = null;
        this.lastPreviews = null;
        this.lastLowResolution = false;
        this.lastMode = null;
    }

    public boolean isCentered(ItemStack stack, ILittlePlacer iTile) {
        if (!iTile.canSnapToGrid(stack)) {
            return this.marked == null;
        }
        if (iTile.snapToGridByDefault(stack)) {
            return LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid == LittleActionHandlerClient.isUsingSecondMode() || this.marked != null;
    }

    public boolean isFixed(ItemStack stack, ILittlePlacer iTile) {
        if (!iTile.canSnapToGrid(stack)) {
            return this.marked != null;
        }
        if (iTile.snapToGridByDefault(stack)) {
            return !LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid != LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
    }

    @Override
    public void unload() {
        this.removeMarked();
        this.removeCache();
    }

    private void handleUndoAndRedo(boolean execute) {
        while (LittleTilesClient.undo.m_90859_()) {
            try {
                if (!execute || !LittleActionHandlerClient.canUseUndoOrRedo()) continue;
                LittleTilesClient.ACTION_HANDLER.undo();
            }
            catch (LittleActionException e) {
                LittleActionHandlerClient.handleException(e);
            }
        }
        while (LittleTilesClient.redo.m_90859_()) {
            try {
                if (!execute || !LittleActionHandlerClient.canUseUndoOrRedo()) continue;
                LittleTilesClient.ACTION_HANDLER.redo();
            }
            catch (LittleActionException e) {
                LittleActionHandlerClient.handleException(e);
            }
        }
    }

    @SubscribeEvent
    public void tick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        if (PreviewRenderer.mc.f_91074_ != null) {
            ClientLevel level = PreviewRenderer.mc.f_91073_;
            LocalPlayer player = PreviewRenderer.mc.f_91074_;
            ItemStack stack = PreviewRenderer.mc.f_91074_.m_21205_();
            PoseStack pose = new PoseStack();
            if (!LittleAction.canPlace((Player)player)) {
                this.handleUndoAndRedo(false);
                return;
            }
            this.handleUndoAndRedo(true);
            if (PreviewRenderer.mc.f_91066_.f_92062_) {
                return;
            }
            Vec3 cam = PreviewRenderer.mc.f_91063_.m_109153_().m_90583_();
            Item item = stack.m_41720_();
            if (item instanceof ILittleTool) {
                ILittleTool tool = (ILittleTool)item;
                if (this.marked != null || PreviewRenderer.mc.f_91077_ != null && PreviewRenderer.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult b;
                    HitResult hitResult = PreviewRenderer.mc.f_91077_;
                    BlockHitResult blockHit = hitResult instanceof BlockHitResult ? (b = (BlockHitResult)hitResult) : null;
                    PlacementPosition position = this.marked != null ? this.marked.getPosition() : PlacementHelper.getPosition((Level)level, blockHit, tool.getPositionGrid((Player)player, stack), tool, stack);
                    this.processKeys(stack, tool.getPositionGrid((Player)player, stack));
                    tool.tick((Player)player, stack, position, blockHit);
                    if (PlacementHelper.isLittleBlock(stack)) {
                        ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
                        PlacementMode mode = iTile.getPlacementMode(stack);
                        if (mode.getPreviewMode() == PlacementMode.PreviewMode.PREVIEWS) {
                            RenderSystem.enableBlend();
                            if (LittleTiles.CONFIG.rendering.darkerPreviewBoxShading) {
                                GL14.glBlendColor((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
                                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                            } else {
                                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                            }
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WHITE_TEXTURE);
                            PreviewRenderer.mc.f_90987_.m_174784_(WHITE_TEXTURE);
                            RenderSystem.setShader(GameRenderer::m_172811_);
                            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
                            boolean allowLowResolution = this.marked != null ? this.marked.allowLowResolution() : true;
                            PlacementPreview result = this.getPreviews((Entity)player, (Level)level, stack, position, this.isCentered(stack, iTile), this.isFixed(stack, iTile), allowLowResolution);
                            if (result != null) {
                                List<RenderBox> cubes;
                                BlockPos pos = result.position.getPos();
                                pose.m_85836_();
                                pose.m_85837_((double)pos.m_123341_() - cam.f_82479_, (double)pos.m_123342_() - cam.f_82480_, (double)pos.m_123343_() - cam.f_82481_);
                                this.processMarkKey((Player)player, iTile, stack, result);
                                BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                                double alpha = (float)(Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5);
                                int colorAlpha = (int)(alpha * (double)iTile.getPreviewAlphaFactor() * 255.0);
                                for (RenderBox box : result.previews.getPlaceBoxes(result.position.getVec())) {
                                    box.renderPreview(pose, builder, colorAlpha);
                                }
                                if (LittleActionHandlerClient.isUsingSecondMode() != iTile.snapToGridByDefault(stack) && (cubes = iTile.getPositingCubes((Level)level, pos, stack)) != null) {
                                    for (RenderBox cube : cubes) {
                                        cube.renderPreview(pose, builder, colorAlpha);
                                    }
                                }
                                pose.m_85849_();
                            }
                            RenderSystem.depthMask((boolean)true);
                            RenderSystem.disableBlend();
                            RenderSystem.defaultBlendFunc();
                        }
                    } else {
                        this.processMarkKey((Player)player, (ILittleTool)stack.m_41720_(), stack, null);
                    }
                    pose.m_85836_();
                    pose.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
                    tool.render((Player)player, stack, pose);
                    if (this.marked != null) {
                        this.marked.render(tool.getPositionGrid((Player)player, stack), pose);
                    }
                    pose.m_85849_();
                }
            }
        } else {
            this.marked = null;
        }
    }

    public void processMarkKey(Player player, ILittleTool iTile, ItemStack stack, PlacementPreview preview) {
        while (LittleTilesClient.mark.m_90859_()) {
            if (this.marked == null) {
                this.marked = iTile.onMark(player, stack, this.getPosition(player, player.m_9236_(), stack, (BlockHitResult)PreviewRenderer.mc.f_91077_), (BlockHitResult)PreviewRenderer.mc.f_91077_, preview);
                if (!Screen.m_96637_()) continue;
                GuiCreator.openClientSide((GuiLayer)this.marked.getConfigurationGui());
                continue;
            }
            if (Screen.m_96637_()) {
                GuiCreator.openClientSide((GuiLayer)this.marked.getConfigurationGui());
                continue;
            }
            this.marked.done();
            this.marked = null;
        }
    }

    public void processRotateKey(Player player, Rotation rotation, ItemStack stack) {
        RotatePacket packet = new RotatePacket(rotation);
        packet.executeClient(player);
        if (stack.m_41720_() instanceof ILittleTool && !((ILittleTool)stack.m_41720_()).sendTransformationUpdate()) {
            return;
        }
        LittleTiles.NETWORK.sendToServer((CreativePacket)packet);
    }

    public void processKeys(ItemStack stack, LittleGrid grid) {
        while (LittleTilesClient.mirror.m_90859_()) {
            this.processMirrorKey((Player)PreviewRenderer.mc.f_91074_, stack);
        }
        while (LittleTilesClient.up.m_90859_()) {
            if (this.marked != null) {
                this.marked.move(grid, LittleActionHandlerClient.isUsingSecondMode() ? Facing.UP : Facing.EAST);
                continue;
            }
            this.processRotateKey((Player)PreviewRenderer.mc.f_91074_, Rotation.Z_CLOCKWISE, stack);
        }
        while (LittleTilesClient.down.m_90859_()) {
            if (this.marked != null) {
                this.marked.move(grid, LittleActionHandlerClient.isUsingSecondMode() ? Facing.DOWN : Facing.WEST);
                continue;
            }
            this.processRotateKey((Player)PreviewRenderer.mc.f_91074_, Rotation.Z_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.right.m_90859_()) {
            if (this.marked != null) {
                this.marked.move(grid, Facing.SOUTH);
                continue;
            }
            this.processRotateKey((Player)PreviewRenderer.mc.f_91074_, Rotation.Y_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.left.m_90859_()) {
            if (this.marked != null) {
                this.marked.move(grid, Facing.NORTH);
                continue;
            }
            this.processRotateKey((Player)PreviewRenderer.mc.f_91074_, Rotation.Y_CLOCKWISE, stack);
        }
    }

    public void processMirrorKey(Player player, ItemStack stack) {
        Facing direction = Facing.get((Direction)player.m_6350_());
        if (player.m_146909_() > 45.0f) {
            direction = Facing.DOWN;
        }
        if (player.m_146909_() < -45.0f) {
            direction = Facing.UP;
        }
        MirrorPacket packet = new MirrorPacket(direction.axis);
        packet.executeClient(player);
        if (stack.m_41720_() instanceof ILittleTool && !((ILittleTool)stack.m_41720_()).sendTransformationUpdate()) {
            return;
        }
        LittleTiles.NETWORK.sendToServer((CreativePacket)packet);
    }

    @SubscribeEvent
    public void drawHighlight(RenderHighlightEvent.Block event) {
        LocalPlayer player = PreviewRenderer.mc.f_91074_;
        Level level = player.m_9236_();
        ItemStack stack = player.m_21205_();
        if (!LittleAction.canPlace((Player)player)) {
            return;
        }
        Vec3 vec = PreviewRenderer.mc.f_91063_.m_109153_().m_90583_();
        PoseStack pose = event.getPoseStack();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if ((event.getTarget().m_6662_() == HitResult.Type.BLOCK || this.marked != null) && stack.m_41720_() instanceof ILittleTool) {
            BlockHitResult blockHit = event.getTarget().m_6662_() == HitResult.Type.BLOCK ? event.getTarget() : null;
            BlockPos pos = this.marked != null ? this.marked.getPosition().getPos() : blockHit.m_82425_();
            BlockState state = level.m_8055_(pos);
            Vec3 cam = PreviewRenderer.mc.f_91063_.m_109153_().m_90583_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            Item item = stack.m_41720_();
            if (item instanceof ILittleEditor) {
                ILittleEditor selector = (ILittleEditor)item;
                this.processMarkKey((Player)player, selector, stack, null);
                result = this.getPosition((Player)player, level, stack, blockHit);
                if (selector.hasCustomBoxes(level, stack, (Player)player, state, (PlacementPosition)result, blockHit) || this.marked != null) {
                    LittleBoxes boxes = selector.getBoxes(level, stack, (Player)player, (PlacementPosition)result, blockHit);
                    RenderSystem.setShader(GameRenderer::m_172757_);
                    bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                    pose.m_85836_();
                    pose.m_85837_((double)boxes.pos.m_123341_() - cam.f_82479_, (double)boxes.pos.m_123342_() - cam.f_82480_, (double)boxes.pos.m_123343_() - cam.f_82481_);
                    RenderSystem.lineWidth((float)2.0f);
                    for (LittleBox box : boxes.all()) {
                        LittleRenderBox cube = box.getRenderingBox(boxes.getGrid());
                        if (cube == null) continue;
                        cube.color = 0;
                        cube.renderLines(pose, (VertexConsumer)bufferbuilder, 255, cube.getCenter(), 0.002);
                    }
                    tesselator.m_85914_();
                    pose.m_85849_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                    RenderSystem.lineWidth((float)1.0f);
                    this.renderHitOutline(pose, level, (VertexConsumer)bufferbuilder, (Entity)player, vec.f_82479_, vec.f_82480_, vec.f_82481_, pos);
                    tesselator.m_85914_();
                    RenderSystem.lineWidth((float)2.0f);
                    event.setCanceled(true);
                }
            } else {
                ILittlePlacer iTile;
                PlacementMode mode;
                result = stack.m_41720_();
                if (result instanceof ILittlePlacer && (mode = (iTile = (ILittlePlacer)result).getPlacementMode(stack)).getPreviewMode() == PlacementMode.PreviewMode.LINES) {
                    PlacementPosition position = this.getPosition((Player)player, level, stack, blockHit);
                    boolean allowLowResolution = this.marked != null ? this.marked.allowLowResolution() : true;
                    PlacementPreview result = this.getPreviews((Entity)player, level, stack, position, this.isCentered(stack, iTile), this.isFixed(stack, iTile), allowLowResolution);
                    if (result != null) {
                        List<RenderBox> cubes;
                        this.processMarkKey((Player)player, iTile, stack, result);
                        pose.m_85836_();
                        BlockPos renderCenter = result.position.getPos();
                        pose.m_85837_((double)renderCenter.m_123341_() - cam.f_82479_, (double)renderCenter.m_123342_() - cam.f_82480_, (double)renderCenter.m_123343_() - cam.f_82481_);
                        RenderSystem.setShader(GameRenderer::m_172757_);
                        RenderSystem.lineWidth((float)((float)LittleTiles.CONFIG.rendering.previewLineThickness));
                        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                        int colorAlpha = 255;
                        for (RenderBox box : result.previews.getPlaceBoxes(result.position.getVec())) {
                            box.renderLines(pose, (VertexConsumer)bufferbuilder, colorAlpha, box.getCenter(), 0.002);
                        }
                        if (LittleActionHandlerClient.isUsingSecondMode() != iTile.snapToGridByDefault(stack) && (cubes = iTile.getPositingCubes(level, pos, stack)) != null) {
                            for (RenderBox cube : cubes) {
                                cube.renderLines(pose, (VertexConsumer)bufferbuilder, colorAlpha, cube.getCenter(), 0.002);
                            }
                        }
                        tesselator.m_85914_();
                        pose.m_85849_();
                    }
                }
            }
        }
        if (!event.isCanceled() && level.m_8055_(event.getTarget().m_82425_()).m_60734_() instanceof BlockTile && level.m_6857_().m_61937_(event.getTarget().m_82425_())) {
            this.renderHitOutline(pose, level, event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (Entity)player, vec.f_82479_, vec.f_82480_, vec.f_82481_, event.getTarget().m_82425_());
            event.setCanceled(true);
        }
        RenderSystem.enableCull();
    }

    private void renderHitOutline(PoseStack pose, Level level, VertexConsumer consumer, Entity entity, double x, double y, double z, BlockPos pos) {
        VoxelShape shape;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BlockTile) {
            BlockTile block2 = (BlockTile)block;
            shape = block2.getSelectionShape((BlockGetter)level, pos);
        } else {
            shape = state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity));
        }
        PreviewRenderer.renderShape(pose, consumer, shape, (double)pos.m_123341_() - x, (double)pos.m_123342_() - y, (double)pos.m_123343_() - z, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void renderShape(PoseStack pose, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = pose.m_85850_();
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float f = (float)(x2 - x1);
            float f1 = (float)(y2 - y1);
            float f2 = (float)(z2 - z1);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            consumer.m_252986_(posestack$pose.m_252922_(), (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(red, green, blue, alpha).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            consumer.m_252986_(posestack$pose.m_252922_(), (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(red, green, blue, alpha).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
        });
    }
}

