/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.overlay;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.common.gui.controls.GuiActionDisplay;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;

public class OverlayRenderer
implements IGuiIntegratedParent,
LevelAwareHandler {
    private static final Minecraft MC = Minecraft.m_91087_();
    private final GuiActionDisplay actionDisplay = new GuiActionDisplay("action").setMessageCount(1);
    private boolean doneInit = false;
    private final GuiLayer transparentLayer = new GuiLayer("overlay"){
        private TupleList<GuiChildControl, OverlayPosition> positions;
        {
            this.positions = new TupleList();
        }

        public void create() {
            this.addOverlayControl(OverlayRenderer.this.actionDisplay, OverlayPosition.ACTION_BAR);
        }

        public void addOverlayControl(GuiControl control, OverlayPosition position) {
            this.positions.add((Object)super.addControl(control), (Object)position);
        }

        public ControlFormatting getControlFormatting() {
            return ControlFormatting.TRANSPARENT;
        }

        public boolean hasGrayBackground() {
            return false;
        }

        public void flowY(int width, int height, int preferred) {
            super.flowY(width, height, preferred);
            for (Tuple tuple : this.positions) {
                ((OverlayPosition)((Object)tuple.value)).positionControl((GuiChildControl)tuple.key, width, height);
            }
        }

        public boolean isExpandableX() {
            return true;
        }

        public boolean isExpandableY() {
            return true;
        }
    };
    private final SingletonList<GuiLayer> layers = new SingletonList((Object)this.transparentLayer);
    private final Screen screen = new Screen((Component)Component.m_237113_((String)"overlay")){};
    private final ScreenEventListener listener = new ScreenEventListener((IGuiIntegratedParent)this, this.screen);
    private int lastWidth = -1;
    private int lastHeight = -1;

    public OverlayRenderer() {
        MinecraftForge.EVENT_BUS.addListener(this::renderPost);
    }

    public void displayActionMessage(List<Component> message) {
        this.actionDisplay.addMessage(message);
    }

    public void renderPost(RenderGuiEvent.Post event) {
        LocalPlayer player = OverlayRenderer.MC.f_91074_;
        Font font = OverlayRenderer.MC.f_91062_;
        if (player != null && !OverlayRenderer.MC.f_91066_.f_92062_) {
            Item item;
            if (!this.doneInit) {
                this.transparentLayer.style = GuiStyle.getStyle((String)this.transparentLayer.name);
                this.transparentLayer.init();
                this.doneInit = true;
            }
            GuiGraphics graphics = event.getGuiGraphics();
            this.screen.f_96543_ = MC.m_91268_().m_85445_();
            this.screen.f_96544_ = MC.m_91268_().m_85446_();
            if (this.screen.f_96543_ != this.lastWidth || this.screen.f_96544_ != this.lastHeight) {
                this.transparentLayer.reflow();
                this.lastWidth = this.screen.f_96543_;
                this.lastHeight = this.screen.f_96544_;
            }
            this.render(graphics, this.screen, this.listener, 0, 0);
            if (LittleTiles.CONFIG.rendering.showTooltip && (item = player.m_21205_().m_41720_()) instanceof IItemTooltip) {
                IItemTooltip item2 = (IItemTooltip)item;
                ItemStack stack = player.m_21205_();
                Object tooltipKey = stack.m_41720_().m_204114_().m_205785_().m_135782_().m_135827_() + "." + stack.m_41720_().m_204114_().m_205785_().m_135782_().m_135815_() + ".tooltip";
                if (LanguageUtils.can((String)(tooltipKey = item2.tooltipTranslateKey(stack, (String)tooltipKey)))) {
                    String[] lines = Component.m_237110_((String)tooltipKey, (Object[])item2.tooltipData(stack)).getString().split("\\n");
                    int y = MC.m_91268_().m_85446_() - 2;
                    for (int i = lines.length - 1; i >= 0; --i) {
                        String s = lines[i];
                        if (Strings.isNullOrEmpty((String)s)) continue;
                        Objects.requireNonNull(font);
                        int k = font.m_92895_(s);
                        int i1 = 2 + (y -= 9);
                        Objects.requireNonNull(font);
                        graphics.m_280509_(1, i1 - 1, 2 + k + 1, i1 + 9 - 1, -1873784752);
                        graphics.m_280488_(font, s, 2, i1, 0xE0E0E0);
                    }
                }
            }
        }
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isClient() {
        return true;
    }

    public Player getPlayer() {
        return OverlayRenderer.MC.f_91074_;
    }

    public void closeTopLayer() {
    }

    public void closeLayer(GuiLayer layer) {
    }

    public List<GuiLayer> getLayers() {
        return this.layers;
    }

    public GuiLayer getTopLayer() {
        return this.transparentLayer;
    }

    public void openLayer(GuiLayer layer) {
    }

    public void closeLayer(int layer) {
    }

    public void send(CreativePacket message) {
    }

    @Override
    public void unload() {
        this.actionDisplay.clearMessages();
    }

    public HolderLookup.Provider provider() {
        return OverlayRenderer.MC.f_91073_.m_9598_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OverlayPosition {
        CENTER{

            @Override
            protected void positionControl(GuiChildControl control, int width, int height) {
                control.setX(width / 2 - control.getWidth() / 2);
                control.setY(height / 2 - control.getHeight() / 2);
            }
        }
        ,
        ACTION_BAR{

            @Override
            protected void positionControl(GuiChildControl control, int width, int height) {
                control.setX(width / 2 - control.getWidth() / 2);
                control.setY(height - control.getHeight() - 30);
            }
        };


        protected abstract void positionControl(GuiChildControl var1, int var2, int var3);
    }
}

