/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.mc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryUtil;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.mixin.BufferBuilderAccessor;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;

public interface RenderChunkExtender {
    public static Vec3 offsetCorrection(Vec3i to, Vec3i from) {
        if (to == from || to.equals((Object)from)) {
            return null;
        }
        return new Vec3((double)(from.m_123341_() - to.m_123341_()), (double)(from.m_123342_() - to.m_123342_()), (double)(from.m_123343_() - to.m_123343_()));
    }

    public LittleRenderPipelineType getPipeline();

    public void begin(BufferBuilder var1);

    public VertexBuffer getVertexBuffer(RenderType var1);

    public void markReadyForUpdate(boolean var1);

    default public void setQuadSorting(BufferBuilder builder, Vec3 vec) {
        this.setQuadSorting(builder, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public void setQuadSorting(BufferBuilder var1, double var2, double var4, double var6);

    default public void prepareModelOffset(BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
        modelOffset.m_122178_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
    }

    public boolean isEmpty(RenderType var1);

    public BufferBuilder.SortState getTransparencyState();

    public void setHasBlock(RenderType var1);

    public BlockPos standardOffset();

    default public Vec3 offsetCorrection(RenderChunkExtender chunk) {
        return RenderChunkExtender.offsetCorrection((Vec3i)this.standardOffset(), (Vec3i)chunk.standardOffset());
    }

    default public int sectionIndex() {
        return -1;
    }

    public int getQueued();

    public void setQueued(int var1);

    public ChunkLayerMap<BufferCollection> getLastUploaded();

    public void setLastUploaded(ChunkLayerMap<BufferCollection> var1);

    default public void prepareUpload() {
        this.setLastUploaded(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void uploaded(RenderType layer, BufferCollection buffers) {
        if (buffers == null) {
            return;
        }
        ChunkLayerMap uploaded = this.getLastUploaded();
        if (this.getLastUploaded() == null) {
            uploaded = new ChunkLayerMap();
            this.setLastUploaded((ChunkLayerMap<BufferCollection>)uploaded);
        }
        uploaded.put(layer, (Object)buffers);
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            if (this.getQueued() == 0) {
                buffers.eraseBuffers();
            }
        }
    }

    default public void backToRAM() {
        ChunkLayerMap<BufferCollection> lastUploaded = this.getLastUploaded();
        if (lastUploaded == null) {
            return;
        }
        Supplier<Boolean> run = () -> {
            ChunkBufferDownloader.SimpleChunkBufferDownloader downloader = new ChunkBufferDownloader.SimpleChunkBufferDownloader();
            for (Tuple tuple : lastUploaded.tuples()) {
                VertexBuffer buffer = this.getVertexBuffer((RenderType)tuple.key);
                BufferCollection uploaded = (BufferCollection)tuple.value;
                if (Minecraft.m_91087_().f_91073_ == null || uploaded == null || ((VertexBufferExtender)buffer).getVertexBufferId() == -1) {
                    if (uploaded == null) continue;
                    uploaded.discard();
                    continue;
                }
                ByteBuffer uploadedData = this.downloadUploadedData((VertexBufferExtender)buffer, 0L, ((VertexBufferExtender)buffer).getLastUploadedLength());
                if (uploadedData != null) {
                    downloader.buffer = uploadedData;
                    uploaded.download(downloader);
                    uploadedData.rewind();
                    downloader.buffer = null;
                    continue;
                }
                uploaded.discard();
            }
            this.setLastUploaded(null);
            return true;
        };
        try {
            if (Minecraft.m_91087_().m_18695_()) {
                run.get();
            } else {
                CompletableFuture future = Minecraft.m_91087_().m_18691_(run);
                future.get();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ByteBuffer downloadUploadedData(VertexBufferExtender buffer, long offset, int size) {
        GlStateManager._glBindBuffer((int)34962, (int)buffer.getVertexBufferId());
        try {
            ByteBuffer result = ByteBuffer.allocateDirect(size);
            GL15C.glGetBufferSubData((int)34962, (long)offset, (ByteBuffer)result);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (!(e instanceof IllegalStateException)) {
                e.printStackTrace();
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
    }

    default public boolean appendRenderData(Iterable<? extends LayeredBufferCache> blocks) {
        for (RenderType layer : RenderType.m_110506_()) {
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            VertexBuffer uploadBuffer = this.getVertexBuffer(layer);
            if (uploadBuffer == null) {
                return false;
            }
            VertexFormat vertexFormat = uploadBuffer.m_166892_();
            if (vertexFormat == null) {
                VertexFormat vertexFormat2 = DefaultVertexFormat.f_85811_;
            }
            Buffer vanillaBuffer = null;
            if (!this.isEmpty(layer)) {
                vanillaBuffer = this.downloadUploadedData((VertexBufferExtender)uploadBuffer, 0L, ((VertexBufferExtender)uploadBuffer).getLastUploadedLength());
            }
            BufferBuilder builder = new BufferBuilder(((vanillaBuffer != null ? vanillaBuffer.limit() : 0) + size + DefaultVertexFormat.f_85811_.m_86020_()) / 6);
            this.begin(builder);
            if (vanillaBuffer != null) {
                BufferBuilder.SortState state;
                if (layer == RenderType.m_110466_() && (state = this.getTransparencyState()) != null) {
                    builder.m_166775_(state);
                }
                builder.putBulkData((ByteBuffer)vanillaBuffer);
            }
            for (LayeredBufferCache layeredBufferCache : blocks) {
                layeredBufferCache.get(layer).upload((ChunkBufferUploader)builder);
            }
            if (layer == RenderType.m_110466_()) {
                this.setQuadSorting(builder, Minecraft.m_91087_().f_91060_.m_173015_().m_112727_());
            }
            uploadBuffer.m_85921_();
            uploadBuffer.m_231221_(builder.m_231175_());
            MemoryUtil.memFree((Buffer)((BufferBuilderAccessor)builder).getBuffer());
            VertexBuffer.m_85931_();
            this.setHasBlock(layer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void startBuilding(RebuildTaskExtender task) {
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            this.setQueued(this.getQueued() + 1);
        }
        this.backToRAM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void endBuilding(RebuildTaskExtender task) {
        RenderChunkExtender renderChunkExtender = this;
        synchronized (renderChunkExtender) {
            this.setQueued(this.getQueued() - 1);
        }
    }
}

