/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderUploader {
    private static final HashMap<Level, RenderDataLevel> CACHES = new HashMap();

    private static RenderDataLevel getOrCreate(Level level) {
        RenderDataLevel data = CACHES.get(level);
        if (data == null) {
            data = new RenderDataLevel(level);
            CACHES.put(level, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Level targetLevel, LittleAnimationEntity entity) {
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            RenderUploader.getOrCreate(entity.m_9236_()).queue(targetLevel, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyReceiveClientUpdate(BETiles be) {
        if (CACHES.isEmpty()) {
            return;
        }
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            RenderDataLevel data = CACHES.get(be.m_58904_());
            if (data != null && data.notifyReceiveClientUpdate(be)) {
                CACHES.remove(be.m_58904_());
            }
        }
    }

    public static void unload() {
        CACHES.clear();
    }

    public static void longTick(int index) {
        Iterator<RenderDataLevel> iterator = CACHES.values().iterator();
        while (iterator.hasNext()) {
            RenderDataLevel level = iterator.next();
            if (!level.longTick(index)) continue;
            iterator.remove();
        }
    }

    public static class RenderDataLevel {
        public final Level level;
        private final HashMap<BlockPos, RenderDataToAdd> caches = new HashMap();
        private int waitTill;

        public RenderDataLevel(Level level) {
            this.level = level;
        }

        private RenderDataToAdd getOrCreate(Level targetLevel, RenderChunkExtender chunk, BlockPos pos) {
            RenderDataToAdd data = this.caches.get(pos);
            if (data == null) {
                data = new RenderDataToAdd(targetLevel, chunk);
                this.caches.put(pos, data);
            }
            return data;
        }

        public void queue(Level targetLevel, LittleAnimationEntity entity) {
            HashSet<RenderChunkExtender> chunks = new HashSet<RenderChunkExtender>();
            for (BETiles be : entity.getSubLevel()) {
                RenderChunkExtender chunk = be.render.getRenderChunk();
                if (chunks.add(chunk)) {
                    chunk.backToRAM();
                }
                RenderDataToAdd block = this.getOrCreate(targetLevel, BERenderManager.getRenderChunk(targetLevel, be.m_58899_()), be.m_58899_());
                block.queueNew(be);
            }
            this.waitTill = LittleTilesClient.ANIMATION_HANDLER.longTickIndex + 2;
            HashMapList chunksList = new HashMapList();
            for (RenderDataToAdd block : this.caches.values()) {
                chunksList.add((Object)block.targetChunk, (Object)block);
            }
            if (LittleTiles.CONFIG.rendering.uploadToVBODirectly) {
                for (Map.Entry entry : chunksList.entrySet()) {
                    if (((RenderChunkExtender)entry.getKey()).appendRenderData((Iterable)entry.getValue())) continue;
                    ((RenderChunkExtender)entry.getKey()).markReadyForUpdate(false);
                }
            } else {
                for (RenderChunkExtender chunk : chunksList.keySet()) {
                    chunk.markReadyForUpdate(false);
                }
            }
        }

        public boolean notifyReceiveClientUpdate(BETiles be) {
            RenderDataToAdd data = this.caches.remove(be.m_58899_());
            if (data != null) {
                data.receiveUpdate(be);
            }
            return this.caches.isEmpty();
        }

        public boolean longTick(int index) {
            return index >= this.waitTill;
        }
    }

    private static class RenderDataToAdd
    implements LayeredBufferCache {
        private final ChunkLayerMap<BufferCache> holders = new ChunkLayerMap();
        private final Level targetLevel;
        private final RenderChunkExtender targetChunk;
        private BETiles cached = null;
        private boolean toSearch = true;

        public RenderDataToAdd(Level targetLevel, RenderChunkExtender chunk) {
            this.targetLevel = targetLevel;
            this.targetChunk = chunk;
        }

        @Override
        public BufferCache get(RenderType layer) {
            return (BufferCache)this.holders.get(layer);
        }

        public void queueNew(BETiles be) {
            IBlockBufferCache cache = be.render.buffers();
            Vec3 vec = this.targetChunk.offsetCorrection(be.render.getRenderChunk());
            for (RenderType layer : RenderType.m_110506_()) {
                BufferCache holder = cache.get(layer);
                if (holder == null) continue;
                if (vec != null) {
                    holder.applyOffset(vec);
                }
                holder.markAsAdditional();
                this.holders.put(layer, (Object)BlockBufferCache.combine((BufferCache)this.holders.get(layer), holder));
            }
            if (this.toSearch) {
                this.cached = BlockTile.loadBE((BlockGetter)this.targetLevel, be.m_58899_());
                if (this.cached != null) {
                    this.cached.render.additionalBuffersEarly(x -> x.additional(this));
                }
                this.toSearch = false;
            }
        }

        public void receiveUpdate(BETiles be) {
            if (this.cached != be) {
                be.render.additionalBuffers(x -> x.additional(this));
            }
        }
    }
}

