/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.type.itr.InverseConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.InverseListIterator;
import team.creative.creativecore.common.util.type.itr.NestedIterator;
import team.creative.littletiles.client.render.level.LittleRenderChunk;

public class LittleRenderChunks
implements Iterable<LittleRenderChunk> {
    private static final SectionPos ZERO = SectionPos.m_123173_((int)0, (int)0, (int)0);
    private LinkedList<List<LittleRenderChunk>> rings = new LinkedList();
    private SectionPos origin = ZERO;
    private int minDistance = -1;
    private int maxUsedRings = -1;
    private int size = 0;

    public int getChunkDistance(LittleRenderChunk chunk) {
        return chunk.section.m_123333_((Vec3i)this.origin);
    }

    public void arrangeRings(SectionPos newOrigin, Iterable<LittleRenderChunk> chunks) {
        this.clearRings();
        this.origin = newOrigin;
        this.addAll(chunks);
    }

    public void addAll(Iterable<LittleRenderChunk> chunks) {
        for (LittleRenderChunk chunk : chunks) {
            this.add(chunk);
        }
    }

    public void add(LittleRenderChunk chunk) {
        int distance = this.getChunkDistance(chunk);
        if (this.minDistance == -1) {
            this.minDistance = distance;
            this.getRing(0, true).add(chunk);
        } else if (this.minDistance > distance) {
            this.ensureLowerRings(this.minDistance - distance);
            this.minDistance = distance;
            this.getRing(0, true).add(chunk);
        } else {
            this.getRing(distance - this.minDistance, true).add(chunk);
        }
        this.maxUsedRings = Math.max(this.maxUsedRings, distance - this.minDistance);
        ++this.size;
    }

    private void ensureRings(int size) {
        for (int i = this.rings.size(); i < size; ++i) {
            this.rings.add(new ArrayList());
        }
    }

    private void ensureLowerRings(int count) {
        for (int i = 0; i < count; ++i) {
            if (this.maxUsedRings < this.rings.size()) {
                this.rings.addFirst(this.rings.getLast());
                this.rings.removeLast();
                ++this.maxUsedRings;
                continue;
            }
            this.rings.addFirst(new ArrayList());
        }
    }

    private void recountSize() {
        this.size = 0;
        for (List list : this.rings) {
            this.size += list.size();
        }
    }

    protected List<LittleRenderChunk> getRing(int index, boolean create) {
        if (create) {
            this.ensureRings(index + 1);
            return this.rings.get(index);
        }
        if (this.rings.size() <= index) {
            throw new IllegalArgumentException("Bucket index '" + index + "' is out of bounds (total " + this.rings.size() + ")");
        }
        return this.rings.get(index);
    }

    public void remove(LittleRenderChunk chunk) {
        int distance = this.getChunkDistance(chunk);
        if (this.rings.size() > distance && this.getRing(distance, false).remove(chunk)) {
            --this.size;
        }
    }

    public void removeAll(int bucket, Collection<LittleRenderChunk> chunks) {
        for (LittleRenderChunk chunk : chunks) {
            this.remove(chunk);
        }
    }

    public List<LittleRenderChunk> removeRing(int distance) {
        List<LittleRenderChunk> ring = this.rings.remove(distance);
        this.recountSize();
        return ring;
    }

    public void clear() {
        this.rings.clear();
    }

    public void clearRings() {
        for (List list : this.rings) {
            list.clear();
        }
        this.size = 0;
        this.minDistance = -1;
        this.maxUsedRings = -1;
    }

    public Iterable<? extends Iterable<LittleRenderChunk>> rings() {
        return this.rings;
    }

    public int ringCount() {
        return this.rings.size();
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<LittleRenderChunk> iterator() {
        return new NestedIterator(this.rings);
    }

    public Iterator<LittleRenderChunk> inverseIterator() {
        Iterator[] itrs = new Iterator[this.rings.size()];
        for (int i = 0; i < itrs.length; ++i) {
            itrs[i] = new InverseListIterator(this.rings.get(i));
        }
        return new InverseConsecutiveIterator(itrs);
    }
}

