/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;

public class LittleClientEventHandler {
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    public static int transparencySortingIndex;

    @SubscribeEvent
    public synchronized void levelUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            RenderingThread.unload();
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderBlockScreenEffectEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER) {
            PoseStack pose = new PoseStack();
            Player player = event.getPlayer();
            BlockPos blockpos = BlockPos.m_274446_((Position)player.m_20299_(TickUtils.getFrameTime((LevelAccessor)player.m_9236_())));
            BlockEntity blockEntity = player.m_9236_().m_7702_(blockpos);
            if (blockEntity instanceof BETiles) {
                BETiles be = (BETiles)blockEntity;
                AABB bb = player.m_20191_();
                for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                    LittleTile tile = (LittleTile)pair.value;
                    if (!tile.isFluid((TagKey<Fluid>)FluidTags.f_13131_) || !tile.intersectsWith(bb, (IParentCollection)pair.key)) continue;
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RES_UNDERWATER_OVERLAY);
                    Tesselator tesselator = Tesselator.m_85913_();
                    BufferBuilder bufferbuilder = tesselator.m_85915_();
                    float f = LightTexture.m_234316_((DimensionType)player.m_9236_().m_6042_(), (int)player.m_9236_().m_46803_(blockpos));
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)0.1f);
                    Vector3d color = ColorUtils.toVec((int)tile.color);
                    RenderSystem.setShaderColor((float)(f * (float)color.x), (float)(f * (float)color.y), (float)(f * (float)color.z), (float)0.5f);
                    float f7 = -mc.f_91074_.m_146908_() / 64.0f;
                    float f8 = mc.f_91074_.m_146909_() / 64.0f;
                    Matrix4f matrix4f = pose.m_85850_().m_252922_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + f7, 4.0f + f8).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + f7, 4.0f + f8).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + f7, 0.0f + f8).m_5752_();
                    bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + f7, 0.0f + f8).m_5752_();
                    tesselator.m_85914_();
                    RenderSystem.disableBlend();
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }
}

