/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import team.creative.creativecore.client.render.model.CreativeBakedBoxModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.client.render.item.ItemModelCache;
import team.creative.littletiles.client.render.item.ItemModelCacheLayered;

public class ItemRenderCache
implements LevelAwareHandler {
    public static final RenderingThreadItem THREAD = new RenderingThreadItem();
    private RenderedStack temp = new RenderedStack();
    private HashMap<RenderedStack, ItemModelCache> caches = new HashMap();
    private int slowTicker = 0;
    private int timeToCheckSlowTick = 100;

    public static CreativeItemBoxModel get(ItemStack stack) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0);
        if (model instanceof CreativeBakedBoxModel) {
            return (CreativeItemBoxModel)((CreativeBakedBoxModel)model).item;
        }
        return null;
    }

    public ItemRenderCache() {
        MinecraftForge.EVENT_BUS.addListener(this::tick);
    }

    public int countCaches() {
        return this.caches.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BakedQuad> requestCache(ItemStack stack, boolean translucent) {
        HashMap<RenderedStack, ItemModelCache> hashMap = this.caches;
        synchronized (hashMap) {
            if (!stack.m_41782_()) {
                return null;
            }
            ItemModelCache cache = this.caches.get(this.temp.set(stack));
            if (cache != null) {
                return cache.getQuads(translucent);
            }
            CreativeItemBoxModel renderer = ItemRenderCache.get(stack);
            if (renderer != null) {
                cache = renderer.hasTranslucentLayer(stack) ? new ItemModelCacheLayered() : new ItemModelCache();
                this.caches.put(new RenderedStack().set(stack), cache);
                ItemRenderCache.THREAD.items.add((Pair<ItemStack, ItemModelCache>)new Pair((Object)stack, (Object)cache));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<RenderedStack, ItemModelCache> hashMap = this.caches;
        synchronized (hashMap) {
            this.caches.clear();
            ItemRenderCache.THREAD.items.clear();
        }
    }

    @Override
    public void unload() {
        this.caches.clear();
        ItemRenderCache.THREAD.items.clear();
    }

    public void tick(TickEvent.ClientTickEvent event) {
        ++this.slowTicker;
        if (this.slowTicker >= this.timeToCheckSlowTick) {
            Iterator<ItemModelCache> iterator = this.caches.values().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().expired()) continue;
                iterator.remove();
            }
            this.slowTicker = 0;
        }
    }

    public static class RenderedStack {
        private Item item;
        private CompoundTag nbt;

        public RenderedStack set(ItemStack stack) {
            this.item = stack.m_41720_();
            this.nbt = stack.m_41783_();
            return this;
        }

        public int hashCode() {
            return this.nbt.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenderedStack) {
                RenderedStack stack = (RenderedStack)obj;
                return stack.item == this.item && stack.nbt.equals((Object)this.nbt);
            }
            return false;
        }
    }

    public static class RenderingThreadItem
    extends Thread {
        public ConcurrentLinkedQueue<Pair<ItemStack, ItemModelCache>> items = new ConcurrentLinkedQueue();

        public RenderingThreadItem() {
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                if (Minecraft.m_91087_().f_91073_ != null && !this.items.isEmpty()) {
                    int j;
                    Pair<ItemStack, ItemModelCache> pair = this.items.poll();
                    CreativeItemBoxModel renderer = ItemRenderCache.get((ItemStack)pair.getKey());
                    if (renderer == null) continue;
                    boolean translucent = renderer.hasTranslucentLayer((ItemStack)pair.key);
                    RandomSource rand = RandomSource.m_216327_();
                    ArrayList<Object> quads = new ArrayList<BakedQuad>();
                    for (j = 0; j < Facing.VALUES.length; ++j) {
                        CreativeBakedBoxModel.compileBoxes((List)renderer.getBoxes((ItemStack)pair.key, false), (Facing)Facing.VALUES[j], (RenderType)Sheets.m_110790_(), (RandomSource)rand, (boolean)true, quads);
                    }
                    ((ItemModelCache)pair.value).setQuads(false, quads);
                    if (translucent) {
                        quads = new ArrayList();
                        for (j = 0; j < Facing.VALUES.length; ++j) {
                            CreativeBakedBoxModel.compileBoxes((List)renderer.getBoxes((ItemStack)pair.key, true), (Facing)Facing.VALUES[j], (RenderType)Sheets.m_110792_(), (RandomSource)rand, (boolean)true, quads);
                        }
                        ((ItemModelCache)pair.value).setQuads(true, quads);
                    }
                    ((ItemModelCache)pair.value).complete();
                    continue;
                }
                try {
                    RenderingThreadItem.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

