/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineForge;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;

public abstract class LittleRenderPipelineType<T extends LittleRenderPipeline> {
    private static final List<LittleRenderPipelineType> TYPES = new ArrayList<LittleRenderPipelineType>();
    public static final LittleRenderPipelineTypeForge FORGE = new LittleRenderPipelineTypeForge();
    public final Supplier<T> factory;
    public final int id;

    public static int typeCount() {
        return TYPES.size();
    }

    public static LittleRenderPipelineType get(int id) {
        return TYPES.get(id);
    }

    public static void startCompile(RenderChunkExtender chunk, RebuildTaskExtender task) {
        chunk.startBuilding(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compile(RenderChunkExtender chunk, BETiles be, RebuildTaskExtender rebuildTask) {
        be.updateQuadCache(chunk);
        IBlockBufferCache cache = be.render.buffers();
        BERenderManager bERenderManager = be.render;
        synchronized (bERenderManager) {
            for (RenderType layer : RenderType.m_110506_()) {
                if (!cache.has(layer)) continue;
                cache.setUploaded(layer, rebuildTask.upload(layer, cache.get(layer)));
            }
        }
    }

    public static void endCompile(RenderChunkExtender chunk, RebuildTaskExtender task) {
        chunk.endBuilding(task);
    }

    protected LittleRenderPipelineType(Supplier<T> factory) {
        this.factory = factory;
        this.id = TYPES.size();
        TYPES.add(this);
    }

    public static class LittleRenderPipelineTypeForge
    extends LittleRenderPipelineType<LittleRenderPipelineForge> {
        private LittleRenderPipelineTypeForge() {
            super(LittleRenderPipelineForge::new);
        }
    }
}

