/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.pipeline;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.lighting.QuadLighter;
import team.creative.creativecore.client.render.model.CreativeQuadLighter;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.mixin.BufferBuilderAccessor;
import team.creative.creativecore.mixin.ForgeModelBlockRendererAccessor;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.level.little.LittleSubLevel;

@OnlyIn(value=Dist.CLIENT)
public class LittleRenderPipelineForge
extends LittleRenderPipeline {
    private final BufferBuilder builder = new BufferBuilder(131072);
    private final BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();

    @Override
    public void buildCache(PoseStack pose, ChunkLayerMap<BufferCache> buffers, RenderingBlockContext data, VertexFormat format, SingletonList<BakedQuad> bakedQuadWrapper) {
        LittleSubLevel sub;
        Level renderLevel = data.be.m_58904_();
        while (renderLevel instanceof LittleSubLevel && !(sub = (LittleSubLevel)renderLevel).shouldUseLightingForRenderig()) {
            renderLevel = sub.getParent();
        }
        BlockPos pos = data.be.m_58899_();
        ForgeModelBlockRendererAccessor renderer = (ForgeModelBlockRendererAccessor)MC.m_91289_().m_110937_();
        boolean smooth = Minecraft.m_91086_() && data.state.getLightEmission((BlockGetter)data.be.m_58904_(), pos) == 0;
        QuadLighter lighter = smooth ? (QuadLighter)renderer.getSmoothLighter().get() : (QuadLighter)renderer.getFlatLighter().get();
        lighter.setup((BlockAndTintGetter)renderLevel, pos, data.state);
        int overlay = OverlayTexture.f_118083_;
        data.chunk.prepareModelOffset(this.modelOffset, pos);
        pose.m_252880_((float)this.modelOffset.m_123341_(), (float)this.modelOffset.m_123342_(), (float)this.modelOffset.m_123343_());
        for (Tuple entry : data.be.render.boxCache.tuples()) {
            IndexedCollector cubes = (IndexedCollector)entry.value;
            if (cubes == null || cubes.isEmpty()) continue;
            this.builder.m_166779_(VertexFormat.Mode.QUADS, format);
            IntArrayList indexes = new IntArrayList();
            Iterator iterator = cubes.sectionIterator(x -> {
                indexes.add(x);
                indexes.add(((BufferBuilderAccessor)this.builder).getVertices() * format.m_86020_());
            });
            while (iterator.hasNext()) {
                LittleRenderBox cube = (LittleRenderBox)((Object)iterator.next());
                BlockState state = cube.state;
                ((CreativeQuadLighter)lighter).setState(state);
                ((CreativeQuadLighter)lighter).setCustomTint(cube.color);
                for (int h = 0; h < Facing.VALUES.length; ++h) {
                    Facing facing = Facing.VALUES[h];
                    Object quadObject = cube.getQuad(facing);
                    SingletonList<BakedQuad> quads = null;
                    if (quadObject instanceof List) {
                        quads = (SingletonList<BakedQuad>)quadObject;
                    } else if (quadObject instanceof BakedQuad) {
                        BakedQuad quad = (BakedQuad)quadObject;
                        bakedQuadWrapper.setElement((Object)quad);
                        quads = bakedQuadWrapper;
                    }
                    if (quads == null || quads.isEmpty()) continue;
                    if (quads instanceof SingletonList) {
                        SingletonList<BakedQuad> single = quads;
                        lighter.process((VertexConsumer)this.builder, pose.m_85850_(), (BakedQuad)single.get(0), overlay);
                        continue;
                    }
                    for (BakedQuad quad : quads) {
                        lighter.process((VertexConsumer)this.builder, pose.m_85850_(), quad, overlay);
                    }
                }
                bakedQuadWrapper.setElement(null);
                if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                cube.deleteQuadCache();
            }
            buffers.put((RenderType)entry.key, (Object)new BufferHolder(this.builder.m_231175_(), indexes.toIntArray()));
        }
        ((CreativeQuadLighter)lighter).setCustomTint(-1);
        lighter.reset();
    }

    @Override
    public void reload() {
    }

    @Override
    public void release() {
    }
}

