/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import team.creative.creativecore.client.render.box.QuadGeneratorContext;
import team.creative.creativecore.common.level.LevelAccesorFake;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;

@OnlyIn(value=Dist.CLIENT)
public class RenderingThread
extends Thread {
    public static volatile int CURRENT_RENDERING_INDEX = Integer.MIN_VALUE;
    private static final ChunkLayerMap<BufferCache> EMPTY_HOLDERS = new ChunkLayerMap();
    public static List<RenderingThread> THREADS;
    public static final HashMap<RenderChunkExtender, Integer> CHUNKS;
    public static final Minecraft MC;
    private static final ConcurrentLinkedQueue<RenderingBlockContext> QUEUE;
    private final SingletonList<BakedQuad> bakedQuadWrapper = new SingletonList(null);
    private final LevelAccesorFake fakeAccess = new LevelAccesorFake();
    private final ChunkLayerMap<BufferCache> buffers = new ChunkLayerMap();
    public boolean active = true;
    private volatile boolean requiresReload = false;
    private LittleRenderPipeline[] pipelines = new LittleRenderPipeline[LittleRenderPipelineType.typeCount()];
    private QuadGeneratorContext quadContext;

    public static synchronized void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (THREADS != null) {
            for (RenderingThread thread : THREADS) {
                if (thread == null) continue;
                thread.interrupt();
            }
            while (QUEUE.size() > 0) {
                RenderingThread.QUEUE.poll().be.render.resetRenderingState();
            }
        }
        THREADS = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            THREADS.add(new RenderingThread());
        }
    }

    public static synchronized void unload() {
        if (THREADS != null) {
            for (RenderingThread thread : THREADS) {
                if (thread == null) continue;
                thread.interrupt();
            }
        }
        THREADS = null;
        QUEUE.clear();
        CHUNKS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean queue(BETiles be, @Nullable RenderChunkExtender chunk) {
        if (THREADS == null) {
            RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
        }
        if (chunk == null) {
            chunk = be.render.getRenderChunk();
        }
        if (chunk == null) {
            LittleTiles.LOGGER.error("Invalid tileentity with no rendering chunk! pos: " + be.m_58899_() + ", level: " + be.m_58904_());
            return false;
        }
        if (be.isRenderingEmpty()) {
            int index = be.render.startBuildingCache();
            BERenderManager bERenderManager = be.render;
            synchronized (bERenderManager) {
                be.render.boxCache.clear();
                be.render.setBuffersEmpty();
            }
            if (!be.render.finishBuildingCache(index, EMPTY_HOLDERS, CURRENT_RENDERING_INDEX, true)) {
                return RenderingThread.queue(be, chunk);
            }
            return false;
        }
        HashMap<RenderChunkExtender, Integer> hashMap = CHUNKS;
        synchronized (hashMap) {
            Integer count = CHUNKS.get(chunk);
            if (count == null) {
                count = 0;
            }
            CHUNKS.put(chunk, count + 1);
        }
        QUEUE.add(new RenderingBlockContext(be, chunk));
        return true;
    }

    public static int queueSize() {
        return QUEUE.size();
    }

    public static synchronized void reload() {
        if (THREADS == null) {
            return;
        }
        RenderingThread.unload();
    }

    public static <T extends LittleRenderPipeline> T getOrCreate(LittleRenderPipelineType<T> type) {
        for (RenderingThread thread : THREADS) {
            if (thread.pipelines[type.id] == null) continue;
            return (T)thread.pipelines[type.id];
        }
        return THREADS.get(0).get(type);
    }

    public RenderingThread() {
        this.start();
    }

    public <T extends LittleRenderPipeline> T get(LittleRenderPipelineType<T> type) {
        LittleRenderPipeline pipeline = this.pipelines[type.id];
        if (pipeline == null) {
            this.pipelines[type.id] = pipeline = (LittleRenderPipeline)type.factory.get();
            pipeline.reload();
        }
        return (T)pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.quadContext = new QuadGeneratorContext();
            while (this.active) {
                if (this.requiresReload) {
                    this.requiresReload = false;
                    for (int i = 0; i < this.pipelines.length; ++i) {
                        if (this.pipelines[i] == null) continue;
                        this.pipelines[i].reload();
                    }
                }
                ClientLevel level = RenderingThread.MC.f_91073_;
                long duration = 0L;
                RandomSource rand = RandomSource.m_216327_();
                PoseStack posestack = new PoseStack();
                if (level != null && !QUEUE.isEmpty()) {
                    RenderingBlockContext data = QUEUE.poll();
                    if (data == null) continue;
                    try {
                        if (LittleTilesProfilerOverlay.isActive()) {
                            duration = System.nanoTime();
                        }
                        data.checkRemoved();
                        data.checkLoaded();
                        data.index = data.be.render.startBuildingCache();
                        BlockPos pos = data.be.m_58899_();
                        data.beforeBuilding();
                        for (RenderType layer : RenderType.m_110506_()) {
                            IndexedCollector<LittleRenderBox> cubes = data.be.render.getRenderingBoxes(data, layer);
                            if (cubes == null) continue;
                            for (LittleRenderBox cube : cubes) {
                                if (!cube.doesNeedQuadUpdate) continue;
                                this.fakeAccess.set(data.be.m_58904_(), pos, cube.state);
                                level = this.fakeAccess;
                                BlockState modelState = cube.state;
                                rand.m_188584_(modelState.m_60726_(pos));
                                BakedModel blockModel = MC.m_91289_().m_110910_(modelState);
                                ModelData modelData = blockModel.getModelData((BlockAndTintGetter)level, pos, modelState, level.getModelDataManager() == null ? ModelData.EMPTY : level.getModelDataManager().getAt(pos));
                                BlockPos offset = cube.getOffset();
                                for (int h = 0; h < Facing.VALUES.length; ++h) {
                                    Facing facing = Facing.VALUES[h];
                                    if (cube.shouldRenderFace(facing)) {
                                        if (cube.getQuad(facing) != null) continue;
                                        cube.setQuad(facing, cube.getBakedQuad(this.quadContext, (LevelAccessor)level, pos, offset, modelState, blockModel, modelData, facing, layer, rand, true, -1));
                                        continue;
                                    }
                                    cube.setQuad(facing, null);
                                }
                                cube.doesNeedQuadUpdate = false;
                            }
                        }
                        this.quadContext.clear();
                        data.clearQuadBuilding();
                        this.fakeAccess.set(null, null, null);
                        data.checkRemoved();
                        level = RenderingThread.MC.f_91073_;
                        int renderState = CURRENT_RENDERING_INDEX;
                        VertexFormat format = DefaultVertexFormat.f_85811_;
                        try {
                            posestack.m_166856_();
                            ((LittleRenderPipeline)this.get(data.chunk.getPipeline())).buildCache(posestack, this.buffers, data, format, this.bakedQuadWrapper);
                            if (!LittleTiles.CONFIG.rendering.useCubeCache) {
                                data.be.render.boxCache.clear();
                            }
                            if (!RenderingThread.finish(data, this.buffers, renderState, false)) {
                                QUEUE.add(data);
                            }
                            this.buffers.clear();
                            if (LittleTilesProfilerOverlay.isActive()) {
                                LittleTilesProfilerOverlay.finishBuildingCache(System.nanoTime() - duration);
                            }
                        }
                        catch (Exception e) {
                            LittleTiles.LOGGER.error((Object)e);
                            if (!RenderingThread.finish(data, EMPTY_HOLDERS, -1, false)) {
                                QUEUE.add(data);
                            }
                        }
                    }
                    catch (RemovedBlockEntityException e) {
                        RenderingThread.finish(data, EMPTY_HOLDERS, -1, true);
                    }
                    catch (RenderingBlockedException e) {
                        QUEUE.add(data);
                    }
                    catch (Exception e) {
                        if (!(e instanceof RenderingException)) {
                            LittleTiles.LOGGER.error((Object)e);
                        }
                        RenderingThread.finish(data, EMPTY_HOLDERS, -1, true);
                    }
                    catch (OutOfMemoryError error) {
                        QUEUE.add(data);
                        LittleTiles.LOGGER.error((Object)error);
                    }
                    finally {
                        this.buffers.clear();
                        data.unsetBlocked();
                    }
                    data = null;
                } else if (level == null || QUEUE.isEmpty()) {
                    RenderingThread.sleep(1L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (InterruptedException i) {
            for (int i2 = 0; i2 < this.pipelines.length; ++i2) {
                if (this.pipelines[i2] == null) continue;
                this.pipelines[i2].release();
            }
        }
        finally {
            for (int i = 0; i < this.pipelines.length; ++i) {
                if (this.pipelines[i] == null) continue;
                this.pipelines[i].release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean finish(RenderingBlockContext data, ChunkLayerMap<BufferCache> buffers, int renderState, boolean force) {
        if (!data.be.render.finishBuildingCache(data.index, buffers, renderState, force)) {
            return false;
        }
        boolean complete = false;
        HashMap<RenderChunkExtender, Integer> hashMap = CHUNKS;
        synchronized (hashMap) {
            Integer count = CHUNKS.get(data.chunk);
            if (count != null) {
                if (count <= 1) {
                    CHUNKS.remove(data.chunk);
                    complete = true;
                } else {
                    CHUNKS.put(data.chunk, count - 1);
                }
            }
        }
        if (complete) {
            ++LittleTilesProfilerOverlay.chunkUpdates;
            data.chunk.markReadyForUpdate(false);
        }
        return true;
    }

    static {
        CHUNKS = new HashMap();
        MC = Minecraft.m_91087_();
        QUEUE = new ConcurrentLinkedQueue();
        RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
    }

    public static class RemovedBlockEntityException
    extends Exception {
        public RemovedBlockEntityException(String arg0) {
            super(arg0);
        }
    }

    public static class RenderingBlockedException
    extends RenderingException {
        public RenderingBlockedException() {
            super("");
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }
}

