/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.client.render.VertexFormatUtils;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;

public class BufferHolder
implements BufferCache {
    private ByteBuffer buffer;
    private int length;
    private int vertexCount;
    private final int[] indexes;
    private int groupCount;
    private boolean invalid;
    private int uploadIndex;

    public static BufferHolder combine(BufferHolder first, BufferHolder second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return (BufferHolder)first.combine(second);
    }

    public BufferHolder(ByteBuffer buffer, int length, int vertexCount, int[] indexes) {
        this.buffer = buffer;
        this.length = length;
        this.vertexCount = vertexCount;
        this.indexes = indexes;
        this.groupCount = indexes != null ? indexes.length / 2 : 0;
    }

    public BufferHolder(BufferBuilder.RenderedBuffer buffer, int[] indexes) {
        this.length = buffer.m_231198_().m_166812_();
        this.buffer = ByteBuffer.allocateDirect(this.length);
        this.buffer.put(buffer.m_231196_());
        this.buffer.rewind();
        this.vertexCount = buffer.m_231198_().f_85734_();
        buffer.m_231200_();
        this.indexes = indexes;
        this.groupCount = indexes != null ? indexes.length / 2 : 0;
    }

    @Override
    public void eraseBuffer() {
        if (this.uploadIndex >= 0) {
            this.buffer = null;
        }
    }

    @Override
    public void markAsAdditional() {
        this.uploadIndex = -2;
    }

    @Override
    public boolean upload(ChunkBufferUploader uploader) {
        if (!this.isAvailable()) {
            return false;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return false;
        }
        boolean additional = this.uploadIndex == -2;
        this.uploadIndex = uploader.uploadIndex();
        if (additional) {
            this.uploadIndex = -2;
        }
        uploader.upload(buffer);
        buffer.rewind();
        return true;
    }

    public boolean upload(int facing, ChunkBufferUploader uploader) {
        if (!this.isAvailable()) {
            return false;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return false;
        }
        boolean additional = this.uploadIndex == -2;
        this.uploadIndex = uploader.uploadIndex(facing);
        if (additional) {
            this.uploadIndex = -2;
        }
        uploader.upload(facing, buffer);
        buffer.rewind();
        return true;
    }

    public int[] indexes() {
        return this.indexes;
    }

    @Override
    public int groupCount() {
        return this.groupCount;
    }

    protected void removeEntry(int length, int vertexCount) {
        this.length -= length;
        this.vertexCount -= vertexCount;
        --this.groupCount;
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    public int length() {
        return this.length;
    }

    @Override
    public int lengthToUpload() {
        if (this.isAvailable()) {
            return this.length;
        }
        return 0;
    }

    @Override
    public int lengthToUpload(int facing) {
        if (this.isAvailable() && facing == ModelQuadFacing.UNASSIGNED.ordinal()) {
            return this.length;
        }
        return 0;
    }

    public int vertexCount() {
        return this.vertexCount;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        this.eraseBuffer();
    }

    @Override
    public boolean isAvailable() {
        return this.buffer != null && this.length > 0;
    }

    @Override
    public boolean download(ChunkBufferDownloader downloader) {
        return this.download(downloader.downloaded());
    }

    public boolean download(ByteBuffer buffer) {
        if (this.uploadIndex >= 0 && buffer.capacity() >= this.uploadIndex + this.length()) {
            ByteBuffer downloaded = ByteBuffer.allocateDirect(this.length);
            downloaded.put(0, buffer, this.uploadIndex, this.length);
            downloaded.rewind();
            this.buffer = downloaded;
            this.uploadIndex = -1;
            return true;
        }
        this.invalidate();
        return false;
    }

    @Override
    public BufferCache combine(BufferCache cache) {
        ByteBuffer secondBuffer;
        if (!(cache instanceof BufferHolder)) {
            return cache.combine(this);
        }
        BufferHolder holder = (BufferHolder)cache;
        int vertexCount = 0;
        int length = 0;
        ByteBuffer firstBuffer = this.byteBuffer();
        if (firstBuffer != null) {
            vertexCount += this.vertexCount();
            length += this.length();
        }
        if ((secondBuffer = holder.byteBuffer()) != null) {
            vertexCount += holder.vertexCount();
            length += holder.length();
        }
        if (vertexCount == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
        if (firstBuffer != null) {
            firstBuffer.position(0);
            firstBuffer.limit(this.length());
            byteBuffer.put(firstBuffer);
            firstBuffer.rewind();
        }
        if (secondBuffer != null) {
            secondBuffer.position(0);
            secondBuffer.limit(holder.length());
            byteBuffer.put(secondBuffer);
            secondBuffer.rewind();
        }
        byteBuffer.rewind();
        return new BufferHolder(byteBuffer, length, vertexCount, null);
    }

    @Override
    public BufferHolder extract(int index) {
        int[] indexes = this.indexes();
        if (indexes == null) {
            return null;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return null;
        }
        if (indexes.length == 2 && indexes[0] == index) {
            return new BufferHolder(buffer, this.length(), this.vertexCount(), (int[])indexes.clone());
        }
        int start = -1;
        int length = -1;
        int entryIndex = -1;
        for (int i = 0; i < indexes.length; i += 2) {
            if (indexes[i] == index) {
                start = indexes[i + 1];
                entryIndex = i;
                continue;
            }
            if (start == -1) continue;
            length = indexes[i + 1] - start;
            break;
        }
        if (start == -1) {
            return null;
        }
        if (length == -1) {
            length = this.length() - start;
        }
        if (length == 0) {
            return null;
        }
        int div = this.length() / this.vertexCount();
        int vertexCount = length / div;
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(length);
        newBuffer.put(0, buffer, start, length);
        newBuffer.rewind();
        this.removeEntry(length, vertexCount);
        if (entryIndex < indexes.length - 2) {
            buffer.put(start, buffer, start + length, buffer.limit() - (start + length));
            for (int i = entryIndex + 2; i < indexes.length; i += 2) {
                int n = i + 1;
                indexes[n] = indexes[n] - length;
            }
        }
        buffer.limit(buffer.limit() - length);
        return new BufferHolder(newBuffer, length, vertexCount, null);
    }

    @Override
    public void applyOffset(Vec3 vec) {
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return;
        }
        int positionOffset = VertexFormatUtils.blockPositionOffset();
        int formatSize = VertexFormatUtils.blockFormatSize();
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += formatSize) {
            float x = buffer.getFloat(i + positionOffset);
            buffer.putFloat(i + positionOffset, x + (float)vec.f_82479_);
            float y = buffer.getFloat(i + positionOffset + 4);
            buffer.putFloat(i + positionOffset + 4, y + (float)vec.f_82480_);
            float z = buffer.getFloat(i + positionOffset + 8);
            buffer.putFloat(i + positionOffset + 8, z + (float)vec.f_82481_);
        }
    }
}

