/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.AdditionalBufferReceiver;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;

public class BlockBufferCache
implements IBlockBufferCache,
AdditionalBufferReceiver {
    private ChunkLayerMap<BufferCache> queue = new ChunkLayerMap();
    private ChunkLayerMap<BufferCache> uploaded = new ChunkLayerMap();
    private transient ChunkLayerMap<BufferCache> additional = null;
    private transient boolean newAdditional = false;

    public static BufferCache combine(BufferCache first, BufferCache second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.combine(second);
    }

    private BufferCache getUploaded(RenderType layer) {
        BufferCache holder = (BufferCache)this.uploaded.get(layer);
        if (holder != null && holder.isInvalid()) {
            this.uploaded.remove(layer);
            return null;
        }
        return holder;
    }

    private BufferCache getOriginal(RenderType layer) {
        BufferCache queued = (BufferCache)this.queue.get(layer);
        if (queued == null) {
            return this.getUploaded(layer);
        }
        return queued;
    }

    @Override
    public BufferCache get(RenderType layer) {
        BufferCache original = this.getOriginal(layer);
        if (this.additional != null) {
            return BlockBufferCache.combine(original, (BufferCache)this.additional.get(layer));
        }
        return original;
    }

    @Override
    public BufferCache extract(RenderType layer, int index) {
        BufferCache holder = this.getOriginal(layer);
        if (holder == null) {
            return null;
        }
        boolean holderUploaded = this.uploaded.get(layer) != null;
        BufferCache extracted = holder.extract(index);
        if (holder.groupCount() == 0) {
            if (holderUploaded) {
                this.uploaded.remove(layer);
            } else {
                this.queue.remove(layer);
            }
        }
        return extracted;
    }

    @Override
    public boolean has(RenderType layer) {
        return this.queue.containsKey(layer) || this.getUploaded(layer) != null || this.additional != null && this.additional.containsKey(layer);
    }

    @Override
    public void setUploaded(RenderType layer, BufferCache uploadable) {
        this.queue.remove(layer);
        if (uploadable == null) {
            this.uploaded.remove(layer);
        } else {
            this.uploaded.put(layer, (Object)uploadable);
        }
    }

    public synchronized void setEmpty() {
        this.queue.clear();
        this.uploaded.clear();
        this.additional = null;
    }

    public boolean hasAdditional() {
        return this.additional != null;
    }

    public synchronized void setBuffers(ChunkLayerMap<BufferCache> buffers) {
        for (RenderType layer : RenderType.m_110506_()) {
            BufferCache buffer = (BufferCache)buffers.get(layer);
            if (buffer == null && this.additional == null) {
                this.uploaded.remove(layer);
            }
            if (buffer == null) {
                this.queue.remove(layer);
                continue;
            }
            this.queue.put(layer, (Object)buffer);
        }
        this.additional = null;
    }

    public synchronized void executeAdditional(Consumer<AdditionalBufferReceiver> consumer) {
        boolean bl = this.newAdditional = this.additional != null;
        if (!this.newAdditional) {
            this.additional = new ChunkLayerMap();
        }
        consumer.accept(this);
        this.newAdditional = false;
    }

    public void clearAdditional() {
        this.additional = null;
    }

    @Override
    public synchronized void additional(RenderType layer, BufferCache holder) {
        this.additional.put(layer, (Object)(this.newAdditional ? BlockBufferCache.combine((BufferCache)this.additional.get(layer), holder) : holder));
    }

    @Override
    public synchronized void additional(LayeredBufferCache cache) {
        for (RenderType layer : RenderType.m_110506_()) {
            this.additional.put(layer, (Object)(this.newAdditional ? BlockBufferCache.combine((BufferCache)this.additional.get(layer), cache.get(layer)) : cache.get(layer)));
        }
    }

    public boolean hasInvalidBuffers() {
        for (Map.Entry entry : this.uploaded.tuples()) {
            if (entry.getValue() == null || !((BufferCache)entry.getValue()).isInvalid() && ((BufferCache)entry.getValue()).isAvailable() || this.queue.containsKey((RenderType)entry.getKey())) continue;
            return true;
        }
        return false;
    }
}

