/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.block;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.math.box.LittleBox;

public class BlockTileRenderProperties
implements IClientBlockExtensions {
    private final Random random = new Random();
    public static final BlockTileRenderProperties INSTANCE = new BlockTileRenderProperties();

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
        LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, pos, (Player)Minecraft.m_91087_().f_91074_);
        if (context.isComplete()) {
            BlockState particleState = context.tile.getState();
            AABB bb = context.box.getBB(context.parent.getGrid());
            double d1 = Math.min(1.0, bb.f_82291_ - bb.f_82288_);
            double d2 = Math.min(1.0, bb.f_82292_ - bb.f_82289_);
            double d3 = Math.min(1.0, bb.f_82293_ - bb.f_82290_);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + bb.f_82288_;
                        double d8 = d5 * d2 + bb.f_82289_;
                        double d9 = d6 * d3 + bb.f_82290_;
                        manager.m_107344_(new TerrainParticle((ClientLevel)level, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, particleState, pos).updateSprite(particleState, pos));
                    }
                }
            }
        }
        return true;
    }

    public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
        BlockState blockstate;
        BlockPos pos = ((BlockHitResult)target).m_82425_();
        Direction direction = ((BlockHitResult)target).m_82434_();
        LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, pos, (Player)Minecraft.m_91087_().f_91074_);
        if (context.isComplete() && (blockstate = context.tile.getState()).m_60799_() != RenderShape.INVISIBLE) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            AABB aabb = context.box.getBB(context.parent.getGrid());
            double d0 = (double)i + this.random.nextDouble() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
            double d1 = (double)j + this.random.nextDouble() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
            double d2 = (double)k + this.random.nextDouble() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
            if (direction == Direction.DOWN) {
                d1 = (double)j + aabb.f_82289_ - (double)0.1f;
            }
            if (direction == Direction.UP) {
                d1 = (double)j + aabb.f_82292_ + (double)0.1f;
            }
            if (direction == Direction.NORTH) {
                d2 = (double)k + aabb.f_82290_ - (double)0.1f;
            }
            if (direction == Direction.SOUTH) {
                d2 = (double)k + aabb.f_82293_ + (double)0.1f;
            }
            if (direction == Direction.WEST) {
                d0 = (double)i + aabb.f_82288_ - (double)0.1f;
            }
            if (direction == Direction.EAST) {
                d0 = (double)i + aabb.f_82291_ + (double)0.1f;
            }
            manager.m_107344_(new TerrainParticle((ClientLevel)level, d0, d1, d2, 0.0, 0.0, 0.0, blockstate, pos).updateSprite(blockstate, pos).m_107268_(0.2f).m_6569_(0.6f));
        }
        return true;
    }

    public Vector3d getFogColor(BlockState state, LevelReader level, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                for (LittleBox box : (LittleTile)pair.getValue()) {
                    if (!box.getBB(((IParentCollection)pair.key).getGrid(), pos).m_82381_(entity.m_20191_())) continue;
                    return ((LittleTile)pair.value).getFogColor((IParentCollection)pair.key, entity, originalColor, partialTicks);
                }
            }
        }
        return originalColor;
    }
}

