/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.block;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.face.RenderBoxFace;
import team.creative.creativecore.client.render.face.RenderBoxFaceSpecial;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.mod.rubidium.RubidiumManager;
import team.creative.littletiles.client.mod.rubidium.pipeline.LittleRenderPipelineRubidium;
import team.creative.littletiles.client.render.cache.AdditionalBufferReceiver;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleFaceState;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.mixin.client.render.LevelRendererAccessor;
import team.creative.littletiles.mixin.client.render.ViewAreaAccessor;

@OnlyIn(value=Dist.CLIENT)
public class BERenderManager {
    private BETiles be;
    private volatile AtomicInteger blocked = new AtomicInteger(0);
    private volatile byte requestedIndex = (byte)-1;
    private int renderState = -1;
    private boolean queued = false;
    private boolean eraseBoxCache = false;
    public boolean hasLightChanged = false;
    private boolean neighbourChanged = false;
    private double cachedRenderDistance = 0.0;
    private AABB cachedRenderBoundingBox = null;
    private boolean requireRenderingBoundingBoxUpdate = false;
    private final BlockBufferCache bufferCache = new BlockBufferCache();
    public final ChunkLayerMap<IndexedCollector<LittleRenderBox>> boxCache = new ChunkLayerMap();

    public static RenderChunkExtender getRenderChunk(Level level, BlockPos pos) {
        if (level instanceof LittleLevel) {
            LittleLevel little = (LittleLevel)level;
            return little.getRenderManager().getRenderChunk(pos);
        }
        if (RubidiumManager.installed()) {
            return LittleRenderPipelineRubidium.getChunk(pos);
        }
        return (RenderChunkExtender)((ViewAreaAccessor)((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getViewArea()).getChunkAt(pos);
    }

    public BERenderManager(BETiles be) {
        this.be = be;
    }

    public void setBe(BETiles be) {
        this.be = be;
    }

    public boolean isInQueue() {
        return this.queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkUpdate(RenderChunkExtender chunk) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            boolean doesNeedUpdate;
            boolean bl = doesNeedUpdate = this.neighbourChanged || this.hasLightChanged || this.requestedIndex == -1 || this.bufferCache.hasInvalidBuffers();
            if (this.renderState != RenderingThread.CURRENT_RENDERING_INDEX) {
                this.eraseBoxCache = true;
                doesNeedUpdate = true;
            }
            this.hasLightChanged = false;
            this.neighbourChanged = false;
            if (doesNeedUpdate) {
                this.queue(this.eraseBoxCache, chunk);
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked.get() > 0;
    }

    public boolean getAndSetBlocked() {
        return this.blocked.getAndIncrement() > 0;
    }

    public void unsetBlocked() {
        this.blocked.decrementAndGet();
    }

    public void tilesChanged() {
        this.requireRenderingBoundingBoxUpdate = true;
        this.cachedRenderDistance = 0.0;
        this.queue(true, null);
    }

    public void markRenderBoundingBoxDirty() {
        this.requireRenderingBoundingBoxUpdate = true;
    }

    public double getMaxRenderDistance() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 64.0;
            for (LittleStructure structure : this.be.rendering()) {
                renderDistance = Math.max(renderDistance, structure.getMaxRenderDistance());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public AABB getRenderBoundingBox() {
        if (this.requireRenderingBoundingBoxUpdate || this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            boolean found = false;
            for (LittleStructure structure : this.be.rendering()) {
                AABB box = structure.getRenderBoundingBox();
                if (box == null) continue;
                box = box.m_82338_(this.be.m_58899_());
                minX = Math.min(box.f_82288_, minX);
                minY = Math.min(box.f_82289_, minY);
                minZ = Math.min(box.f_82290_, minZ);
                maxX = Math.max(box.f_82291_, maxX);
                maxY = Math.max(box.f_82292_, maxY);
                maxZ = Math.max(box.f_82293_, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AABB(minX, minY, minZ, maxX, maxY, maxZ) : new AABB(this.be.m_58899_());
            this.requireRenderingBoundingBoxUpdate = false;
        }
        return this.cachedRenderBoundingBox;
    }

    public void onNeighbourChanged() {
        this.neighbourChanged = true;
        this.queue(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(boolean eraseBoxCache, @Nullable RenderChunkExtender chunk) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            this.requestedIndex = (byte)(this.requestedIndex + 1);
            this.eraseBoxCache |= eraseBoxCache;
            if (!this.queued && RenderingThread.queue(this.be, chunk)) {
                this.queued = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startBuildingCache() {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            if (this.eraseBoxCache) {
                this.boxCache.clear();
                this.eraseBoxCache = false;
            }
            this.blocked.incrementAndGet();
            return this.requestedIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishBuildingCache(int index, ChunkLayerMap<BufferCache> buffers, int renderState, boolean force) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            boolean done;
            this.renderState = renderState;
            boolean bl = done = force || index == this.requestedIndex && this.renderState == renderState;
            if (done) {
                this.queued = false;
            }
            this.hasLightChanged = false;
            this.bufferCache.setBuffers(buffers);
            return done;
        }
    }

    public void resetRenderingState() {
        this.queued = false;
        this.requestedIndex = (byte)-1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkUnload() {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            this.bufferCache.setEmpty();
            this.boxCache.clear();
            this.cachedRenderBoundingBox = null;
        }
    }

    public IBlockBufferCache buffers() {
        return this.bufferCache;
    }

    public void additionalBuffersEarly(Consumer<AdditionalBufferReceiver> consumer) {
        this.bufferCache.executeAdditional(consumer);
    }

    public void additionalBuffers(Consumer<AdditionalBufferReceiver> consumer) {
        if (this.isInQueue()) {
            this.bufferCache.executeAdditional(consumer);
            if (!this.isInQueue()) {
                this.bufferCache.clearAdditional();
            }
        }
    }

    public void setBuffersEmpty() {
        this.bufferCache.setEmpty();
    }

    public boolean hasAdditionalBuffers() {
        return this.bufferCache.hasAdditional();
    }

    public void beforeBuilding(RenderingBlockContext context) {
        if (this.neighbourChanged) {
            this.neighbourChanged = false;
            for (Map.Entry entry : this.boxCache.tuples()) {
                if (entry.getValue() == null) continue;
                for (LittleRenderBox cube : (IndexedCollector)entry.getValue()) {
                    for (int k = 0; k < Facing.VALUES.length; ++k) {
                        LittleFaceState state;
                        Facing facing = Facing.VALUES[k];
                        if (cube.box == null || !(state = cube.box.getFaceState(facing)).outside()) continue;
                        this.calculateFaces(facing, state, context, (LittleTile)cube.customData, cube.box, cube);
                    }
                }
            }
        }
    }

    private void calculateFaces(Facing facing, LittleFaceState state, RenderingBlockContext context, @Nullable LittleTile tile, LittleBox box, LittleRenderBox cube) {
        if (state.coveredFully()) {
            cube.setFace(facing, RenderBoxFace.NOT_RENDER);
            return;
        }
        if (tile != null && tile.isTranslucent() && state.partially()) {
            LittleFace face = cube.box.generateFace(this.be.getGrid(), facing);
            BETiles toCheck = this.be;
            if (state.outside()) {
                toCheck = context.getNeighbour(facing);
                face.move(facing);
            }
            if (toCheck.shouldFaceBeRendered(face, tile)) {
                cube.setFace(facing, (RenderBoxFace)new RenderBoxFaceSpecial(face.generateFans(), (float)face.grid.pixelLength));
            } else {
                cube.setFace(facing, RenderBoxFace.NOT_RENDER);
            }
            cube.customData = tile;
        } else {
            cube.setFace(facing, RenderBoxFace.RENDER);
        }
    }

    public IndexedCollector<LittleRenderBox> getRenderingBoxes(RenderingBlockContext context, RenderType layer) {
        IndexedCollector cachedCubes = (IndexedCollector)this.boxCache.get(layer);
        if (cachedCubes != null) {
            return cachedCubes;
        }
        IndexedCollector boxes = new IndexedCollector();
        LittleServerFace serverFace = new LittleServerFace(this.be);
        for (IParentCollection parent : this.be.groups()) {
            if (parent instanceof IStructureParentCollection) {
                IStructureParentCollection s = (IStructureParentCollection)parent;
                boxes.startSection(s.getIndex());
            } else {
                boxes.startSection(-1);
            }
            for (LittleTile tile : parent) {
                if (!tile.canRenderInLayer(layer)) continue;
                for (LittleBox box : tile) {
                    box.hasOrCreateFaceState(parent, tile, serverFace);
                    LittleRenderBox cube = parent.getRenderingBox(tile, box, layer);
                    if (cube == null) continue;
                    for (int k = 0; k < Facing.VALUES.length; ++k) {
                        this.calculateFaces(Facing.VALUES[k], cube.box.getFaceState(Facing.VALUES[k]), context, tile, box, cube);
                    }
                    boxes.add((Object)cube);
                }
            }
            if (LittleStructureAttribute.extraRendering(parent.getAttribute())) {
                try {
                    LittleStructure structure = parent.getStructure();
                    structure.checkConnections();
                    structure.getRenderingBoxes(this.be.m_58899_(), layer, (IndexedCollector<LittleRenderBox>)boxes);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            boxes.endSection();
        }
        if (boxes.isEmpty()) {
            boxes = null;
        }
        this.boxCache.put(layer, (Object)boxes);
        return boxes;
    }

    public RenderChunkExtender getRenderChunk() {
        return BERenderManager.getRenderChunk(this.be.m_58904_(), this.be.m_58899_());
    }
}

