/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.player;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAddPlayerPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPingPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.client.level.little.LittleClientLevel;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.mixin.client.network.ClientPacketListenerAccessor;

public class LittleClientPlayerHandler
implements TickablePacketListener,
ClientGamePacketListener {
    private static final Logger LOGGER = LittleTiles.LOGGER;
    private static final Minecraft mc = Minecraft.m_91087_();
    public Level level;

    public LittleClientLevel requiresClientLevel() {
        Level level = this.level;
        if (level instanceof LittleClientLevel) {
            LittleClientLevel s = (LittleClientLevel)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + this.level);
    }

    public ClientLevelExtender requiresClientLevelExtender() {
        Level level = this.level;
        if (level instanceof ClientLevelExtender) {
            ClientLevelExtender s = (ClientLevelExtender)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + this.level);
    }

    public void ensureRunningOnSameThread(Packet packet) throws RunningOnDifferentThreadException {
        if (!mc.m_18695_()) {
            mc.m_201446_(() -> LittleTilesClient.PLAYER_CONNECTION.runInContext((LittleLevel)this.level, x -> packet.m_5797_((PacketListener)x)));
            throw RunningOnDifferentThreadException.f_136017_;
        }
    }

    public ClientPacketListener vanilla() {
        return Minecraft.m_91087_().m_91403_();
    }

    public ClientPacketListenerAccessor vanillaAccessor() {
        return (ClientPacketListenerAccessor)Minecraft.m_91087_().m_91403_();
    }

    public void m_5998_(ClientboundLoginPacket packet) {
        this.vanilla().m_5998_(packet);
    }

    public void m_6008_(ClientboundDisconnectPacket packet) {
        this.vanilla().m_6008_(packet);
    }

    public void m_7026_(Component component) {
        this.vanilla().m_7026_(component);
    }

    public void m_7992_(ClientboundRespawnPacket packet) {
        this.vanilla().m_7992_(packet);
    }

    public void m_5587_(ClientboundResourcePackPacket packet) {
        this.vanilla().m_5587_(packet);
    }

    public void m_214045_(ClientboundPlayerInfoUpdatePacket packet) {
        this.vanilla().m_214045_(packet);
    }

    public void m_213565_(ClientboundPlayerInfoRemovePacket packet) {
        this.vanilla().m_213565_(packet);
    }

    public void m_5943_(ClientboundBlockDestructionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.m_6801_(packet.m_131685_(), packet.m_131688_(), packet.m_131689_());
    }

    public void m_7345_(ClientboundExplodePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Explosion explosion = new Explosion(this.level, (Entity)null, packet.m_132132_(), packet.m_132133_(), packet.m_132134_(), packet.m_132135_(), packet.m_132136_());
        explosion.m_46075_(true);
        LittleClientPlayerHandler.mc.f_91074_.m_20256_(LittleClientPlayerHandler.mc.f_91074_.m_20184_().m_82520_((double)packet.m_132127_(), (double)packet.m_132130_(), (double)packet.m_132131_()));
    }

    public void m_7545_(ClientboundBlockEntityDataPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.m_131704_();
        this.level.m_141902_(blockpos, packet.m_195645_()).ifPresent(x -> {
            Screen patt7398$temp;
            x.onDataPacket(this.vanilla().m_104910_(), packet);
            if (x instanceof CommandBlockEntity && (patt7398$temp = LittleClientPlayerHandler.mc.f_91080_) instanceof CommandBlockEditScreen) {
                CommandBlockEditScreen screen = (CommandBlockEditScreen)patt7398$temp;
                screen.m_98398_();
            }
        });
    }

    public void m_7364_(ClientboundBlockEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.m_7696_(packet.m_131725_(), packet.m_131730_(), packet.m_131728_(), packet.m_131729_());
    }

    public void m_7704_(ClientboundLevelEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (packet.m_132274_()) {
            this.level.m_6798_(packet.m_132277_(), packet.m_132279_(), packet.m_132278_());
        } else {
            this.level.m_46796_(packet.m_132277_(), packet.m_132279_(), packet.m_132278_());
        }
    }

    public void m_8068_(ClientboundSoundPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.m_262808_((Player)LittleClientPlayerHandler.mc.f_91074_, packet.m_133459_(), packet.m_133460_(), packet.m_133461_(), packet.m_263229_(), packet.m_133458_(), packet.m_133462_(), packet.m_133463_(), packet.m_237848_());
    }

    public void m_5863_(ClientboundSoundEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133430_());
        if (entity != null) {
            this.level.m_213890_((Player)LittleClientPlayerHandler.mc.f_91074_, entity, packet.m_263456_(), packet.m_133429_(), packet.m_133431_(), packet.m_133432_(), packet.m_237837_());
        }
    }

    public void send(Packet<?> packet) {
        LittleTiles.NETWORK.sendToServer((CreativePacket)new LittleVanillaPacket((LittleLevel)this.level, packet));
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener listener) {
        this.send(packet);
        if (listener != null) {
            listener.m_243096_();
        }
    }

    public void m_6771_(ClientboundAddEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = LittleTilesClient.ANIMATION_HANDLER.pollEntityInTransition(packet);
        if (entity == null) {
            entity = packet.m_131508_().m_20615_(this.level);
        }
        if (entity != null) {
            entity.m_141965_(packet);
            int i = packet.m_131496_();
            Level level = this.level;
            if (level instanceof LittleAnimationLevel) {
                LittleAnimationLevel a = (LittleAnimationLevel)level;
                a.addFreshEntityFromPacket(entity);
            } else {
                this.requiresClientLevel().m_104627_(i, entity);
            }
            this.vanillaAccessor().callPostAddEntitySoundInstance(entity);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)packet.m_131508_());
        }
    }

    public void m_7708_(ClientboundAddExperienceOrbPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        ExperienceOrb entity = new ExperienceOrb(this.level, packet.m_131527_(), packet.m_131528_(), packet.m_131529_(), packet.m_131530_());
        entity.m_217006_(packet.m_131527_(), packet.m_131528_(), packet.m_131529_());
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_20234_(packet.m_131524_());
        level.m_104627_(packet.m_131524_(), (Entity)entity);
    }

    public void m_8048_(ClientboundSetEntityMotionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133192_());
        if (entity != null) {
            entity.m_6001_((double)packet.m_133195_() / 8000.0, (double)packet.m_133196_() / 8000.0, (double)packet.m_133197_() / 8000.0);
        }
    }

    public void m_6455_(ClientboundSetEntityDataPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.f_133143_());
        if (entity != null) {
            entity.m_20088_().m_135356_(packet.f_133144_());
        }
    }

    public void m_6482_(ClientboundAddPlayerPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        PlayerInfo playerinfo = this.vanilla().m_104949_(packet.m_131606_());
        if (playerinfo == null) {
            LOGGER.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)packet.m_131606_());
            return;
        }
        double d0 = packet.m_131607_();
        double d1 = packet.m_131608_();
        double d2 = packet.m_131609_();
        float f = (float)(packet.m_131610_() * 360) / 256.0f;
        float f1 = (float)(packet.m_131611_() * 360) / 256.0f;
        int i = packet.m_131603_();
        RemotePlayer remoteplayer = new RemotePlayer(LittleClientPlayerHandler.mc.f_91073_, playerinfo.m_105312_());
        remoteplayer.m_20234_(i);
        remoteplayer.m_217006_(d0, d1, d2);
        remoteplayer.m_19890_(d0, d1, d2, f, f1);
        remoteplayer.m_146867_();
        level.m_104630_(i, (AbstractClientPlayer)remoteplayer);
    }

    public void m_6435_(ClientboundTeleportEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133545_());
        if (entity != null) {
            double d0 = packet.m_133548_();
            double d1 = packet.m_133549_();
            double d2 = packet.m_133550_();
            entity.m_217006_(d0, d1, d2);
            if (!entity.m_6109_()) {
                float f = (float)(packet.m_133551_() * 360) / 256.0f;
                float f1 = (float)(packet.m_133552_() * 360) / 256.0f;
                entity.m_6453_(d0, d1, d2, f, f1, 3, true);
                entity.m_6853_(packet.m_133553_());
            }
        }
    }

    public void m_5612_(ClientboundSetCarriedItemPacket packet) {
        this.vanilla().m_5612_(packet);
    }

    public void m_7865_(ClientboundMoveEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.m_132519_(this.level);
        if (entity != null && !entity.m_6109_()) {
            if (packet.m_132534_()) {
                VecDeltaCodec vecdeltacodec = entity.m_217001_();
                Vec3 vec3 = vecdeltacodec.m_238021_((long)packet.m_178997_(), (long)packet.m_178998_(), (long)packet.m_178999_());
                vecdeltacodec.m_238033_(vec3);
                float f = packet.m_132533_() ? (float)(packet.m_132531_() * 360) / 256.0f : entity.m_146908_();
                float f1 = packet.m_132533_() ? (float)(packet.m_132532_() * 360) / 256.0f : entity.m_146909_();
                entity.m_6453_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), f, f1, 3, false);
            } else if (packet.m_132533_()) {
                float f2 = (float)(packet.m_132531_() * 360) / 256.0f;
                float f3 = (float)(packet.m_132532_() * 360) / 256.0f;
                entity.m_6453_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), f2, f3, 3, false);
            }
            entity.m_6853_(packet.m_132535_());
        }
    }

    public void m_6176_(ClientboundRotateHeadPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.m_132969_(this.level);
        if (entity != null) {
            float f = (float)(packet.m_132977_() * 360) / 256.0f;
            entity.m_6541_(f, 3);
        }
    }

    public void m_182047_(ClientboundRemoveEntitiesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        packet.m_182730_().forEach(id -> ((LittleLevel)this.level).removeEntityById(id, Entity.RemovalReason.DISCARDED));
    }

    public void m_5682_(ClientboundPlayerPositionPacket packet) {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        this.ensureRunningOnSameThread((Packet)packet);
        LocalPlayer player = LittleClientPlayerHandler.mc.f_91074_;
        Vec3 vec3 = player.m_20184_();
        boolean flag = packet.m_132826_().contains(RelativeMovement.X);
        boolean flag1 = packet.m_132826_().contains(RelativeMovement.Y);
        boolean flag2 = packet.m_132826_().contains(RelativeMovement.Z);
        if (flag) {
            d0 = vec3.m_7096_();
            d1 = player.m_20185_() + packet.m_132818_();
            player.f_19790_ += packet.m_132818_();
            player.f_19854_ += packet.m_132818_();
        } else {
            d0 = 0.0;
            player.f_19790_ = d1 = packet.m_132818_();
            player.f_19854_ = d1;
        }
        if (flag1) {
            d2 = vec3.m_7098_();
            d3 = player.m_20186_() + packet.m_132821_();
            player.f_19791_ += packet.m_132821_();
            player.f_19855_ += packet.m_132821_();
        } else {
            d2 = 0.0;
            player.f_19791_ = d3 = packet.m_132821_();
            player.f_19855_ = d3;
        }
        if (flag2) {
            d4 = vec3.m_7094_();
            d5 = player.m_20189_() + packet.m_132822_();
            player.f_19792_ += packet.m_132822_();
            player.f_19856_ += packet.m_132822_();
        } else {
            d4 = 0.0;
            player.f_19792_ = d5 = packet.m_132822_();
            player.f_19856_ = d5;
        }
        player.m_6034_(d1, d3, d5);
        player.m_20334_(d0, d2, d4);
        float f = packet.m_132823_();
        float f1 = packet.m_132824_();
        if (packet.m_132826_().contains(RelativeMovement.X_ROT)) {
            player.m_146926_(player.m_146909_() + f1);
            player.f_19860_ += f1;
        } else {
            player.m_146926_(f1);
            player.f_19860_ = f1;
        }
        if (packet.m_132826_().contains(RelativeMovement.Y_ROT)) {
            player.m_146922_(player.m_146908_() + f);
            player.f_19859_ += f;
        } else {
            player.m_146922_(f);
            player.f_19859_ = f;
        }
        this.send((Packet<?>)new ServerboundAcceptTeleportationPacket(packet.m_132825_()));
        this.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_(), false));
    }

    public void m_5771_(ClientboundSectionBlocksUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        packet.m_132992_((p_205524_, p_205525_) -> level.m_233653_((BlockPos)p_205524_, (BlockState)p_205525_, 19));
    }

    public void m_183388_(ClientboundLevelChunkWithLightPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        this.updateLevelChunk(level, packet.m_195717_(), packet.m_195718_(), packet.m_195719_());
        this.queueLightUpdate(level, packet.m_195717_(), packet.m_195718_(), packet.m_195720_());
    }

    public void m_274374_(ClientboundChunksBiomesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata : packet.f_273816_()) {
            level.getChunkSource().m_274444_(clientboundchunksbiomespacket$chunkbiomedata.f_273927_().f_45578_, clientboundchunksbiomespacket$chunkbiomedata.f_273927_().f_45579_, clientboundchunksbiomespacket$chunkbiomedata.m_274543_());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata1 : packet.f_273816_()) {
            level.m_171649_(new ChunkPos(clientboundchunksbiomespacket$chunkbiomedata1.f_273927_().f_45578_, clientboundchunksbiomespacket$chunkbiomedata1.f_273927_().f_45579_));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata2 : packet.f_273816_()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = this.level.m_151560_(); k < this.level.m_151561_(); ++k) {
                        level.setSectionDirty(clientboundchunksbiomespacket$chunkbiomedata2.f_273927_().f_45578_ + i, k, clientboundchunksbiomespacket$chunkbiomedata2.f_273927_().f_45579_ + j);
                    }
                }
            }
        }
    }

    private void updateLevelChunk(ClientLevel level, int x, int z, ClientboundLevelChunkPacketData data) {
        level.m_7726_().m_194116_(x, z, data.m_195656_(), data.m_195678_(), data.m_195657_(x, z));
    }

    private void queueLightUpdate(ClientLevel level, int x, int z, ClientboundLightUpdatePacketData data) {
        level.m_194171_(() -> {
            this.applyLightData(level, x, z, data);
            LevelChunk levelchunk = this.level.m_7726_().m_62227_(x, z, false);
            if (levelchunk != null) {
                this.enableChunkLight(level, levelchunk, x, z);
            }
        });
    }

    private void applyLightData(ClientLevel level, int x, int z, ClientboundLightUpdatePacketData data) {
        LevelLightEngine levellightengine = this.level.m_7726_().m_7827_();
        BitSet bitset = data.m_195740_();
        BitSet bitset1 = data.m_195751_();
        Iterator<byte[]> iterator = data.m_195754_().iterator();
        this.readSectionList(level, x, z, levellightengine, LightLayer.SKY, bitset, bitset1, iterator);
        BitSet bitset2 = data.m_195757_();
        BitSet bitset3 = data.m_195758_();
        Iterator<byte[]> iterator1 = data.m_195759_().iterator();
        this.readSectionList(level, x, z, levellightengine, LightLayer.BLOCK, bitset2, bitset3, iterator1);
        levellightengine.m_9335_(new ChunkPos(x, z), true);
    }

    private void readSectionList(ClientLevel level, int x, int z, LevelLightEngine light, LightLayer layer, BitSet minSet, BitSet maxSet, Iterator<byte[]> data) {
        for (int i = 0; i < light.m_164446_(); ++i) {
            int j = light.m_164447_() + i;
            boolean flag = minSet.get(i);
            boolean flag1 = maxSet.get(i);
            if (!flag && !flag1) continue;
            light.m_284126_(layer, SectionPos.m_123173_((int)x, (int)j, (int)z), flag ? new DataLayer((byte[])data.next().clone()) : new DataLayer());
            level.m_104793_(x, j, z);
        }
    }

    private void enableChunkLight(ClientLevel level, LevelChunk chunk, int x, int z) {
        LevelLightEngine levellightengine = this.level.m_7726_().m_7827_();
        LevelChunkSection[] alevelchunksection = chunk.m_7103_();
        ChunkPos chunkpos = chunk.m_7697_();
        for (int i = 0; i < alevelchunksection.length; ++i) {
            LevelChunkSection levelchunksection = alevelchunksection[i];
            int j = this.level.m_151568_(i);
            levellightengine.m_6191_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)j), levelchunksection.m_188008_());
            level.m_104793_(x, j, z);
        }
    }

    public void m_5729_(ClientboundForgetLevelChunkPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        int i = packet.m_132149_();
        int j = packet.m_132152_();
        ChunkSource chunkSource = this.level.m_7726_();
        if (chunkSource instanceof ClientChunkCache) {
            ClientChunkCache client = (ClientChunkCache)chunkSource;
            client.m_104455_(i, j);
        }
        this.queueLightRemoval(level, packet);
    }

    private void queueLightRemoval(ClientLevel level, ClientboundForgetLevelChunkPacket packet) {
        ChunkPos chunkpos = new ChunkPos(packet.m_132149_(), packet.m_132152_());
        level.m_194171_(() -> {
            LevelLightEngine levellightengine = this.level.m_5518_();
            levellightengine.m_9335_(chunkpos, false);
            for (int i = levellightengine.m_164447_(); i < levellightengine.m_164448_(); ++i) {
                SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)i);
                levellightengine.m_284126_(LightLayer.BLOCK, sectionpos, (DataLayer)null);
                levellightengine.m_284126_(LightLayer.SKY, sectionpos, (DataLayer)null);
            }
            for (int j = this.level.m_151560_(); j < this.level.m_151561_(); ++j) {
                levellightengine.m_6191_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)j), true);
            }
        });
    }

    public void m_6773_(ClientboundBlockUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ClientLevelExtender level = this.requiresClientLevelExtender();
        level.setServerVerifiedBlockStateExtender(packet.m_131749_(), packet.m_131746_(), 19);
    }

    public void m_8001_(ClientboundTakeItemEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        Entity entity = level.m_6815_(packet.m_133524_());
        LivingEntity livingentity = (LivingEntity)this.level.m_6815_(packet.m_133527_());
        if (livingentity == null) {
            livingentity = LittleClientPlayerHandler.mc.f_91074_;
        }
        if (entity != null) {
            RandomSource random = this.vanillaAccessor().getRandom();
            if (entity instanceof ExperienceOrb) {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (random.m_188501_() - random.m_188501_()) * 0.35f + 0.9f, false);
            } else {
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (random.m_188501_() - random.m_188501_()) * 1.4f + 2.0f, false);
            }
            LittleClientPlayerHandler.mc.f_91061_.m_107344_((Particle)new ItemPickupParticle(mc.m_91290_(), mc.m_91269_(), LittleClientPlayerHandler.mc.f_91073_, entity, (Entity)livingentity));
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack itemstack = itemEntity.m_32055_();
                itemstack.m_41774_(packet.m_133528_());
                if (itemstack.m_41619_()) {
                    level.m_171642_(packet.m_133524_(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!(entity instanceof ExperienceOrb)) {
                level.m_171642_(packet.m_133524_(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_213990_(ClientboundSystemChatPacket packet) {
        this.vanilla().m_213990_(packet);
    }

    public void m_213629_(ClientboundPlayerChatPacket packet) {
        this.vanilla().m_213629_(packet);
    }

    public void m_7039_(ClientboundDisguisedChatPacket packet) {
        this.vanilla().m_7039_(packet);
    }

    public void m_241037_(ClientboundDeleteChatPacket packet) {
        this.m_241037_(packet);
    }

    public void m_7791_(ClientboundAnimatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_131624_());
        if (entity != null) {
            if (packet.m_131627_() == 0) {
                ((LivingEntity)entity).m_6674_(InteractionHand.MAIN_HAND);
            } else if (packet.m_131627_() == 3) {
                ((LivingEntity)entity).m_6674_(InteractionHand.OFF_HAND);
            } else if (packet.m_131627_() == 2) {
                ((Player)entity).m_6145_(false, false);
            } else if (packet.m_131627_() == 4) {
                LittleClientPlayerHandler.mc.f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123797_);
            } else if (packet.m_131627_() == 5) {
                LittleClientPlayerHandler.mc.f_91061_.m_107329_(entity, (ParticleOptions)ParticleTypes.f_123808_);
            }
        }
    }

    public void m_264143_(ClientboundHurtAnimationPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.f_263825_());
        if (entity != null) {
            entity.m_6053_(packet.f_263826_());
        }
    }

    public void m_7885_(ClientboundSetTimePacket packet) {
        this.vanilla().m_7885_(packet);
    }

    public void m_6571_(ClientboundSetDefaultSpawnPositionPacket packet) {
        this.vanilla().m_6571_(packet);
    }

    public void m_6403_(ClientboundSetPassengersPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133286_());
        if (entity == null) {
            LOGGER.warn("Received passengers for unknown entity");
            return;
        }
        LocalPlayer player = LittleClientPlayerHandler.mc.f_91074_;
        boolean flag = entity.m_20367_((Entity)player);
        entity.m_20153_();
        for (int i : packet.m_133283_()) {
            Entity entity1 = this.level.m_6815_(i);
            if (entity1 == null) continue;
            entity1.m_7998_(entity, true);
            if (entity1 != player || flag) continue;
            if (entity instanceof Boat) {
                player.f_19859_ = entity.m_146908_();
                player.m_146922_(entity.m_146908_());
                player.m_5616_(entity.m_146908_());
            }
            MutableComponent component = Component.m_237110_((String)"mount.onboard", (Object[])new Object[]{LittleClientPlayerHandler.mc.f_91066_.f_92090_.m_90863_()});
            LittleClientPlayerHandler.mc.f_91065_.m_93063_((Component)component, false);
            mc.m_240477_().m_168785_((Component)component);
        }
    }

    public void m_5599_(ClientboundSetEntityLinkPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133172_());
        if (entity instanceof Mob) {
            ((Mob)entity).m_21506_(packet.m_133175_());
        }
    }

    private static ItemStack findTotem(Player p_104928_) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack = p_104928_.m_21120_(interactionhand);
            if (!itemstack.m_150930_(Items.f_42747_)) continue;
            return itemstack;
        }
        return new ItemStack((ItemLike)Items.f_42747_);
    }

    public void m_7628_(ClientboundEntityEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.m_132094_(this.level);
        if (entity != null) {
            if (packet.m_132102_() == 21) {
                mc.m_91106_().m_120367_((SoundInstance)new GuardianAttackSoundInstance((Guardian)entity));
            } else if (packet.m_132102_() == 35) {
                LittleClientPlayerHandler.mc.f_91061_.m_107332_(entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
                this.level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
                if (entity == LittleClientPlayerHandler.mc.f_91074_) {
                    LittleClientPlayerHandler.mc.f_91063_.m_109113_(LittleClientPlayerHandler.findTotem((Player)LittleClientPlayerHandler.mc.f_91074_));
                }
            } else {
                entity.m_7822_(packet.m_132102_());
            }
        }
    }

    public void m_269082_(ClientboundDamageEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.f_268504_());
        if (entity != null) {
            entity.m_269138_(packet.m_269591_(this.level));
        }
    }

    public void m_5547_(ClientboundSetHealthPacket packet) {
        this.vanilla().m_5547_(packet);
    }

    public void m_6747_(ClientboundSetExperiencePacket packet) {
        this.vanilla().m_6747_(packet);
    }

    public void m_6905_(ClientboundHorseScreenOpenPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_132208_());
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            LocalPlayer localplayer = LittleClientPlayerHandler.mc.f_91074_;
            SimpleContainer simplecontainer = new SimpleContainer(packet.m_132207_());
            HorseInventoryMenu horseinventorymenu = new HorseInventoryMenu(packet.m_132204_(), localplayer.m_150109_(), (Container)simplecontainer, horse);
            localplayer.f_36096_ = horseinventorymenu;
            mc.m_91152_((Screen)new HorseInventoryScreen(horseinventorymenu, localplayer.m_150109_(), horse));
        }
    }

    public void m_5980_(ClientboundOpenScreenPacket packet) {
        this.vanilla().m_5980_(packet);
    }

    public void m_5735_(ClientboundContainerSetSlotPacket packet) {
        this.vanilla().m_5735_(packet);
    }

    public void m_6837_(ClientboundContainerSetContentPacket packet) {
        this.vanilla().m_6837_(packet);
    }

    public void m_8047_(ClientboundOpenSignEditorPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.m_132640_();
        BlockEntity blockentity = this.level.m_7702_(blockpos);
        if (!(blockentity instanceof SignBlockEntity)) {
            BlockState blockstate = this.level.m_8055_(blockpos);
            blockentity = new SignBlockEntity(blockpos, blockstate);
            blockentity.m_142339_(this.level);
        }
        LittleClientPlayerHandler.mc.f_91074_.m_7739_((SignBlockEntity)blockentity, packet.m_276774_());
    }

    public void m_7257_(ClientboundContainerSetDataPacket packet) {
        this.vanilla().m_7257_(packet);
    }

    public void m_7277_(ClientboundSetEquipmentPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133210_());
        if (entity != null) {
            packet.m_133213_().forEach(slot -> entity.m_8061_((EquipmentSlot)slot.getFirst(), (ItemStack)slot.getSecond()));
        }
    }

    public void m_7776_(ClientboundContainerClosePacket packet) {
        this.vanilla().m_7776_(packet);
    }

    public void m_7616_(ClientboundGameEventPacket packet) {
        this.vanilla().m_7616_(packet);
    }

    public void m_7633_(ClientboundMapItemDataPacket packet) {
        this.vanilla().m_7633_(packet);
    }

    public void m_5498_(ClientboundUpdateAdvancementsPacket packet) {
        this.vanilla().m_5498_(packet);
    }

    public void m_7553_(ClientboundSelectAdvancementsTabPacket packet) {
        this.vanilla().m_7553_(packet);
    }

    public void m_7443_(ClientboundCommandsPacket packet) {
        this.vanilla().m_7443_(packet);
    }

    public void m_7183_(ClientboundStopSoundPacket packet) {
        this.vanilla().m_7183_(packet);
    }

    public void m_7589_(ClientboundCommandSuggestionsPacket packet) {
        this.vanilla().m_7589_(packet);
    }

    public void m_6327_(ClientboundUpdateRecipesPacket packet) {
        this.vanilla().m_6327_(packet);
    }

    public void m_7244_(ClientboundPlayerLookAtPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Vec3 vec3 = packet.m_132785_(this.level);
        if (vec3 != null) {
            LittleClientPlayerHandler.mc.f_91074_.m_7618_(packet.m_132793_(), vec3);
        }
    }

    public void m_6148_(ClientboundTagQueryPacket packet) {
        this.vanilla().m_6148_(packet);
    }

    public void m_7271_(ClientboundAwardStatsPacket packet) {
        this.vanilla().m_7271_(packet);
    }

    public void m_8076_(ClientboundRecipePacket packet) {
        this.vanilla().m_8076_(packet);
    }

    public void m_7915_(ClientboundUpdateMobEffectPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133622_());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            MobEffect mobeffect = packet.m_237878_();
            if (mobeffect != null) {
                living.m_147215_(new MobEffectInstance(mobeffect, packet.m_133625_(), (int)packet.m_133624_(), packet.m_133627_(), packet.m_133626_(), packet.m_133628_(), (MobEffectInstance)null, Optional.ofNullable(packet.m_237879_())), (Entity)null);
            }
        }
    }

    public void m_5859_(ClientboundUpdateTagsPacket packet) {
        this.vanilla().m_5859_(packet);
    }

    public void m_241155_(ClientboundUpdateEnabledFeaturesPacket packet) {
        this.vanilla().m_241155_(packet);
    }

    public void m_142234_(ClientboundPlayerCombatEndPacket packet) {
    }

    public void m_142058_(ClientboundPlayerCombatEnterPacket packet) {
    }

    public void m_142747_(ClientboundPlayerCombatKillPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_179078_());
        if (entity == LittleClientPlayerHandler.mc.f_91074_) {
            if (LittleClientPlayerHandler.mc.f_91074_.m_108632_()) {
                mc.m_91152_((Screen)new DeathScreen(packet.m_179079_(), this.level.m_6106_().m_5466_()));
            } else {
                LittleClientPlayerHandler.mc.f_91074_.m_7583_();
            }
        }
    }

    public void m_6664_(ClientboundChangeDifficultyPacket packet) {
        this.vanilla().m_6664_(packet);
    }

    public void m_6447_(ClientboundSetCameraPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.m_133059_(this.level);
        if (entity != null) {
            mc.m_91118_(entity);
        }
    }

    public void m_142237_(ClientboundInitializeBorderPacket packet) {
        this.vanilla().m_142237_(packet);
    }

    public void m_142612_(ClientboundSetBorderCenterPacket packet) {
        this.vanilla().m_142612_(packet);
    }

    public void m_142686_(ClientboundSetBorderLerpSizePacket packet) {
        this.vanilla().m_142686_(packet);
    }

    public void m_142238_(ClientboundSetBorderSizePacket packet) {
        this.vanilla().m_142238_(packet);
    }

    public void m_142696_(ClientboundSetBorderWarningDistancePacket packet) {
        this.vanilla().m_142696_(packet);
    }

    public void m_142056_(ClientboundSetBorderWarningDelayPacket packet) {
        this.vanilla().m_142056_(packet);
    }

    public void m_142766_(ClientboundClearTitlesPacket packet) {
        this.vanilla().m_142766_(packet);
    }

    public void m_213672_(ClientboundServerDataPacket packet) {
        this.vanilla().m_213672_(packet);
    }

    public void m_240695_(ClientboundCustomChatCompletionsPacket packet) {
        this.vanilla().m_240695_(packet);
    }

    public void m_142456_(ClientboundSetActionBarTextPacket packet) {
        this.vanilla().m_142456_(packet);
    }

    public void m_142442_(ClientboundSetTitleTextPacket packet) {
        this.vanilla().m_142442_(packet);
    }

    public void m_141913_(ClientboundSetSubtitleTextPacket packet) {
        this.vanilla().m_141913_(packet);
    }

    public void m_142185_(ClientboundSetTitlesAnimationPacket packet) {
        this.vanilla().m_142185_(packet);
    }

    public void m_6235_(ClientboundTabListPacket packet) {
        this.vanilla().m_6235_(packet);
    }

    public void m_6476_(ClientboundRemoveMobEffectPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.m_132901_(this.level);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_6234_(packet.m_132909_());
        }
    }

    public void m_7231_(ClientboundKeepAlivePacket packet) {
        this.vanilla().m_7231_(packet);
    }

    public void m_5767_(ClientboundPlayerAbilitiesPacket packet) {
        this.vanilla().m_5767_(packet);
    }

    public void m_7685_(ClientboundBossEventPacket packet) {
        this.vanilla().m_7685_(packet);
    }

    public void m_7701_(ClientboundCooldownPacket packet) {
        this.vanilla().m_7701_(packet);
    }

    public void m_7410_(ClientboundMoveVehiclePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = LittleClientPlayerHandler.mc.f_91074_.m_20201_();
        if (entity != LittleClientPlayerHandler.mc.f_91074_ && entity.m_6109_()) {
            entity.m_19890_(packet.m_132591_(), packet.m_132594_(), packet.m_132595_(), packet.m_132596_(), packet.m_132597_());
            this.send((Packet<?>)new ServerboundMoveVehiclePacket(entity));
        }
    }

    public void m_6503_(ClientboundOpenBookPacket packet) {
        this.vanilla().m_6503_(packet);
    }

    public void m_7413_(ClientboundCustomPayloadPacket packet) {
        this.vanilla().m_7413_(packet);
    }

    public void m_7957_(ClientboundSetObjectivePacket packet) {
        this.vanilla().m_7957_(packet);
    }

    public void m_7519_(ClientboundSetScorePacket packet) {
        this.vanilla().m_7519_(packet);
    }

    public void m_5556_(ClientboundSetDisplayObjectivePacket packet) {
        this.vanilla().m_5556_(packet);
    }

    public void m_5582_(ClientboundSetPlayerTeamPacket packet) {
        this.vanilla().m_5582_(packet);
    }

    public void m_7406_(ClientboundLevelParticlesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (packet.m_132321_() == 0) {
            double d0 = packet.m_132320_() * packet.m_132317_();
            double d2 = packet.m_132320_() * packet.m_132318_();
            double d4 = packet.m_132320_() * packet.m_132319_();
            try {
                this.level.m_6493_(packet.m_132322_(), packet.m_132311_(), packet.m_132314_(), packet.m_132315_(), packet.m_132316_(), d0, d2, d4);
            }
            catch (Throwable throwable1) {
                LOGGER.warn("Could not spawn particle effect {}", (Object)packet.m_132322_());
            }
        } else {
            RandomSource random = this.vanillaAccessor().getRandom();
            for (int i = 0; i < packet.m_132321_(); ++i) {
                double d1 = random.m_188583_() * (double)packet.m_132317_();
                double d3 = random.m_188583_() * (double)packet.m_132318_();
                double d5 = random.m_188583_() * (double)packet.m_132319_();
                double d6 = random.m_188583_() * (double)packet.m_132320_();
                double d7 = random.m_188583_() * (double)packet.m_132320_();
                double d8 = random.m_188583_() * (double)packet.m_132320_();
                try {
                    this.level.m_6493_(packet.m_132322_(), packet.m_132311_(), packet.m_132314_() + d1, packet.m_132315_() + d3, packet.m_132316_() + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not spawn particle effect {}", (Object)packet.m_132322_());
                    return;
                }
            }
        }
    }

    public void m_141955_(ClientboundPingPacket packet) {
        this.vanilla().m_141955_(packet);
    }

    public void m_7710_(ClientboundUpdateAttributesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.m_6815_(packet.m_133588_());
        if (entity != null) {
            if (!(entity instanceof LivingEntity)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + entity + ")");
            }
            AttributeMap attributemap = ((LivingEntity)entity).m_21204_();
            for (ClientboundUpdateAttributesPacket.AttributeSnapshot attribute : packet.m_133591_()) {
                AttributeInstance attributeinstance = attributemap.m_22146_(attribute.m_133601_());
                if (attributeinstance == null) {
                    LOGGER.warn("Entity {} does not have attribute {}", (Object)entity, (Object)BuiltInRegistries.f_256951_.m_7981_((Object)attribute.m_133601_()));
                    continue;
                }
                attributeinstance.m_22100_(attribute.m_133602_());
                attributeinstance.m_22132_();
                for (AttributeModifier attributemodifier : attribute.m_133603_()) {
                    attributeinstance.m_22118_(attributemodifier);
                }
            }
        }
    }

    public void m_7339_(ClientboundPlaceGhostRecipePacket packet) {
        this.vanilla().m_7339_(packet);
    }

    public void m_183514_(ClientboundLightUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        level.m_194171_(() -> this.vanillaAccessor().callApplyLightData(packet.m_132349_(), packet.m_132352_(), packet.m_195722_()));
    }

    public void m_7330_(ClientboundMerchantOffersPacket packet) {
        this.vanilla().m_7330_(packet);
    }

    public void m_7299_(ClientboundSetChunkCacheRadiusPacket packet) {
        this.vanilla().m_7299_(packet);
    }

    public void m_183623_(ClientboundSetSimulationDistancePacket packet) {
        this.vanilla().m_183623_(packet);
    }

    public void m_8065_(ClientboundSetChunkCacheCenterPacket packet) {
        this.vanilla().m_8065_(packet);
    }

    public void m_264308_(ClientboundBundlePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        for (Packet sub : packet.m_264216_()) {
            sub.m_5797_((PacketListener)this);
        }
    }

    public void m_214108_(ClientboundBlockChangedAckPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ClientLevelExtender level = this.requiresClientLevelExtender();
        level.handleBlockChangedAckExtender(packet.f_237578_());
    }

    public void m_9933_() {
    }

    public boolean m_6198_() {
        return this.vanilla().m_6198_();
    }
}

