/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.rubidium.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.ColorProviderRegistry;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.system.MemoryUtil;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.client.mod.oculus.OculusManager;
import team.creative.littletiles.client.mod.rubidium.RubidiumInteractor;
import team.creative.littletiles.client.mod.rubidium.buffer.RubidiumBufferCache;
import team.creative.littletiles.client.mod.rubidium.level.LittleWorldSlice;
import team.creative.littletiles.client.mod.rubidium.pipeline.LittleLightDataAccess;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.rubidium.BlockRenderContextAccessor;
import team.creative.littletiles.mixin.rubidium.BlockRendererAccessor;
import team.creative.littletiles.mixin.rubidium.ChunkBuildBuffersAccessor;
import team.creative.littletiles.mixin.rubidium.ChunkBuilderAccessor;
import team.creative.littletiles.mixin.rubidium.ChunkMeshBufferBuilderAccessor;
import team.creative.littletiles.mixin.rubidium.RenderSectionManagerAccessor;
import team.creative.littletiles.mixin.rubidium.SodiumWorldRendererAccessor;
import team.creative.littletiles.mixin.rubidium.TranslucentQuadAnalyzerAccessor;

public class LittleRenderPipelineRubidium
extends LittleRenderPipeline {
    private ChunkBuildBuffers buildBuffers;
    private ChunkVertexType type;
    private LittleWorldSlice slice = LittleWorldSlice.createEmptySlice();
    private BlockRenderer renderer;
    private LittleLightDataAccess lightAccess;
    private LightPipelineProvider lighters;
    private QuadLightData cachedQuadLightData = new QuadLightData();
    public BlockRenderContext context = new BlockRenderContext(null);
    private Set<TextureAtlasSprite> sprites = new ObjectOpenHashSet();
    private BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
    private IntArrayList[] indexes;
    private int[] faceCounters = new int[ModelQuadFacing.COUNT];
    private int[] colors = new int[4];
    private Vec3d cubeCenter = new Vec3d();

    public static RenderChunkExtender getChunk(BlockPos pos) {
        return (RenderChunkExtender)((RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager()).callGetRenderSection(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123342_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public static ChunkVertexType getType() {
        return RenderingThread.getOrCreate(RubidiumInteractor.PIPELINE).type;
    }

    public LittleRenderPipelineRubidium() {
        this.indexes = new IntArrayList[ModelQuadFacing.COUNT];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = new IntArrayList();
        }
    }

    @Override
    public void buildCache(PoseStack pose, ChunkLayerMap<BufferCache> buffers, RenderingBlockContext data, VertexFormat format, SingletonList<BakedQuad> bakedQuadWrapper) {
        LittleSubLevel sub;
        if (this.buildBuffers == null) {
            this.reload();
        }
        Level renderLevel = data.be.m_58904_();
        while (renderLevel instanceof LittleSubLevel && !(sub = (LittleSubLevel)renderLevel).shouldUseLightingForRenderig()) {
            renderLevel = sub.getParent();
        }
        this.slice.parent = renderLevel;
        ((BlockRenderContextAccessor)this.context).setWorld(this.slice);
        BlockPos pos = data.be.m_58899_();
        this.lightAccess.prepare((BlockAndTintGetter)renderLevel);
        LightPipeline lighter = this.lighters.getLighter(((BlockRendererAccessor)this.renderer).getUseAmbientOcclusion() && data.state.getLightEmission((BlockGetter)data.be.m_58904_(), pos) == 0 ? LightMode.SMOOTH : LightMode.FLAT);
        ColorProviderRegistry colorProvider = ((BlockRendererAccessor)this.renderer).getColorProviderRegistry();
        data.chunk.prepareModelOffset(this.modelOffset, pos);
        for (Tuple entry : data.be.render.boxCache.tuples()) {
            Material material = DefaultMaterials.forRenderLayer((RenderType)((RenderType)entry.getKey()));
            ChunkModelBuilder builder = this.buildBuffers.get(material);
            IndexedCollector cubes = (IndexedCollector)entry.value;
            if (cubes == null || cubes.isEmpty()) continue;
            for (int i = 0; i < ModelQuadFacing.VALUES.length; ++i) {
                builder.getVertexBuffer(ModelQuadFacing.VALUES[i]).start(data.chunk.sectionIndex());
            }
            Arrays.fill(this.faceCounters, 0);
            Iterator iterator = cubes.sectionIterator(x -> {
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.indexes[i].add(x);
                    ChunkMeshBufferBuilderAccessor a = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i]);
                    this.indexes[i].add(a.getCount() * a.getStride());
                }
            });
            while (iterator.hasNext()) {
                LittleRenderBox cube = (LittleRenderBox)((Object)iterator.next());
                BlockState state = cube.state;
                this.context.update(pos, (BlockPos)this.modelOffset, state, null, 0L, ModelData.EMPTY, (RenderType)entry.key);
                OculusManager.setLocalPos(this.buildBuffers, pos);
                this.cubeCenter.set((double)(cube.maxX + cube.minX) * 0.5, (double)(cube.maxY + cube.minY) * 0.5, (double)(cube.maxZ + cube.minZ) * 0.5);
                ColorProvider colorizer = null;
                if (OculusManager.isShaders()) {
                    Block block = state.m_60734_();
                    if (block instanceof IFakeRenderingBlock) {
                        IFakeRenderingBlock fake = (IFakeRenderingBlock)block;
                        state = fake.getFakeState(state);
                    }
                    OculusManager.setMaterialId(this.buildBuffers, state);
                }
                for (int h = 0; h < Facing.VALUES.length; ++h) {
                    Facing facing = Facing.VALUES[h];
                    Object quadObject = cube.getQuad(facing);
                    SingletonList<BakedQuad> quads = null;
                    if (quadObject instanceof List) {
                        quads = (SingletonList<BakedQuad>)quadObject;
                    } else if (quadObject instanceof BakedQuad) {
                        BakedQuad quad = (BakedQuad)quadObject;
                        bakedQuadWrapper.setElement((Object)quad);
                        quads = bakedQuadWrapper;
                    }
                    if (quads == null || quads.isEmpty()) continue;
                    Direction direction = facing.toVanilla();
                    for (BakedQuad quad : quads) {
                        lighter.calculate((ModelQuadView)quad, pos, this.cachedQuadLightData, direction, ((BakedQuadView)quad).getLightFace(), quad.m_111307_());
                        if (cube.color != -1) {
                            int color = ColorABGR.pack((int)ColorUtils.red((int)cube.color), (int)ColorUtils.green((int)cube.color), (int)ColorUtils.blue((int)cube.color), (int)ColorUtils.alpha((int)cube.color));
                            Arrays.fill(this.colors, color);
                        } else if (quad.m_111304_()) {
                            if (colorizer == null) {
                                colorizer = colorProvider.getColorProvider(state.m_60734_());
                            }
                            colorizer.getColors((WorldSlice)this.slice, pos, (Object)state, (ModelQuadView)quad, this.colors);
                        } else {
                            Arrays.fill(this.colors, -1);
                        }
                        ((BlockRendererAccessor)this.renderer).callWriteGeometry(this.context, builder, Vec3.f_82478_, material, (BakedQuadView)quad, this.colors, this.cachedQuadLightData);
                        TextureAtlasSprite sprite = quad.m_173410_();
                        if (sprite == null || !SpriteUtil.hasAnimation((TextureAtlasSprite)sprite)) continue;
                        this.sprites.add(sprite);
                    }
                }
                bakedQuadWrapper.setElement(null);
                OculusManager.resetBlockContext(this.buildBuffers);
                if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                cube.deleteQuadCache();
            }
            BufferHolder[] holders = new BufferHolder[ModelQuadFacing.COUNT];
            int count = this.indexes[0].size() / 2;
            for (int i = 0; i < this.indexes.length; ++i) {
                ChunkMeshBufferBuilderAccessor v;
                if (material.pass.isSorted() && i != ModelQuadFacing.UNASSIGNED.ordinal() || (v = (ChunkMeshBufferBuilderAccessor)builder.getVertexBuffer(ModelQuadFacing.VALUES[i])).getCount() <= 0) continue;
                ByteBuffer buffer = ByteBuffer.allocateDirect(v.getStride() * v.getCount());
                ByteBuffer threadBuffer = v.getBuffer();
                threadBuffer.limit(buffer.capacity());
                MemoryUtil.memCopy((ByteBuffer)v.getBuffer(), (ByteBuffer)buffer);
                threadBuffer.limit(threadBuffer.capacity());
                holders[i] = new BufferHolder(buffer, buffer.limit(), v.getCount(), this.indexes[i].toIntArray());
                this.indexes[i].clear();
                if (!material.pass.isSorted()) continue;
                FloatArrayList centers = ((TranslucentQuadAnalyzerAccessor)v.getAnalyzer()).getQuadCenters();
                ByteBuffer centerBuffer = ByteBuffer.allocateDirect(centers.size() * 4);
                for (int j = 0; j < centers.size(); ++j) {
                    centerBuffer.putFloat(centers.getFloat(j));
                }
                centerBuffer.rewind();
                holders[0] = new BufferHolder(centerBuffer, 0, 0, null);
                centers.clear();
            }
            buffers.put((RenderType)entry.key, (Object)new RubidiumBufferCache(holders, new ArrayList<TextureAtlasSprite>(this.sprites), count));
            this.sprites.clear();
        }
        this.slice.parent = null;
    }

    @Override
    public void reload() {
        RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
        if (manager == null) {
            this.buildBuffers = null;
            this.renderer = null;
            return;
        }
        ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
        this.type = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType();
        this.buildBuffers = new ChunkBuildBuffers(this.type);
        this.buildBuffers.init(null, 0);
        this.lightAccess = new LittleLightDataAccess();
        this.lighters = new LightPipelineProvider((LightDataAccess)this.lightAccess);
        this.renderer = new BlockRenderer(new ColorProviderRegistry(Minecraft.m_91087_().m_91298_()), this.lighters);
    }

    @Override
    public void release() {
        this.buildBuffers.destroy();
    }
}

