/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.rubidium.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.LocalSectionIndex;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.spongepowered.asm.mixin.Unique;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.rubidium.RubidiumInteractor;
import team.creative.littletiles.client.mod.rubidium.buffer.RenderedBufferRubidium;
import team.creative.littletiles.client.mod.rubidium.renderer.DefaultChunkRendererExtender;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.entity.LittleAnimationRenderManager;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationRenderManagerRubidium
extends LittleAnimationRenderManager {
    private GlVertexAttributeBinding[] vertexAttributeBindings;
    private GlVertexFormat format;

    public LittleAnimationRenderManagerRubidium(LittleAnimationEntity entity) {
        super(entity);
    }

    public void prepare(GlVertexAttributeBinding[] vertexAttributeBindings, GlVertexFormat format) {
        this.vertexAttributeBindings = vertexAttributeBindings;
        this.format = format;
    }

    @Override
    public void compileChunks(Camera camera) {
        if (!this.needsUpdate || this.vertexAttributeBindings == null) {
            return;
        }
        this.needsUpdate = false;
        this.hasBlocks.clear();
        this.renderableBlockEntities.clear();
        RebuildTask rebuild = new RebuildTask();
        Vec3 cam = camera.m_90583_();
        CompileResults results = rebuild.compile((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_);
        this.globalBlockEntities.clear();
        this.globalBlockEntities.addAll(results.globalBlockEntities);
        this.renderableBlockEntities = results.blockEntities;
        this.prepareUpload();
        for (Tuple entry : results.buffers.tuples()) {
            VertexBuffer buffer = this.getVertexBuffer((RenderType)entry.key);
            if (!buffer.m_231230_() && buffer instanceof VertexBufferExtender) {
                VertexBufferExtender ex = (VertexBufferExtender)buffer;
                buffer.m_85921_();
                ex.setFormat(null);
                int length = ((RenderedBufferRubidium)entry.value).byteBuffer().limit();
                this.uploadVertexBuffer(ex, ((RenderedBufferRubidium)entry.value).byteBuffer());
                ex.setMode(VertexFormat.Mode.QUADS);
                ex.setIndexCount(ex.getMode().m_166958_(length / this.format.getStride()));
                ex.setSequentialIndices(this.uploadIndexBuffer(ex));
                ex.setIndexType(VertexFormat.IndexType.INT);
                ex.setLastUploadedLength(length);
                BufferCollection buffers = rebuild.getBuffers((RenderType)entry.key);
                if (buffers != null) {
                    this.uploaded((RenderType)entry.key, buffers);
                }
                try {
                    ((RenderedBufferRubidium)entry.value).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.hasBlocks.add((RenderType)entry.key);
                continue;
            }
            LittleTiles.LOGGER.error("Could not upload chunk render data due to invalid buffer");
        }
        VertexBuffer.m_85931_();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer uploadIndexBuffer(VertexBufferExtender ex) {
        RenderSystem.AutoStorageIndexBuffer buffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)ex.getMode());
        if (buffer != ex.getSequentialIndices() || !buffer.m_221944_(ex.getIndexCount())) {
            buffer.m_221946_(ex.getIndexCount());
        }
        return buffer;
    }

    @Unique
    private void uploadVertexBuffer(VertexBufferExtender buffer, ByteBuffer byteBuffer) {
        GlStateManager._glBindBuffer((int)34962, (int)buffer.getVertexBufferId());
        for (GlVertexAttributeBinding attrib : this.vertexAttributeBindings) {
            if (attrib.isIntType()) {
                GL30C.glVertexAttribIPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (int)attrib.getStride(), (long)attrib.getPointer());
            } else {
                GL20C.glVertexAttribPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (boolean)attrib.isNormalized(), (int)attrib.getStride(), (long)attrib.getPointer());
            }
            GL20C.glEnableVertexAttribArray((int)attrib.getIndex());
        }
        RenderSystem.glBufferData((int)34962, (ByteBuffer)byteBuffer, (int)35044);
    }

    @Override
    public int sectionIndex() {
        int rX = ((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123341_() & 7;
        int rY = ((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123342_() & 3;
        int rZ = ((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123343_() & 7;
        return LocalSectionIndex.pack((int)rX, (int)rY, (int)rZ);
    }

    @Override
    public void prepareModelOffset(BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
        modelOffset.m_122178_(pos.m_123341_() - (((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123341_() << 4), pos.m_123342_() - (((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123342_() << 4), pos.m_123343_() - (((LittleAnimationEntity)this.entity).getCenter().chunkOffset.m_123343_() << 4));
    }

    public void renderChunkLayerRubidium(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, ChunkShaderInterface shader, CameraTransform camera) {
        if (this.hasBlocks.contains(layer)) {
            VertexBuffer vertexbuffer = (VertexBuffer)this.buffers.get(layer);
            if (vertexbuffer == null) {
                return;
            }
            DefaultChunkRendererExtender.setRenderRegionOffset(shader, ((LittleAnimationEntity)this.entity).getCenter().baseOffset, camera);
            vertexbuffer.m_85921_();
            vertexbuffer.m_166882_();
        }
    }

    @Override
    public BufferBuilder.SortState getTransparencyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQuadSorting(BufferBuilder builder, double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LittleRenderPipelineType getPipeline() {
        return RubidiumInteractor.PIPELINE;
    }

    @Override
    public Vec3 offsetCorrection(RenderChunkExtender chunk) {
        return null;
    }

    private class RebuildTask
    implements RebuildTaskExtender {
        private ChunkLayerMap<BufferCollection> caches;

        private RebuildTask() {
        }

        private CompileResults compile(float x, float y, float z) {
            CompileResults results = new CompileResults();
            LittleRenderPipelineType.startCompile(LittleAnimationRenderManagerRubidium.this, this);
            for (BETiles block : LittleAnimationRenderManagerRubidium.this.getLevel()) {
                this.handleBlockEntity(results, block);
            }
            if (this.caches != null) {
                for (Tuple layer : this.caches.tuples()) {
                    results.buffers.put((RenderType)layer.key, (Object)new RenderedBufferRubidium((BufferCollection)layer.value));
                }
            }
            LittleRenderPipelineType.endCompile(LittleAnimationRenderManagerRubidium.this, this);
            return results;
        }

        private void handleBlockEntity(CompileResults results, BETiles entity) {
            LittleRenderPipelineType.compile(LittleAnimationRenderManagerRubidium.this, entity, this);
            BlockEntityRenderer blockentityrenderer = Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)entity);
            if (blockentityrenderer != null) {
                if (blockentityrenderer.m_5932_((BlockEntity)entity)) {
                    results.globalBlockEntities.add((BlockEntity)entity);
                } else {
                    results.blockEntities.add((BlockEntity)entity);
                }
            }
        }

        public BufferCollection getBuffers(RenderType layer) {
            if (this.caches == null) {
                return null;
            }
            return (BufferCollection)this.caches.get(layer);
        }

        public BufferCollection getOrCreateBuffers(RenderType layer) {
            BufferCollection cache;
            if (this.caches == null) {
                this.caches = new ChunkLayerMap();
            }
            if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
                cache = new BufferCollection();
                this.caches.put(layer, (Object)cache);
            }
            return cache;
        }

        @Override
        public BufferCache upload(RenderType layer, BufferCache cache) {
            this.getOrCreateBuffers(layer).queueForUpload(cache);
            return cache;
        }
    }

    static final class CompileResults {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final ChunkLayerMap<RenderedBufferRubidium> buffers = new ChunkLayerMap();

        CompileResults() {
        }

        public boolean isEmpty() {
            return this.buffers.isEmpty() && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
        }
    }
}

