/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.rubidium.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.util.VertexRange;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;

public class RubidiumChunkBufferUploader
implements ChunkBufferUploader {
    private ByteBuffer[] buffers = new ByteBuffer[ModelQuadFacing.COUNT];
    private NativeBuffer buffer;
    private VertexRange[] ranges = new VertexRange[ModelQuadFacing.COUNT];
    private List<TextureAtlasSprite> sprites;

    public void set(long data, GlVertexFormat format, int offset, ByteBuffer exisitingData, int extraLength, int[] extraLengthFacing, TextureAtlasSprite[] existing) {
        int i;
        this.buffer = new NativeBuffer((exisitingData != null ? exisitingData.limit() : 0) + extraLength);
        ByteBuffer buffer = this.buffer.getDirectBuffer();
        int currentOffset = 0;
        for (i = 0; i < this.buffers.length; ++i) {
            int originalStart = (SectionRenderDataUnsafe.getVertexOffset((long)data, (int)i) - offset) * format.getStride();
            int originalLength = SectionRenderDataUnsafe.getElementCount((long)data, (int)i) / 6 * 4 * format.getStride();
            int newStart = originalStart + currentOffset;
            int newLength = originalLength + extraLengthFacing[i];
            this.buffers[i] = buffer.slice(newStart, newLength);
            this.buffers[i].put(0, exisitingData, originalStart, originalLength);
            this.buffers[i].position(originalLength);
            currentOffset += extraLengthFacing[i];
            this.ranges[i] = new VertexRange(newStart / format.getStride(), newLength / format.getStride());
        }
        if (existing != null) {
            this.sprites = new ArrayList<TextureAtlasSprite>();
            for (i = 0; i < existing.length; ++i) {
                this.sprites.add(existing[i]);
            }
        }
    }

    public void clear() {
        Arrays.fill(this.buffers, null);
        this.buffer.free();
        this.buffer = null;
    }

    @Override
    public void addSprite(TextureAtlasSprite texture) {
        if (this.sprites == null) {
            this.sprites = new ArrayList<TextureAtlasSprite>();
        }
        if (!this.sprites.contains(texture)) {
            this.sprites.add(texture);
        }
    }

    @Override
    public int uploadIndex() {
        return this.buffers[ModelQuadFacing.UNASSIGNED.ordinal()].position();
    }

    @Override
    public void upload(ByteBuffer buffer) {
        this.buffers[ModelQuadFacing.UNASSIGNED.ordinal()].put(buffer);
        buffer.rewind();
    }

    @Override
    public int uploadIndex(int facing) {
        return this.buffers[facing].position();
    }

    @Override
    public void upload(int facing, ByteBuffer buffer) {
        this.buffers[facing].put(buffer);
        buffer.rewind();
    }

    @Override
    public boolean hasFacingSupport() {
        return true;
    }

    public TextureAtlasSprite[] sprites() {
        if (this.sprites == null) {
            return null;
        }
        return this.sprites.toArray(new TextureAtlasSprite[this.sprites.size()]);
    }

    public VertexRange[] ranges() {
        return this.ranges;
    }

    public NativeBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean isSorted() {
        return false;
    }
}

