/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.rubidium.buffer;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttribute;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.impl.CompactChunkVertex;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.render.chunk.sorting.TranslucentQuadAnalyzer;
import team.creative.littletiles.client.mod.rubidium.pipeline.LittleRenderPipelineRubidium;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.mixin.rubidium.ChunkMeshBufferBuilderAccessor;
import team.creative.littletiles.mixin.rubidium.TranslucentQuadAnalyzerAccessor;

public class RubidiumBufferCache
implements BufferCache {
    private final BufferHolder[] buffers;
    private List<TextureAtlasSprite> textures;
    private int groupCount;
    private boolean invalid;

    public RubidiumBufferCache(BufferHolder[] buffers, List<TextureAtlasSprite> textures, int groupCount) {
        this.buffers = buffers;
        this.textures = textures;
        this.groupCount = groupCount;
    }

    public BufferHolder buffer(ModelQuadFacing facing) {
        return this.buffers[facing.ordinal()];
    }

    public List<TextureAtlasSprite> getUsedTextures() {
        return this.textures;
    }

    @Override
    public BufferCache extract(int index) {
        BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
        for (int i = 0; i < buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            buffers[i] = this.buffers[i].extract(index);
        }
        --this.groupCount;
        return new RubidiumBufferCache(buffers, this.textures, 1);
    }

    @Override
    public BufferCache combine(BufferCache cache) {
        if (cache instanceof RubidiumBufferCache) {
            RubidiumBufferCache r = (RubidiumBufferCache)cache;
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
            for (TextureAtlasSprite texture : r.getUsedTextures()) {
                if (sprites.contains(texture)) continue;
                sprites.add(texture);
            }
            BufferHolder[] buffers = new BufferHolder[ModelQuadFacing.COUNT];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = BufferHolder.combine(this.buffers[i], r.buffer(ModelQuadFacing.VALUES[i]));
            }
            return new RubidiumBufferCache(buffers, sprites, this.groupCount + r.groupCount());
        }
        if (!(cache instanceof BufferHolder)) {
            return null;
        }
        BufferHolder[] buffers = Arrays.copyOf(this.buffers, ModelQuadFacing.COUNT);
        int un = ModelQuadFacing.UNASSIGNED.ordinal();
        buffers[un] = BufferHolder.combine(this.buffers[un], (BufferHolder)cache);
        return new RubidiumBufferCache(buffers, this.textures, this.groupCount + cache.groupCount());
    }

    @Override
    public void applyOffset(Vec3 vec) {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].applyOffset(vec);
        }
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    @Override
    public boolean isAvailable() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].isAvailable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int lengthToUpload() {
        int length = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || !this.buffers[i].isAvailable()) continue;
            length += this.buffers[i].lengthToUpload();
        }
        return length;
    }

    @Override
    public int lengthToUpload(int facing) {
        if (this.buffers[facing] != null && this.buffers[facing].isAvailable()) {
            return this.buffers[facing].lengthToUpload();
        }
        return 0;
    }

    @Override
    public int groupCount() {
        return this.groupCount;
    }

    @Override
    public void eraseBuffer() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].eraseBuffer();
        }
    }

    @Override
    public boolean upload(ChunkBufferUploader uploader) {
        for (TextureAtlasSprite texture : this.textures) {
            uploader.addSprite(texture);
        }
        if (uploader.hasFacingSupport()) {
            if (uploader.isSorted()) {
                ByteBuffer buffer;
                ChunkMeshBufferBuilderAccessor builder = (ChunkMeshBufferBuilderAccessor)((ChunkModelBuilder)uploader).getVertexBuffer(ModelQuadFacing.UNASSIGNED);
                FloatArrayList centers = ((TranslucentQuadAnalyzerAccessor)builder.getAnalyzer()).getQuadCenters();
                int index = ModelQuadFacing.UNASSIGNED.ordinal();
                if (this.buffers[index] == null || this.buffers[index].byteBuffer() == null) {
                    return false;
                }
                ByteBuffer byteBuffer = buffer = this.buffers[0] != null ? this.buffers[0].byteBuffer() : null;
                if (buffer == null) {
                    ChunkVertexType type = LittleRenderPipelineRubidium.getType();
                    ByteBuffer renderData = this.buffers[index].byteBuffer();
                    GlVertexAttribute positionAttribute = type.getVertexFormat().getAttribute((Enum)ChunkMeshAttribute.POSITION_MATERIAL_MESH);
                    boolean compact = positionAttribute.getFormat() == GlVertexAttributeFormat.UNSIGNED_SHORT.typeId();
                    int stride = type.getVertexFormat().getStride();
                    int strideRemaining = stride - (compact ? GlVertexAttributeFormat.UNSIGNED_SHORT.size() : GlVertexAttributeFormat.FLOAT.size()) * 3;
                    ChunkVertexEncoder.Vertex vertex = new ChunkVertexEncoder.Vertex();
                    TranslucentQuadAnalyzer trans = builder.getAnalyzer();
                    while (renderData.hasRemaining()) {
                        if (compact) {
                            vertex.x = CompactChunkVertex.decodePosition((short)renderData.getShort());
                            vertex.y = CompactChunkVertex.decodePosition((short)renderData.getShort());
                            vertex.z = CompactChunkVertex.decodePosition((short)renderData.getShort());
                        } else {
                            vertex.x = renderData.getFloat();
                            vertex.y = renderData.getFloat();
                            vertex.z = renderData.getFloat();
                        }
                        trans.capture(vertex);
                        int newPosition = renderData.position() + strideRemaining;
                        if (newPosition >= renderData.limit()) break;
                        renderData.position(newPosition);
                    }
                    renderData.rewind();
                } else {
                    while (buffer.hasRemaining()) {
                        centers.add(buffer.getFloat());
                    }
                    buffer.rewind();
                }
                this.buffers[0] = null;
                return this.buffers[index].upload(index, uploader);
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || this.buffers[i].upload(i, uploader)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].upload(uploader)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean download(ChunkBufferDownloader downloader) {
        if (downloader.hasFacingSupport()) {
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || this.buffers[i].download(downloader.downloaded(i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i].download(downloader.downloaded())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void markAsAdditional() {
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].markAsAdditional();
        }
    }
}

