/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.utils.BooleanUtils;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.entity.LevelTransitionListener;
import team.creative.littletiles.client.mod.rubidium.RubidiumManager;
import team.creative.littletiles.client.render.level.LittleRenderChunk;
import team.creative.littletiles.client.render.level.RenderUploader;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;
import team.creative.littletiles.mixin.client.render.GameRendererAccessor;
import team.creative.littletiles.mixin.common.entity.EntityAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationHandlerClient
extends LittleAnimationHandler
implements Iterable<LittleEntity> {
    private static Minecraft mc = Minecraft.m_91087_();
    private static final int LONG_TICK_INTERVAL = 40;
    public static final int MAX_INTERVALS_WAITING = 2;
    private final HashMap<UUID, EntityTransitionHolder> transitions = new HashMap();
    private final PriorityBlockingQueue<LittleRenderChunk.ChunkCompileTask> toBatchHighPriority = Queues.newPriorityBlockingQueue();
    private final Queue<LittleRenderChunk.ChunkCompileTask> toBatchLowPriority = Queues.newLinkedBlockingDeque();
    private int highPriorityQuota = 2;
    private final Queue<ChunkBufferBuilderPack> freeBuffers;
    private final Queue<Runnable> toUpload = Queues.newConcurrentLinkedQueue();
    private volatile int toBatchCount;
    private volatile int freeBufferCount;
    public final ChunkBufferBuilderPack fixedBuffers;
    private final ProcessorMailbox<Runnable> mailbox;
    private final Executor executor;
    private int longTickCounter = 40;
    public int longTickIndex = Integer.MIN_VALUE;

    public LittleAnimationHandlerClient(Level level) {
        super(level);
        int threadCount = LittleTiles.CONFIG.rendering.entityCacheBuildThreads;
        this.fixedBuffers = mc.m_91269_().m_110098_();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)threadCount);
        try {
            for (int i = 0; i < threadCount; ++i) {
                list.add(new ChunkBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError error) {
            LittleTiles.LOGGER.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)threadCount);
            int newSize = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int i = 0; i < newSize; ++i) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.freeBuffers = Queues.newArrayDeque((Iterable)list);
        this.freeBufferCount = this.freeBuffers.size();
        this.executor = Util.m_183991_();
        this.mailbox = ProcessorMailbox.m_18751_((Executor)this.executor, (String)"Chunk Renderer");
        this.mailbox.m_6937_(this::runTask);
    }

    public boolean checkInTransition(Entity entity) {
        if (this.transitions.containsKey(entity.m_20148_())) {
            ((EntityAccessor)entity).callUnsetRemoved();
            return true;
        }
        return false;
    }

    public Entity pollEntityInTransition(ClientboundAddEntityPacket packet) {
        LevelTransitionListener listener;
        EntityTransitionHolder holder = this.transitions.get(packet.m_131499_());
        if (holder == null) {
            return null;
        }
        Entity entity = holder.entity;
        Level oldLevel = entity.m_9236_();
        if (entity instanceof LevelTransitionListener) {
            listener = (LevelTransitionListener)entity;
            listener.prepareChangeLevel(oldLevel, holder.newLevel);
        }
        ((EntityAccessor)entity).callSetLevel(holder.newLevel);
        this.transitions.remove(packet.m_131499_());
        if (entity instanceof LevelTransitionListener) {
            listener = (LevelTransitionListener)entity;
            listener.changedLevel(oldLevel, holder.newLevel);
        }
        return entity;
    }

    public void queueEntityForTransition(Entity entity, Level newLevel) {
        this.transitions.put(entity.m_20148_(), new EntityTransitionHolder(entity, newLevel, this.longTickIndex + 2));
    }

    private void runTask() {
        LittleRenderChunk.ChunkCompileTask task;
        if (!this.freeBuffers.isEmpty() && (task = this.pollTask()) != null) {
            ChunkBufferBuilderPack pack = this.freeBuffers.poll();
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            this.freeBufferCount = this.freeBuffers.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_((String)task.name(), () -> task.doTask(pack)), this.executor).thenCompose(x -> x)).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)throwable, (String)"Batching chunks"));
                } else {
                    this.mailbox.m_6937_(() -> {
                        if (result == LittleRenderChunk.ChunkTaskResult.SUCCESSFUL) {
                            pack.m_108838_();
                        } else {
                            pack.m_108841_();
                        }
                        this.freeBuffers.add(pack);
                        this.freeBufferCount = this.freeBuffers.size();
                        this.runTask();
                    });
                }
            });
        }
    }

    @Nullable
    private LittleRenderChunk.ChunkCompileTask pollTask() {
        LittleRenderChunk.ChunkCompileTask task;
        if (this.highPriorityQuota <= 0 && (task = this.toBatchLowPriority.poll()) != null) {
            this.highPriorityQuota = 2;
            return task;
        }
        LittleRenderChunk.ChunkCompileTask task2 = this.toBatchHighPriority.poll();
        if (task2 != null) {
            --this.highPriorityQuota;
            return task2;
        }
        this.highPriorityQuota = 2;
        return this.toBatchLowPriority.poll();
    }

    public String getStats() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.freeBufferCount);
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.freeBufferCount;
    }

    public void uploadAllPendingUploads() {
        Runnable runnable;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
        }
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(LittleRenderChunk.ChunkCompileTask task) {
        this.mailbox.m_6937_(() -> {
            if (task.isHighPriority) {
                this.toBatchHighPriority.offer(task);
            } else {
                this.toBatchLowPriority.offer(task);
            }
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            this.runTask();
        });
    }

    public CompletableFuture<Void> uploadChunkLayer(BufferBuilder.RenderedBuffer rendered, VertexBuffer buffer) {
        return CompletableFuture.runAsync(() -> {
            if (!buffer.m_231230_()) {
                buffer.m_85921_();
                buffer.m_231221_(rendered);
                VertexBuffer.m_85931_();
            }
        }, this.toUpload::add);
    }

    private void clearBatchQueue() {
        while (!this.toBatchHighPriority.isEmpty()) {
            LittleRenderChunk.ChunkCompileTask task = this.toBatchHighPriority.poll();
            if (task == null) continue;
            task.cancel();
        }
        while (!this.toBatchLowPriority.isEmpty()) {
            LittleRenderChunk.ChunkCompileTask task1 = this.toBatchLowPriority.poll();
            if (task1 == null) continue;
            task1.cancel();
        }
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.clearBatchQueue();
        this.mailbox.close();
        this.freeBuffers.clear();
    }

    public void allChanged() {
        for (LittleEntity animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().allChanged();
        }
    }

    @Override
    public synchronized Iterator<LittleEntity> iterator() {
        return new FilterIterator((Iterable)this.entities, x -> x.hasLoaded() && BooleanUtils.isTrue((Boolean)x.getRenderManager().isInSight));
    }

    public void needsUpdate() {
        for (LittleEntity animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().needsFullRenderChunkUpdate = true;
        }
    }

    public void setupRender(Camera camera, Frustum frustum, boolean capturedFrustum, boolean spectator) {
        mc.m_91307_().m_6180_("setup_animation_render");
        for (LittleEntity animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().setupRender(camera, frustum, capturedFrustum, spectator);
        }
        mc.m_91307_().m_7238_();
    }

    protected void longTick() {
        if (!this.transitions.isEmpty()) {
            Iterator<EntityTransitionHolder> iterator = this.transitions.values().iterator();
            while (iterator.hasNext()) {
                EntityTransitionHolder holder = iterator.next();
                if (this.longTickIndex < holder.index) continue;
                iterator.remove();
            }
        }
        RenderUploader.longTick(this.longTickIndex);
    }

    @Override
    public void tick(TickEvent.LevelTickEvent event) {
        super.tick(event);
        if (event.phase == TickEvent.Phase.END) {
            --this.longTickCounter;
            if (this.longTickCounter <= 0) {
                this.longTickCounter = 40;
                this.longTick();
                ++this.longTickIndex;
            }
        }
    }

    public void compileChunks(Camera camera) {
        Runnable run;
        mc.m_91307_().m_6180_("compile_animation_chunks");
        while ((run = this.toUpload.poll()) != null) {
            run.run();
        }
        for (LittleEntity animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().compileChunks(camera);
        }
        mc.m_91307_().m_7238_();
    }

    public void resortTransparency(RenderType layer, double x, double y, double z) {
        for (LittleEntity animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().resortTransparency(layer, x, y, z);
        }
    }

    public void renderBlockEntitiesAndDestruction(PoseStack pose, Frustum frustum, float frameTime) {
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Vec3 cam = LittleAnimationHandlerClient.mc.f_91063_.m_109153_().m_90583_();
        for (LittleEntity<Object> animation : this) {
            animation.getRenderManager().renderBlockEntitiesAndDestruction(pose, frustum, cam, frameTime, (MultiBufferSource)bufferSource);
        }
        for (LittleEntity<Object> animation : this.entities) {
            if (!animation.hasLoaded()) continue;
            animation.getRenderManager().renderGlobalEntities(pose, frustum, cam, frameTime, (MultiBufferSource)bufferSource);
        }
    }

    @SubscribeEvent
    public void renderChunkLayer(RenderLevelStageEvent event) {
        if (RubidiumManager.installed()) {
            return;
        }
        RenderType layer = null;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            layer = RenderType.m_110451_();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            layer = RenderType.m_110463_();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS) {
            layer = RenderType.m_110457_();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            layer = RenderType.m_110466_();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            layer = RenderType.m_110503_();
        }
        if (layer == null) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        Matrix4f projectionMatrix = event.getProjectionMatrix();
        ShaderInstance shaderinstance = RenderSystem.getShader();
        for (int i = 0; i < 12; ++i) {
            int j1 = RenderSystem.getShaderTexture((int)i);
            shaderinstance.m_173350_("Sampler" + i, (Object)j1);
        }
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(pose.m_85850_().m_252922_());
        }
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(projectionMatrix);
        }
        if (shaderinstance.f_173312_ != null) {
            shaderinstance.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shaderinstance.f_267422_ != null) {
            shaderinstance.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (shaderinstance.f_173315_ != null) {
            shaderinstance.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shaderinstance.f_173316_ != null) {
            shaderinstance.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shaderinstance.f_173317_ != null) {
            shaderinstance.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shaderinstance.f_202432_ != null) {
            shaderinstance.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shaderinstance.f_173310_ != null) {
            shaderinstance.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shaderinstance.f_173319_ != null) {
            shaderinstance.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        Vec3 cam = LittleAnimationHandlerClient.mc.f_91063_.m_109153_().m_90583_();
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        shaderinstance.m_173363_();
        Uniform offset = RenderSystem.getShader().f_173320_;
        float partialTicks = mc.getPartialTick();
        for (LittleEntity animation : this) {
            pose.m_85836_();
            animation.getOrigin().setupRendering(pose, cam.f_82479_, cam.f_82480_, cam.f_82481_, partialTicks);
            if (shaderinstance.f_173308_ != null) {
                shaderinstance.f_173308_.m_5679_(pose.m_85850_().m_252922_());
            }
            shaderinstance.m_173363_();
            animation.getRenderManager().renderChunkLayer(layer, pose, cam.f_82479_, cam.f_82480_, cam.f_82481_, projectionMatrix, offset);
            pose.m_85849_();
        }
        shaderinstance.m_173362_();
    }

    @SubscribeEvent
    public void renderEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (LittleEntity animation : this.entities) {
                if (!animation.hasLoaded()) continue;
                animation.getRenderManager().isInSight = null;
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.transitions.clear();
        RenderUploader.unload();
    }

    @Override
    protected void tickEntity(LittleEntity entity) {
        if (!entity.hasLoaded()) {
            return;
        }
        entity.getRenderManager().clientTick();
        super.tickEntity(entity);
    }

    private boolean shouldRenderBlockOutline() {
        boolean flag;
        if (!((GameRendererAccessor)LittleAnimationHandlerClient.mc.f_91063_).getRenderBlockOutline() || !(LittleAnimationHandlerClient.mc.f_91077_ instanceof LittleHitResult)) {
            return false;
        }
        LittleHitResult result = (LittleHitResult)LittleAnimationHandlerClient.mc.f_91077_;
        Entity entity = mc.m_91288_();
        boolean bl = flag = entity instanceof Player && !LittleAnimationHandlerClient.mc.f_91066_.f_92062_;
        if (flag && !((Player)entity).m_150110_().f_35938_) {
            ItemStack itemstack = ((LivingEntity)entity).m_21205_();
            if (result.isBlock()) {
                BlockPos blockpos = result.asBlockHit().m_82425_();
                BlockState blockstate = result.level.m_8055_(blockpos);
                if (LittleAnimationHandlerClient.mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
                    flag = blockstate.m_60750_((Level)result.level, blockpos) != null;
                } else {
                    BlockInWorld blockinworld = new BlockInWorld((LevelReader)result.level, blockpos, false);
                    Registry registry = result.level.m_9598_().m_175515_(Registries.f_256747_);
                    flag = !itemstack.m_41619_() && (itemstack.m_204128_(registry, blockinworld) || itemstack.m_204121_(registry, blockinworld));
                }
            }
        }
        return flag;
    }

    @SubscribeEvent
    public void tick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        if (!this.shouldRenderBlockOutline()) {
            return;
        }
        LittleHitResult result = (LittleHitResult)LittleAnimationHandlerClient.mc.f_91077_;
        PoseStack pose = event.getPoseStack();
        pose.m_85836_();
        RenderSystem.applyModelViewMatrix();
        BlockPos pos = result.asBlockHit().m_82425_();
        BlockState state = result.level.m_8055_(pos);
        VertexConsumer vertexconsumer2 = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        LittleEntity entity = result.getHolder();
        Vec3 position = LittleAnimationHandlerClient.mc.f_91063_.m_109153_().m_90583_();
        entity.getOrigin().setupRendering(event.getPoseStack(), position.f_82479_, position.f_82480_, position.f_82481_, event.getPartialTick());
        RenderSystem.enableDepthTest();
        double x = (double)pos.m_123341_() - position.m_7096_();
        double y = (double)pos.m_123342_() - position.m_7098_();
        double z = (double)pos.m_123343_() - position.m_7094_();
        if (!state.m_60795_() && this.level.m_6857_().m_61937_(pos)) {
            VoxelShape shape;
            PoseStack.Pose posestack$pose = event.getPoseStack().m_85850_();
            Block block = state.m_60734_();
            if (block instanceof BlockTile) {
                BlockTile block2 = (BlockTile)block;
                shape = block2.getSelectionShape((BlockGetter)result.level, pos);
            } else {
                shape = state.m_60651_((BlockGetter)result.level, pos, CollisionContext.m_82750_((Entity)LittleAnimationHandlerClient.mc.f_91075_));
            }
            shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
                float f = (float)(x2 - x1);
                float f1 = (float)(y2 - y1);
                float f2 = (float)(z2 - z1);
                float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
                vertexconsumer2.m_252986_(posestack$pose.m_252922_(), (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
                vertexconsumer2.m_252986_(posestack$pose.m_252922_(), (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
            });
        }
        pose.m_85849_();
    }

    public record EntityTransitionHolder(Entity entity, Level newLevel, int index) {
    }
}

